/*
 * Decompiled with CFR 0.152.
 */
package com.idata.integration;

import com.idata.core.meta.db.DestinationMetaData;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.etl.DataSource;
import com.idata.etl.DataSourceFactory;
import com.idata.etl.impl.SimpleTransferSession;
import com.idata.integration.ConnectionOjbect;
import java.sql.SQLException;
import org.junit.Before;
import org.junit.Test;

public class IntegrationTransferTest
extends ConnectionOjbect {
    private SimpleTransferSession session;

    @Override
    @Before
    public void setUp() throws SQLException {
        super.setUp();
        this.session = new SimpleTransferSession();
        this.session.setSessionID(System.currentTimeMillis());
    }

    @Test
    public void mysql2Orcl() throws Exception {
        this.session.setSessionName("mysql2oracle");
        DataSource ds = DataSourceFactory.createDataSource(this.mysql, "SELECT * FROM ALL_DBTYPE");
        SourceMetaData smd = ds.getSourceMetaData();
        this.session.setDataSource(ds);
        this.session.setDestConnection(this.orcl);
        DestinationMetaData dmd = smd.createDestinationMetaData(this.orcl);
        dmd.remove("TIMESTAMP_COL");
        dmd.setName("MYSQL_ORACLE");
        dmd.setSchema("IDATA");
        this.session.setDestinationMetaData(dmd);
        this.session.init();
        this.session.validate();
        this.session.execute();
    }

    @Test
    public void orcl2Mysql() throws Exception {
        this.session.setSessionName("orcl2Mysql");
        DataSource ds = DataSourceFactory.createDataSource(this.orcl, "SELECT * FROM ALL_DBTYPE");
        SourceMetaData smd = ds.getSourceMetaData();
        this.session.setDataSource(ds);
        this.session.setDestConnection(this.mysql);
        DestinationMetaData dmd = smd.createDestinationMetaData(this.mysql);
        dmd.setName("oracle_mysql");
        this.session.setDestinationMetaData(dmd);
        this.session.init();
        this.session.validate();
        this.session.execute();
    }

    @Test
    public void mysql2db2() throws Exception {
        this.session.setSessionName("mysql2db2");
        DataSource ds = DataSourceFactory.createDataSource(this.mysql, "SELECT * FROM ALL_DBTYPE");
        SourceMetaData smd = ds.getSourceMetaData();
        this.session.setDataSource(ds);
        this.session.setDestConnection(this.db2);
        DestinationMetaData dmd = smd.createDestinationMetaData(this.orcl);
        dmd.setName("mysql_db22");
        dmd.setSchema("DB2ADMIN");
        this.session.setDestinationMetaData(dmd);
        this.session.init();
        this.session.validate();
        this.session.execute();
    }
}

