/*
 * Decompiled with CFR 0.152.
 */
package com.idata.mssql;

import com.idata.common.ResultSetUtil;
import com.idata.mssql.MssqlConnection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Test;

public class DBMetaTest
extends MssqlConnection {
    @Test
    public void getProductName() throws SQLException {
        DatabaseMetaData dbmd = this.mssql.getMetaData();
        Assert.assertEquals((Object)"Microsoft SQL Server", (Object)dbmd.getDatabaseProductName());
    }

    @Test
    public void getSchema() throws SQLException {
        ResultSet rs = this.mssql.getMetaData().getSchemas();
        while (rs.next()) {
            System.out.println(rs.getString(1) + "|" + rs.getString(2));
        }
    }

    @Test
    public void getCatalog() throws SQLException {
        ResultSet rs = this.mssql.getMetaData().getCatalogs();
        while (rs.next()) {
            System.out.println(rs.getString(1));
        }
    }

    @Test
    public void getTable() throws SQLException {
        String[] types = new String[]{"TABLE", "VIEW"};
        ResultSet rs = this.mssql.getMetaData().getTables(null, null, "ALL_DBTYPE", types);
        Assert.assertEquals((Object)rs.next(), (Object)true);
    }

    @Test
    public void getTableLowerCase() throws SQLException {
        String[] types = new String[]{"table", "view"};
        ResultSet rs = this.mssql.getMetaData().getTables(null, null, "all_dbtype", types);
        Assert.assertEquals((Object)rs.next(), (Object)true);
    }

    @Test
    public void getQueryColumns() throws SQLException {
        ResultSetMetaData meta = this.mssql.createStatement().executeQuery("select * from all_dbtype where 1=0").getMetaData();
        System.out.println("ColumnName |  ColumnType ID |  TypeName | ColumnDisplaySize | Precision | Scale");
        for (int i = 1; i < meta.getColumnCount() + 1; ++i) {
            System.out.println(meta.getColumnName(i) + "|" + meta.getColumnType(i) + "|" + meta.getColumnTypeName(i) + "|" + meta.getColumnDisplaySize(i) + "|" + meta.getPrecision(i) + "|" + meta.getScale(i));
        }
    }

    @Test
    public void getMetaColumns() throws SQLException {
        System.out.println("==========testColumns==============");
        ResultSet rs = this.mssql.getMetaData().getColumns(null, null, "ALL_DBTYPE", null);
        ResultSetUtil.print(rs);
    }
}

