/*
 * Decompiled with CFR 0.152.
 */
package com.idata.mysql;

import com.idata.config.db.TypeConfigException;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.DestinationMetaData;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.core.meta.db.oracle.CommonTableHelper;
import com.idata.etl.ParseException;
import com.idata.etl.QueryDataSource;
import com.idata.mysql.MySqlConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Test;

public class SourceMetaDataTest
extends MySqlConnection {
    @Test
    public void testSourceMeta() throws SQLException, ParseException, TypeConfigException {
        QueryDataSource ds = new QueryDataSource(this.mysql, "select * from all_dbtype");
        SourceMetaData smd = ds.getSourceMetaData();
        DestinationMetaData dm = smd.createDestinationMetaData("Mysql");
        DataItem e = dm.get(6);
        Assert.assertEquals((Object)e.getName(), (Object)"MEDIU_INT");
        Assert.assertEquals((Object)e.getTypeName(), (Object)"INTEGER");
        Assert.assertEquals((Object)e.getCatalog(), (Object)"number");
    }

    @Test
    public void testDestMeta() throws SQLException, ParseException, TypeConfigException {
        QueryDataSource ds = new QueryDataSource(this.mysql, "select * from all_dbtype");
        SourceMetaData smd = ds.getSourceMetaData();
        DestinationMetaData dm = smd.createDestinationMetaData("Mysql");
        CommonTableHelper helper = new CommonTableHelper();
        helper.setConnection(this.mysql);
        dm.setName("target_table");
        dm.setSchema("test");
        helper.setDestinationMetaData(dm);
        if (helper.exist()) {
            helper.drop();
        }
        helper.create();
    }

    @Test
    public void toOracleDB() throws SQLException, ParseException, TypeConfigException {
        QueryDataSource ds = new QueryDataSource(this.mysql, "select * from all_dbtype");
        SourceMetaData smd = ds.getSourceMetaData();
        DestinationMetaData dm = smd.createDestinationMetaData("Oracle");
        dm.setSchema("idata");
        dm.setName("mysql_oracle");
        Connection orcl = DriverManager.getConnection("jdbc:oracle:thin:@(DESCRIPTION =  (ADDRESS_LIST =       (ADDRESS = (PROTOCOL = TCP)(HOST = 10.224.69.79)(PORT = 1521))  )  (CONNECT_DATA =       (SERVICE_NAME = ORCL)   )   ) ", "idata", "pass");
        CommonTableHelper helper = new CommonTableHelper();
        helper.setDestinationMetaData(dm);
        helper.setConnection(orcl);
        if (helper.exist()) {
            helper.drop();
        }
        helper.create();
    }
}

