/*
 * Decompiled with CFR 0.152.
 */
package com.idata.oracle;

import com.idata.oracle.OracleConnection;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class OracleLOBTest
extends OracleConnection {
    @Test
    public void insertValuesViaObject() throws Exception {
        PreparedStatement pstm = this.gdc3.prepareStatement("insert into all_dbtype (col4,col13, col14) values (?,?,?)");
        pstm.setObject(1, 99);
        pstm.setObject(2, "clob test as String");
        pstm.setObject(3, "Nclob test as String");
        pstm.execute();
        pstm.close();
    }

    @Test
    public void insertLOB() throws Exception {
        PreparedStatement pstm = this.gdc3.prepareStatement("insert into all_dbtype (col4,col13, col14, col15, col6 ) values (?,?,?,?,?)");
        FileInputStream is = new FileInputStream("D:\\Update SS Order\\3-22.sql");
        FileReader reader = new FileReader("D:\\Update SS Order\\3-22.sql");
        pstm.setInt(1, 1234511);
        pstm.setString(2, "clob test as String");
        pstm.setString(3, "Nclob test as String");
        pstm.setBinaryStream(4, is);
        pstm.setCharacterStream(5, (Reader)reader, 4001);
        pstm.execute();
        pstm.close();
        ((InputStream)is).close();
    }

    @Test
    public void insertCLOBFromFile() throws Exception {
        PreparedStatement pstm = this.gdc3.prepareStatement("insert into all_dbtype (col4,col14, col13) values (?, ?, ?)");
        pstm.setInt(1, 123);
        FileReader reader = new FileReader("D:\\Update SS Order\\dw_realtimebkbase_sp.sql");
        pstm.setCharacterStream(2, reader);
        FileReader reader2 = new FileReader("/test.txt");
        pstm.setCharacterStream(3, reader2);
        pstm.execute();
        pstm.close();
        ((Reader)reader).close();
        ((Reader)reader2).close();
    }

    @Test
    public void insertBLOBFromBuffer() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream("update blob with InputStream object".getBytes());
        PreparedStatement pstm = this.gdc3.prepareStatement("insert into all_dbtype (col4,col15) values (?,empty_blob())");
        pstm.setInt(1, 1234);
        pstm.execute();
        pstm.close();
        pstm = this.getGdc3().prepareStatement("update all_dbtype set col15=? where col4=1234");
        pstm.setBinaryStream(1, is);
        pstm.execute();
    }

    @Test
    public void insertBLOBFromClass() throws Exception {
        InputStream is = this.getClass().getResourceAsStream("./config/oracle.xml");
        PreparedStatement pstm = this.gdc3.prepareStatement("insert into all_dbtype (col4,col15) values (?,empty_blob())");
        pstm.setInt(1, 12);
        pstm.execute();
        pstm.close();
        pstm = this.getGdc3().prepareStatement("update all_dbtype set col15=? where col4=12");
        pstm.setBinaryStream(1, is);
        pstm.execute();
        pstm.close();
    }

    @Test
    public void saveBlob2File() throws Exception {
        int c;
        Statement stm = this.gdc3.createStatement();
        ResultSet rs = stm.executeQuery("select col15 from all_dbtype where col4 = 234");
        InputStream is = null;
        if (rs.next()) {
            is = rs.getBinaryStream(1);
        }
        rs.close();
        stm.close();
        FileOutputStream of = new FileOutputStream("/test.txt");
        byte[] buffer = new byte[4096];
        while ((c = is.read(buffer)) != -1) {
            of.write(buffer, 0, c);
        }
        of.flush();
        of.close();
        is.close();
    }

    @Test
    public void saveBlobAsOjbect() throws Exception {
        Statement stm = this.gdc3.createStatement();
        ResultSet rs = stm.executeQuery("select col15 from all_dbtype where col4 = 234");
        System.out.println(rs.getFetchSize());
        InputStream is = null;
        if (rs.next()) {
            is = (InputStream)rs.getObject(1);
        }
        rs.close();
        stm.close();
        FileOutputStream of = new FileOutputStream("/test.txt");
        byte[] buffer = new byte[4096];
        while (is.read(buffer) != -1) {
            of.write(buffer);
        }
        of.flush();
        of.close();
        is.close();
    }

    @Test
    public void testObjectMethod() throws Exception {
        PreparedStatement pstm = this.gdc3.prepareStatement("insert into all_dbtype (col5,col36) values (?,?)");
        pstm.setObject(1, new Timestamp(System.currentTimeMillis()));
        pstm.setObject(2, new Timestamp(System.currentTimeMillis()));
        pstm.execute();
    }

    @Test
    public void testGetObject() throws Exception {
        HashMap map = new HashMap();
        map.put("TIMESTAMP", Timestamp.class);
        map.put("DATE", String.class);
        this.idata.setTypeMap(map);
        Statement stm = this.idata.createStatement();
        this.idata.getTypeMap().remove("SYS.ANYDATA");
        this.idata.getTypeMap().remove("SYS.ANYTYPE");
        ResultSet rs = stm.executeQuery("select col5, col36 from all_dbtype where col1='00'");
        if (rs.next()) {
            Object date = rs.getObject(1);
            Object timestamp = rs.getObject(2, map);
            Object str = rs.getObject(1, map);
            Assert.assertEquals((Object)str, (Object)date);
            rs.getTimestamp(2);
            Date d = (Date)date;
            System.out.println(date);
            System.out.println(d);
            Assert.assertEquals((Object)d, (Object)date);
            Timestamp t = (Timestamp)timestamp;
            System.out.println(t);
            System.out.println(timestamp);
            Assert.assertEquals((Object)t, (Object)timestamp);
        }
        rs.close();
    }

    @Test
    public void getURI() throws SQLException {
        ResultSet rs = this.gdc3.createStatement().executeQuery("select col21 from all_dbtype");
        while (rs.next()) {
            System.out.println(rs.getString(1));
        }
        rs.close();
    }

    @Test
    public void testURI() throws SQLException, MalformedURLException {
        PreparedStatement pstm = this.gdc3.prepareStatement("insert into all_dbtype (col21) values (?)");
        pstm.setURL(1, new URL("http://news.163.com"));
        pstm.execute();
        pstm.close();
    }
}

