/*
 * Decompiled with CFR 0.152.
 */
package com.idata.oracle;

import com.idata.config.db.TypeConfigException;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.MetaData;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.oracle.OracleConnection;
import org.junit.Assert;
import org.junit.Test;

public class OracleSourceTableTest
extends OracleConnection {
    private SourceMetaData source;
    private MetaData oracleTable;

    @Test
    public void testConvert() throws TypeConfigException {
        this.source = new SourceMetaData();
        this.source.setName("CHARS_TABLE");
        this.source.setSchema("TEST");
        this.source.setProvider("Oracle");
        this.oracleTable = this.source.createDestinationMetaData();
        Assert.assertEquals((Object)this.oracleTable.getName(), (Object)this.source.getName());
        DataItem dest = this.oracleTable.getDataItems().get(0);
        DataItem src1 = this.source.getDataItems().get(0);
        Assert.assertEquals((long)src1.getPrecision(), (long)64L);
        Assert.assertEquals((long)src1.getScale(), (long)0L);
        Assert.assertEquals((Object)dest.getTypeName(), (Object)"VARCHAR2");
        Assert.assertEquals((long)dest.getPrecision(), (long)64L);
        Assert.assertEquals((long)dest.getScale(), (long)0L);
    }

    public SourceMetaData getSource() {
        return this.source;
    }

    public void setSource(SourceMetaData source) {
        this.source = source;
    }

    public MetaData getOracleTable() {
        return this.oracleTable;
    }

    public void setOracleTable(MetaData oracleTable) {
        this.oracleTable = oracleTable;
    }
}

