/*
 * Decompiled with CFR 0.152.
 */
package com.idata.oracle;

import com.idata.core.dataset.TabularDataSegment;
import com.idata.etl.Fetcher;
import com.idata.etl.QueryDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ProductConcurrentData {
    private Connection prpt;
    private Connection orcl;

    @Before
    public void setUp() throws Exception {
        String url = "jdbc:oracle:thin:@(DESCRIPTION =   (LOAD_BALANCE = ON)     (FAILOVER = ON)     (ADDRESS = (PROTOCOL = TCP)(HOST = wbxbos-01va.webex.com)(PORT=1571))     (ADDRESS = (PROTOCOL = TCP)(HOST = wbxbos-01vb.webex.com)(PORT=1571))   (CONNECT_DATA =     (SERVICE_NAME = PRPT.webex.com)   (FAILOVER_MODE=(TYPE=SELECT)(METHOD=BASIC)))) ";
        this.prpt = DriverManager.getConnection(url, "xiafqian", "qazwsx");
        this.orcl = DriverManager.getConnection("jdbc:oracle:thin:@(DESCRIPTION =  (ADDRESS_LIST =       (ADDRESS = (PROTOCOL = TCP)(HOST = 10.224.69.79)(PORT = 1521))  )  (CONNECT_DATA =       (SERVICE_NAME = ORCL)   )   ) ", "idata", "pass");
    }

    @Test
    public void calc() throws Exception {
        String query = "SELECT   m.companyid,          u.confid,          u.starttime + NVL (t.gmtoffset, 0) as starttime,          u.endtime + NVL (t.gmtoffset, 0)  as endtime    FROM   xxrpt_hgsmeetinguserreport u,          xxrpt_hgsmeetingreport m,          xxrpt_hgstimezone t  WHERE       m.confid = u.confid          AND m.hgssiteid = u.hgssiteid          AND MOD (u.timezone, 256) = t.timezoneid          AND m.starttime BETWEEN t.startdate(+) AND t.enddate(+)          AND m.hgssiteid = 13104          AND m.starttime >= '1-Feb-2011'          AND m.starttime < '28-May-2011' ";
        QueryDataSource ds = new QueryDataSource(this.prpt, query);
        ds.initMetaData();
        Fetcher fetcher = ds.createFetcher();
        TabularDataSegment seg = fetcher.fetch();
        PreparedStatement pstm = this.orcl.prepareStatement("insert into pro_concurrent (companyid , confid , starttime , endtime , reportdate , reporthour , reportminute , reportnumber ) values (?,?,?,?,?,?,?,?) ");
        for (ArrayList<Object> row : seg.getRowsets()) {
            ArrayList<ArrayList<Object>> rowsets = this.calcConcurrent(row);
            for (ArrayList<Object> rowset : rowsets) {
                pstm.setObject(1, rowset.get(0));
                pstm.setObject(2, rowset.get(1));
                pstm.setObject(3, rowset.get(2));
                pstm.setObject(4, rowset.get(3));
                pstm.setObject(5, rowset.get(4));
                pstm.setObject(6, rowset.get(5));
                pstm.setObject(7, rowset.get(6));
                pstm.setObject(8, rowset.get(7));
                pstm.addBatch();
                pstm.executeBatch();
                pstm.clearBatch();
            }
        }
    }

    private ArrayList<ArrayList<Object>> calcConcurrent(ArrayList<Object> row) {
        ArrayList<ArrayList<Object>> concurrentList = new ArrayList<ArrayList<Object>>();
        Calendar start = Calendar.getInstance();
        start.setTime((Date)row.get(2));
        Calendar end = Calendar.getInstance();
        end.setTime((Date)row.get(3));
        Calendar reportDate = Calendar.getInstance();
        reportDate.setTime(start.getTime());
        reportDate.set(11, 0);
        reportDate.set(12, 0);
        reportDate.set(13, 0);
        while (start.before(end)) {
            ArrayList<Object> concurrent = new ArrayList<Object>();
            concurrent.addAll(row);
            int h = start.get(11);
            int m = start.get(12);
            int c = 15 * (m / 15 + 1);
            if ((c %= 60) == 0) {
                ++h;
                if ((h %= 24) == 0) {
                    reportDate.add(6, 1);
                }
            }
            java.sql.Date sdate = new java.sql.Date(reportDate.getTime().getTime());
            concurrent.add(sdate);
            concurrent.add(h);
            concurrent.add(c);
            concurrent.add(1);
            start.add(12, 15);
            concurrentList.add(concurrent);
        }
        return concurrentList;
    }

    @After
    public void tearDown() throws SQLException {
        this.prpt.close();
        this.orcl.close();
    }
}

