package com.idata.config.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MappingUtil<T> {

	private XPath xpath;

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public List decodeNodeList(Class<?> cls, NodeList nodes) throws Exception {
		ArrayList list = new ArrayList(0);
		for (int i = 0; i < nodes.getLength(); i++) {
			Node node = nodes.item(i);
			T obj = decodeElemeent(cls, node);
			list.add(obj);
		}
		return list;
	}

	@SuppressWarnings({ "unchecked", "deprecation" })
	public T decodeElemeent(Class<?> cls, Node node) throws Exception {
		Object obj = cls.newInstance();
		Field[] fields = cls.getDeclaredFields();
		for (Field field : fields) {
			ConfigElement element = field.getAnnotation(ConfigElement.class);

			String value = null;
			if (element.type() == ConfigElement.NODE) {
				value = xpath.evaluate(element.name() + "/text()", node);
			} else if (element.type() == ConfigElement.ATTRIBUTE) {
				value = xpath.evaluate("@" + element.name(), node);
			} else if (element.type() == ConfigElement.NODESET) {
				NodeList children = (NodeList) xpath.evaluate(element.name(), node, XPathConstants.NODESET);
				decodeNodeList(field.getType().getComponentType(), children);
			}

			// set object
			String s = field.getName().substring(0, 1);
			Method method = cls.getMethod("set" + field.getName().replaceFirst(s, s.toUpperCase()), field.getType());
			if (!"".equalsIgnoreCase(value)) {
				if (field.getType().equals(int.class)) {
					Integer p = Integer.valueOf(value);
					method.invoke(obj, p);
				} else if (field.getType().equals(String.class)) {
					method.invoke(obj, value);
				} else if (field.getType().equals(java.util.Date.class)) {
					method.invoke(obj, Date.parse(value));
				}
			}

		}

		return (T) obj;
	}

	public MappingUtil(XPath xpath) {
		super();
		this.xpath = xpath;
	}

	public XPath getXpath() {
		return xpath;
	}

	public void setXpath(XPath xpath) {
		this.xpath = xpath;
	}

}
