package com.idata.config.db;

import java.sql.Connection;
import java.sql.SQLException;

public final class DBProvider {

	public static final String ORACLE = "Oracle";

	public static final String DB2 = "DB2";

	public static final String SYBASE = "Sybase";

	public static final String MYSQL = "Mysql";

	/**
	 * Microsoft SQL Server
	 */
	public static final String MSSQL = "Mssql";

	public static String getProvider(String dataBaseProductName) {
		String provider = null;
		if (dataBaseProductName.indexOf(DBProvider.DB2) != -1 & dataBaseProductName.length() > DBProvider.DB2.length()) {
			provider = DBProvider.DB2;
		} else if (dataBaseProductName.toLowerCase().indexOf("microsoft") != -1 & dataBaseProductName.length() > 5) {
			provider = DBProvider.MSSQL;
		} else if (dataBaseProductName.toLowerCase().indexOf("adaptive") != -1 & dataBaseProductName.length() > 5) {
			provider = DBProvider.SYBASE;
		} else
			provider = dataBaseProductName;

		return provider;
	}

	public static String getProvider(Connection cnn) throws SQLException {
		return getProvider(cnn.getMetaData().getDatabaseProductName());
	}
}
