package com.idata.config.db;

import java.util.Hashtable;

import com.idata.core.db.type.mapping.Db2Java;
import com.idata.core.db.type.mapping.DbType;
import com.idata.core.db.type.mapping.JavaType;
import com.idata.core.meta.db.DataItem;

public class TypeConfiguration {

	private String fileName;

	private Hashtable<String, DbType> dbtypes = new Hashtable<String, DbType>(0);

	private Hashtable<String, JavaType> javaTypes = new Hashtable<String, JavaType>(0);

	private Hashtable<String, DbType> stringTypes = new Hashtable<String, DbType>(0);

	private Hashtable<String, DbType> numberTypes = new Hashtable<String, DbType>(0);

	private Hashtable<String, DbType> dateTypes = new Hashtable<String, DbType>(0);

	private Hashtable<String, DbType> lobTypes = new Hashtable<String, DbType>(0);

	/**
	 * first, convert default db2java type to see if find the correspond
	 * database data type<br/>
	 * if precision exceeds max length of DB data type, convert type specified
	 * with conversion attribute.
	 * 
	 * @param e
	 * @return
	 * @throws TypeConfigException
	 */
	public DataItem convertDateType(DataItem e) throws TypeConfigException {
		DataItem r = e.clone();
		Db2Java db2java = e.getDbType().getDefaultDb2Java();
		JavaType javaType = this.javaTypes.get(db2java.getName());
		String typeName;
		if (javaType == null) {
			for (Db2Java t : e.getDbType().getDb2javas()) {
				if (!"yes".equalsIgnoreCase(t.getDefault()) && javaTypes.get(t.getName()) != null) {
					javaType = javaTypes.get(t.getName());
					typeName = javaType.getDefaultJava2Db().getName();
					break;
				}
			}
		}

		if (javaType == null) {
			throw new TypeConfigException("cannot find java type [" + db2java.getName() + "] for dbtype: ["
					+ e.getTypeName() + "] in config " + this.fileName);
		}
		typeName = javaType.getDefaultJava2Db().getName();
		DbType dbtype = dbtypes.get(typeName);

		if (dbtype == null) {
			throw new TypeConfigException("cannot find DB type for [" + typeName + "]");
		}

		// protect exceeds max-length in case that Meta Data return
		// incorrect Column Type Name
		if (e.getPrecision() > dbtype.getMaxLength() && dbtype.getMaxLength() > 0) {
			dbtype = dbtypes.get(dbtype.getConversion());
		}

		// designate default precision
		if (dbtype.getCatalog().equalsIgnoreCase("string") && e.getPrecision() <= 0) {
			r.setPrecision(javaType.getDefaultJava2Db().getDefaultPrecision());
			r.setScale(0);
		}

		// remove all number's precision and scale
		if (dbtype.getCatalog().equalsIgnoreCase("number")) {
			r.setPrecision(0);
			r.setScale(0);
		}

		// non-LOB convert to LOB
		if (dbtype.getCatalog().equalsIgnoreCase("lob")) {
			r.setPrecision(0);
			r.setScale(0);
		}
		r.setTypeName(dbtype.getName());
		r.setCatalog(dbtype.getCatalog());

		return r;
	}

	/**
	 * convert database data type internal, within same database provider
	 * 
	 * @param type
	 * @return
	 */
	public String convertType(String src) {
		Db2Java db2Java = this.dbtypes.get(src).getDefaultDb2Java();
		JavaType javaType = this.javaTypes.get(db2Java.getName());
		return javaType == null ? null : javaType.getDefaultJava2Db().getName();
	}

	/**
	 * 
	 * @param type
	 * @return
	 */
	public String findCatalog(String type) {
		DbType dbtype = this.dbtypes.get(type);
		return dbtype == null ? null : dbtype.getCatalog();
	}

	public Hashtable<String, DbType> getDbtypes() {
		return dbtypes;
	}

	public void setDbtypes(Hashtable<String, DbType> dbtypes) {
		this.dbtypes = dbtypes;
	}

	public Hashtable<String, JavaType> getJavaTypes() {
		return javaTypes;
	}

	public void setJavaTypes(Hashtable<String, JavaType> javaTypes) {
		this.javaTypes = javaTypes;
	}

	public Hashtable<String, DbType> getStringTypes() {
		return stringTypes;
	}

	public void setStringTypes(Hashtable<String, DbType> stringTypes) {
		this.stringTypes = stringTypes;
	}

	public Hashtable<String, DbType> getNumberTypes() {
		return numberTypes;
	}

	public void setNumberTypes(Hashtable<String, DbType> numberTypes) {
		this.numberTypes = numberTypes;
	}

	public Hashtable<String, DbType> getDateTypes() {
		return dateTypes;
	}

	public void setDateTypes(Hashtable<String, DbType> dateTypes) {
		this.dateTypes = dateTypes;
	}

	public Hashtable<String, DbType> getLobTypes() {
		return lobTypes;
	}

	public void setLobTypes(Hashtable<String, DbType> lobTypes) {
		this.lobTypes = lobTypes;
	}

	public DbType getDbType(DataItem item) throws TypeConfigException {
		if (item.getTypeName().equalsIgnoreCase("TIMESTAMP")
				&& (item.getAttribute() != null && item.getAttribute().length() == 0)) {
			return getDbType(item.getTypeName() + item.getAttribute());
		} else {
			return getDbType(item.getTypeName());
		}
	}

	public DbType getDbType(String type) throws TypeConfigException {
		DbType t = dbtypes.get(type.toUpperCase());
		if (t == null) {
			throw new TypeConfigException("cannot find database type: [" + type + "] in config " + this.fileName);
		}
		return dbtypes.get(type.toUpperCase());
	}

	public JavaType getJavaType(String name) {
		return javaTypes.get(name);
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

}
