package com.idata.core.dataset;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.idata.core.meta.db.DataItem;

public class CommDataUtil implements DataUtil {

	protected StringReader convertReader(Reader reader) throws IOException {
		StringWriter writer = new StringWriter();
		if (reader == null)
			return null;
		char[] buffer = new char[8192];

		for (int c = 0; c != -1; c = reader.read(buffer)) {
			writer.write(buffer, 0, c);
		}
		StringReader stringReader = new StringReader(writer.getBuffer().toString());
		return stringReader;
	}

	protected InputStream convertInputStream(InputStream in) throws IOException {
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		if (in == null)
			return null;
		byte[] buffer = new byte[8192];
		for (int c = 0; c != -1; c = in.read(buffer)) {
			out.write(buffer, 0, c);
		}
		ByteArrayInputStream bais = new ByteArrayInputStream(out.toByteArray());
		return bais;
	}

	/**
	 * @throws IOException
	 * 
	 */
	public Object getValue(ResultSet rs, DataItem item) throws SQLException, IOException {
		String name = item.getName();
		String javatype = item.getDefaultJavaTypeName();
		if ("java.io.Reader".equalsIgnoreCase(javatype)) {
			return convertReader(rs.getCharacterStream(name));
		} else if ("java.io.InputStream".equalsIgnoreCase(javatype)) {
			return convertInputStream(rs.getBinaryStream(name));
		} else {
			return getObject(rs, javatype, name);
		}
	}

	/**
	 * 
	 */
	public void setValue(PreparedStatement pstm, int colIndex, DataItem e, Object obj) throws SQLException {
		if (obj == null) {
			if (e.getDefaultJavaTypeName().equalsIgnoreCase("java.lang.Byte[]")) {
				pstm.setNull(colIndex, java.sql.Types.VARBINARY);
			} else
				pstm.setNull(colIndex, java.sql.Types.VARCHAR);
		} else if (obj instanceof Reader) {
			pstm.setCharacterStream(colIndex, (Reader) obj);
		} else if (obj instanceof InputStream) {
			pstm.setBinaryStream(colIndex, (InputStream) obj);
		}		 
		else {
			pstm.setObject(colIndex, obj);
		}
	}

	protected Object getObject(ResultSet rs, String className, String columnLabel) throws SQLException {
		if (rs.getObject(columnLabel) == null)
			return null;
		if ("java.sql.Date".equalsIgnoreCase(className)) {
			return rs.getDate(columnLabel);
		} else if ("java.sql.Timestamp".equalsIgnoreCase(className)) {
			return rs.getTimestamp(columnLabel);
		} else if ("java.lang.String".equalsIgnoreCase(className)) {
			return rs.getString(columnLabel);
		} else if ("java.lang.Double".equalsIgnoreCase(className)) {
			return rs.getDouble(columnLabel);
		} else if ("java.lang.Character".equalsIgnoreCase(className)) {
			return rs.getString(columnLabel);
		} else if ("java.lang.Float".equalsIgnoreCase(className)) {
			return rs.getFloat(columnLabel);
		} else if ("java.lang.Long".equalsIgnoreCase(className)) {
			return rs.getLong(columnLabel);
		} else if ("java.lang.Short".equalsIgnoreCase(className)) {
			return rs.getShort(columnLabel);
		} else if ("java.math.BigInteger".equalsIgnoreCase(className)) {
			return rs.getLong(columnLabel);
		} else if ("java.lang.BigDecimal".equalsIgnoreCase(className)) {
			return rs.getBigDecimal(columnLabel);
		} else if ("java.lang.Byte[]".equalsIgnoreCase(className)) {
			return rs.getBytes(columnLabel);
		} else if ("java.lang.Byte".equalsIgnoreCase(className)) {
			return rs.getByte(columnLabel);
		} else if ("java.lang.Boolean".equalsIgnoreCase(className)) {
			return rs.getBoolean(columnLabel);
		} else
			return rs.getObject(columnLabel);
	}

}
