package com.idata.core.dataset;

public class DataUtilFactory {

	private static DataUtilFactory instance = null;

	public static DataUtilFactory newInstance() {
		if (instance == null) {
			instance = new DataUtilFactory();
		}
		return instance;
	}

	private DataUtilFactory() {

	}

	@SuppressWarnings("rawtypes")
	public DataUtil createDataUtil(String provider) {
		String qname = this.getClass().getPackage().getName();
		String classname = qname + "." + provider + "DataUtil";
		DataUtil util = null;

		try {
			Class cls = null;
			cls = Class.forName(classname);
			util = (DataUtil) cls.newInstance();
		} catch (ClassNotFoundException e) {
			util = new CommDataUtil();
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
		// create default data util object
		
		return util;
	}
}
