/**
 * 
 */
package com.idata.core.meta.db;

import com.idata.core.db.type.mapping.DbType;

/**
 * @author xiafqian
 * 
 */
public class DataItem {

	private String name;

	private String typeName;

	private int length;

	private int type;

	private int scale;

	private String catalog;

	private DbType dbType;

	private String attribute;

	private boolean hasLength = true;

	public String getCatalog() {
		return catalog;
	}

	public void setCatalog(String catalog) {
		this.catalog = catalog;
	}

	private int precision;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}

	public int getScale() {
		return scale;
	}

	public void setScale(int scale) {
		this.scale = scale;
	}

	public int getPrecision() {
		return precision;
	}

	public void setPrecision(int precision) {
		this.precision = precision;
	}

	@Override
	public DataItem clone() {
		DataItem e = new DataItem();
		e.setName(name);
		e.setType(type);
		e.setTypeName(typeName);
		e.setAttribute(attribute);
		e.setCatalog(catalog);
		e.setDbType(dbType);
		e.setHasLength(hasLength);
		e.setPrecision(precision);
		e.setScale(scale);
		return e;
	}

	public DbType getDbType() {
		return dbType;
	}

	public void setDbType(DbType dbType) {
		this.dbType = dbType;
		this.catalog = dbType.getCatalog();
	}

	public String getDefaultJavaTypeName() {
		return dbType.getDefaultDb2Java().getName();
	}

	public int getLength() {
		return length;
	}

	public void setLength(int length) {
		this.length = length;
	}

	public String getAttribute() {
		return attribute;
	}

	public void setAttribute(String attribute) {
		this.attribute = attribute;
	}

	public boolean isHasLength() {
		return hasLength;
	}

	public void setHasLength(boolean hasLength) {
		this.hasLength = hasLength;
	}

}
