package com.idata.core.meta.db;

import java.util.ArrayList;
import java.util.List;

import com.idata.core.dataset.DataUtil;
import com.idata.core.dataset.DataUtilFactory;

public abstract class MetaData {

	protected String provider;

	protected String schema;

	protected String name;

	protected String fullName;

	protected ArrayList<DataItem> dataItems = new ArrayList<DataItem>(0);

	protected ArrayList<String> primaryKey = new ArrayList<String>(0);

	public String getProvider() {
		return provider;
	}

	public void setProvider(String provider) {
		this.provider = provider;
	}

	public String getSchema() {
		return schema;
	}

	public void setSchema(String schema) {
		this.schema = schema;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public List<DataItem> getDataItems() {
		return dataItems;
	}

	public void remove(int i) {
		dataItems.remove(1);
	}

	public DataItem get(int i) {
		return dataItems.get(i);
	}

	public DataItem get(String name) {
		DataItem item = null;
		for (DataItem e : dataItems) {
			if (e.getName().equalsIgnoreCase(name))
				item = e;
		}
		return item;
	}

	public void remove(String name) {
		int i = 0;
		for (i = 0; i < dataItems.size(); i++) {
			if (dataItems.get(i).getName().equalsIgnoreCase(name))
				break;
		}

		dataItems.remove(i);
	}

	public void setDataItems(ArrayList<DataItem> dataItems) {
		this.dataItems = dataItems;
	}

	public ArrayList<String> getPrimaryKey() {
		return primaryKey;
	}

	public void setPrimaryKey(ArrayList<String> primaryKey) {
		this.primaryKey = primaryKey;
	}

	public void addPrimaryKey(String name) {
		primaryKey.add(name);

	}

	public void add(DataItem item) {
		dataItems.add(item);
	}

	public String getFullName() {
		this.fullName = schema == null || "".equalsIgnoreCase(schema) ? name : schema + "." + name;
		this.fullName = this.fullName.toUpperCase();
		return this.fullName;
	}

	public void setFullName(String fullname) {
		this.fullName = fullname;
	}

	public DataUtil createDataUtil() {
		return DataUtilFactory.newInstance().createDataUtil(provider);
	}

}
