/**
 * 
 */
package com.idata.core.meta.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

import com.idata.config.db.DBProvider;
import com.idata.config.db.TypeConfigException;
import com.idata.config.db.TypeConfiguration;
import com.idata.config.db.TypeConfigurationFactory;

/**
 * @author xiafqian
 * 
 */
public class SourceMetaData extends MetaData {

	public SourceMetaData() {
		super();
	}

	public DestinationMetaData createDestinationMetaData(Connection dest) throws TypeConfigException, SQLException {
		String provider = DBProvider.getProvider(dest);
		/*if (provider.equals(this.provider)) {
			return new DestinationMetaData(provider, schema, name, dataItems);
		}*/
		return createDestinationMetaData(provider);
	}

	public DestinationMetaData createDestinationMetaData(String providerName) throws TypeConfigException {
		TypeConfigurationFactory factory = TypeConfigurationFactory.createInstance();
		TypeConfiguration config = factory.readProviderConfig(providerName);

		ArrayList<DataItem> destItems = new ArrayList<DataItem>(0);

		DestinationMetaData dest = new DestinationMetaData();
		dest.setProvider(providerName);
		dest.setName(name);
		dest.setSchema(schema);

		for (DataItem item : this.dataItems) {
			destItems.add(config.convertDateType(item));
		}

		dest.setDataItems(destItems);

		return dest;
	}

	/**
	 * convert data type from source table in default model, and create an
	 * destationCommtTable object same vendor
	 * 
	 * @return DestationCommTable
	 * @throws TypeConfigException
	 */
	public DestinationMetaData createDestinationMetaData() throws TypeConfigException {
		return createDestinationMetaData(this.provider);

	}

	public int size() {
		return this.dataItems.size();
	}

}
