/**
 * 
 */
package com.idata.etl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

import com.idata.core.dataset.DataUtil;
import com.idata.core.dataset.TabularDataSegment;
import com.idata.core.meta.db.DestinationMetaData;
import com.idata.log.IDataLogger;

/**
 * @author xiafqian
 * 
 */
public interface Deliver {
	/**
	 * default deliver model, get data in one batch from table, then deliver to
	 * destination table.
	 */
	public final static int IDATA_BATCH_DELIVER = 10;

	/**
	 * this is like as batch deliver, but it start deliver data by a single
	 * channel of data chunk, until all data is done.
	 */
	public final static int IDATA_SINGLE_CHANNEL_DELIVER = 11;

	public final static int IDATA_MULTI_CHANNEL_DELIVER = 12;

	public void setDilverModel(int model);

	public void deliver(TabularDataSegment segment) throws SQLException;

	// public void setIDataLogger(IDataLogger logger);

	public void setConnection(Connection connection);

	public void setDestinationMetaData(DestinationMetaData meta);

	public void setDataUtil(DataUtil dataUtil);

	//public void setSimpleDDL(SimpleDDL ddl);

	//public void setQueryBuilder(QueryBuilder qb);

	//public SimpleDDL getSimpleDDL();

	public void addPreAction(PreAction action);

	public void setColRef(ArrayList<Integer> colref);

	public void setIDataLogger(IDataLogger logger);
	
	public void prepare() throws Exception;
	
	public void close() throws Exception;

}
