/**
 * 
 */
package com.idata.etl;

import java.sql.SQLException;

import com.idata.core.dataset.TabularDataSegment;
import com.idata.log.IDataLogger;

/**
 * @author xiafqian
 * 
 */
public interface Fetcher {

	public int PAGE_SIZE = 500;

	public final static int IDATA_BATCH_FETCH = 20;

	public final static int IDATA_SINGLE_CHANNEL_FETCH = 21;

	public final static int IDATA_MULTI_CHANNEL_FETCH = 22;

	public abstract void init() throws SQLException;

	public abstract void close() throws SQLException;

	public abstract void setIDataLogger(IDataLogger logger);

	/**
	 * fetch rows from database with paging size 500 every time, if the data
	 * return 0 rows, it indicates the fetching action is done.
	 * 
	 * @return
	 * @throws Exception
	 */
	public TabularDataSegment fetch() throws Exception;

}
