package com.idata.etl;

import java.lang.reflect.Constructor;
import java.sql.SQLException;

import com.idata.config.db.DBProvider;
import com.idata.core.meta.db.SourceMetaData;

public class FetcherFactory {

	private static FetcherFactory _instance = new FetcherFactory();

	private FetcherFactory() {
	}

	public static FetcherFactory newInstance() {
		return _instance;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Fetcher newFetcher(DataSource ds, SourceMetaData smd) throws SQLException {
		String provider = DBProvider.getProvider(ds.getConnection());

		String qn = this.getClass().getPackage().getName();
		String cn = qn + "." + "fetcher." + provider + "PagingFetcher";
		cn = "com.idata.etl.fetcher.FlatTablePagingFetcher";
		Fetcher fetcher = null;

		Class cls = null;
		try {
			cls = Class.forName(cn);
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			try {
				cls = Class.forName("com.idata.etl.impl.SimpleFetcher");
				// TODO log here
				System.out.println("use default fetcher: com.idata.etl.impl.SimpleFetcher");
			} catch (ClassNotFoundException e1) {
				e1.printStackTrace();
			}
		}
		Constructor ct;
		try {
			ct = cls.getConstructor(DataSource.class, SourceMetaData.class);
			fetcher = (Fetcher) ct.newInstance(ds, smd);
		} catch (Exception e) {
			e.printStackTrace();
		}

		return fetcher;
	}

}
