package com.idata.etl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

import com.idata.config.db.DBProvider;
import com.idata.config.db.TypeConfigException;
import com.idata.config.db.TypeConfiguration;
import com.idata.config.db.TypeConfigurationFactory;
import com.idata.core.db.type.mapping.DbType;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.core.meta.db.oracle.CommonTableHelper;

public class NativeDataSource extends DataSource {

	/**
	 * @param connection
	 * @param catalog
	 * @param schema
	 * @param tableName
	 */
	public NativeDataSource(Connection connection, String catalog, String schema, String tableName) {
		super(connection, catalog, schema, tableName);
	}

	public void initMetaData() throws SQLException, ParseException, TypeConfigException {
		sourceMetaData = new SourceMetaData();
		sourceMetaData.setProvider(DBProvider.getProvider(connection));
		sourceMetaData.setName(tableName);
		sourceMetaData.setSchema(schema);

		TypeConfiguration config = TypeConfigurationFactory.createInstance().readProviderConfig(
				sourceMetaData.getProvider());

		ResultSet columns = connection.getMetaData().getColumns(catalog, schema, tableName, null);
		while (columns.next()) {
			DataItem item = new DataItem();
			String t = columns.getString("TYPE_NAME").toUpperCase();
			String name = columns.getString("COLUMN_NAME").toUpperCase();

			item.setName(name);
			if (sourceMetaData.getProvider().equalsIgnoreCase(DBProvider.ORACLE)) {
				fillOracleSpecialType(item, t);
			} else if (sourceMetaData.getProvider().equalsIgnoreCase(DBProvider.MSSQL)) {
				fillMsSqlSpecialType(item, t);
			} else if (sourceMetaData.getProvider().equalsIgnoreCase(DBProvider.SYBASE)) {
				fillSybaseSpecialType(item, t);
			} else {
				item.setTypeName(t);
			}
			DbType dbtype = config.getDbType(item);
			item.setDbType(dbtype);
			sourceMetaData.add(item);
		}
		columns.close();

		CommonTableHelper helper = new CommonTableHelper(sourceMetaData, connection);
		fetchQuery = helper.selectScript();

		String warpQuery = fetchQuery + " WHERE 1=0";

		/**
		 * fetch length, precision and scale for DataItems
		 */
		Statement stm = connection.createStatement();
		ResultSet rs = stm.executeQuery(warpQuery);
		ResultSetMetaData meta = rs.getMetaData();
		for (int i = 0; i < meta.getColumnCount(); i++) {
				int j = i + 1;
				if (sourceMetaData.get(i).isHasLength()) {					
					sourceMetaData.get(i).setLength(meta.getColumnDisplaySize(j));
					sourceMetaData.get(i).setScale(meta.getScale(j));
					sourceMetaData.get(i).setPrecision(meta.getPrecision(j));
				}

		}
		rs.close();
		stm.close();

	}

	private void fillSybaseSpecialType(DataItem item, String t) {
		// add NOT NULL to BIT type
		if (t.equalsIgnoreCase("BIT")) {
			item.setAttribute("NOT NULL");
		}
		item.setTypeName(t);
	}

	/**
	 * 
	 * @param item
	 * @param name
	 * @param t
	 */
	private void fillMsSqlSpecialType(DataItem item, String t) {
		// change the TIMESTAMP to VAR BINARY type
		// remove the length of UNIQUEIDENTIFIER type
		if (t.equalsIgnoreCase("TIMESTAMP")) {
			item.setTypeName("VARBINARY");
			item.setCatalog("");
		} else if (t.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
			item.setTypeName(t);
			item.setHasLength(true);
		} else {
			item.setTypeName(t);
		}

	}

	private void fillOracleSpecialType(DataItem item, String t) {
		// deprecated DB type name
		if (t.equalsIgnoreCase("LONG")) {
			item.setTypeName("CLOB");
		} else if (t.indexOf("TIMESTAMP") != -1) {
			item.setTypeName("TIMESTAMP");
			if (t.indexOf(")") > 0) {
				item.setAttribute(t.substring(t.indexOf(")") + 1, t.length()));
			}
		} else {
			item.setTypeName(t);
		}
	}

	@Override
	public Fetcher createFetcher() throws SQLException, ParseException, TypeConfigException {
		return FetcherFactory.newInstance().newFetcher(this, sourceMetaData);

	}

}
