package com.idata.etl;

import com.idata.core.meta.db.DataItem;

@SuppressWarnings("serial")
public class ParseException extends Exception {
	
	private DataItem dataItem;

	private String msg;

	private Throwable cause;

	
	/**
	 * @param dataItem
	 */
	public ParseException(DataItem dataItem) {
		super();
		this.dataItem = dataItem;
		this.msg = "Parse Exception, DB Type Name:[ " + dataItem.getTypeName() + " ]";
	}

	public ParseException(String msg) {
		super(msg);
		this.msg = msg;

	}

	/**
	 * @param cause
	 */
	public ParseException(Throwable cause) {
		super(cause);
		this.cause = cause;
	}

	/**
	 * @param msg
	 * @param cause
	 */
	public ParseException(String msg, Throwable cause) {
		super(msg, cause);
		this.msg = msg;
		this.cause = cause;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public Throwable getCause() {
		return cause;
	}

	public void setCause(Throwable cause) {
		this.cause = cause;
	}

	public DataItem getDataItem() {
		return dataItem;
	}

	public void setDataItem(DataItem dataItem) {
		this.dataItem = dataItem;
	}

	
}
