/**
 * 
 */
package com.idata.etl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

import com.idata.config.db.DBProvider;
import com.idata.config.db.TypeConfigException;
import com.idata.config.db.TypeConfiguration;
import com.idata.config.db.TypeConfigurationFactory;
import com.idata.core.db.type.mapping.DbType;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.etl.fetcher.SimpleFetcher;

/**
 * @author xiafqian
 * 
 */
public class QueryDataSource extends DataSource {

	private String query;

	/**
	 * @param query
	 */
	public QueryDataSource(Connection cnn, String query) {
		super(cnn);
		this.query = query;
	}

	/**
	 * @deprecated
	 * @return
	 * @throws ParseException
	 */
	public String[] parseName() throws ParseException {
		String[] t = null;
		String q = this.query.toUpperCase();
		if (q.indexOf(" FROM ") < 0 || q.indexOf("SELECT ") < 0)
			throw new ParseException("invalid query:" + this.query);
		return t;
	}

	public String wrapQuery() throws ParseException {
		String q = this.query.toUpperCase();
		if (q.indexOf(" FROM ") < 0 || q.indexOf("SELECT ") < 0)
			throw new ParseException("invalid query: " + this.query);

		return "SELECT * FROM (" + this.query + " ) s WHERE 1=0";
	}



	@Override
	public String getFetchQuery() {
		return this.query;
	}
	
	@Override
	public Fetcher createFetcher() throws SQLException, ParseException, TypeConfigException {
		return new SimpleFetcher(this, this.getSourceMetaData());
	}

	public void initMetaData() throws SQLException, ParseException, TypeConfigException {
		sourceMetaData = new SourceMetaData();
		sourceMetaData.setProvider(DBProvider.getProvider(connection));
		TypeConfiguration config = TypeConfigurationFactory.createInstance().readProviderConfig(
				sourceMetaData.getProvider());

		Statement statement = connection.createStatement();
		ResultSet rs = statement.executeQuery(wrapQuery());

		ResultSetMetaData dbmeta = rs.getMetaData();

		for (int i = 1; i <= dbmeta.getColumnCount(); i++) {
			DataItem col = new DataItem();
			col.setName(dbmeta.getColumnName(i).toUpperCase());
			col.setPrecision(dbmeta.getPrecision(i));
			col.setScale(dbmeta.getScale(i));
			col.setLength(dbmeta.getColumnDisplaySize(i));
			col.setType(dbmeta.getColumnType(i));

			if (dbmeta.getColumnTypeName(i) == null || dbmeta.getColumnTypeName(i).equals("")) {
				col.setTypeName("VARCHAR2");
			} else {
				col.setTypeName(dbmeta.getColumnTypeName(i).toUpperCase());
			}

			// deal with return varchar for TEXT in MySQL
			DbType dbtype = config.getDbType(col.getTypeName());
			if (dbtype == null) {
				throw new ParseException("Parse Exception, DB Type Name:[ " + col.getTypeName() + " ]");
			}
			if (col.getPrecision() > dbtype.getMaxLength() && dbtype.getMaxLength() > 0) {
				dbtype = config.getDbType(dbtype.getConversion());
			}

			col.setDbType(dbtype);
			col.setCatalog(dbtype.getCatalog());
			sourceMetaData.add(col);
		}
		rs.close();
		statement.close();
	}

	public String getQuery() {
		return query;
	}

	public void setQuery(String query) {
		this.query = query;
	}

	public Connection getConnection() {
		return connection;
	}

	public void setConnection(Connection connection) {
		this.connection = connection;
	}

	

}
