package com.idata.etl.fetcher;

import java.sql.SQLException;
import java.util.ArrayList;

import com.idata.core.dataset.TabularDataSegment;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.core.meta.db.oracle.CommonTableHelper;
import com.idata.etl.DataSource;

public class FlatTablePagingFetcher extends NativePagingFetcher {

	public FlatTablePagingFetcher(DataSource dataSource, SourceMetaData sourceMetaData) {
		super(dataSource, sourceMetaData);
	}

	@Override
	public void init() throws SQLException {
		CommonTableHelper cth = new CommonTableHelper(dataSource.getConnection(), sourceMetaData);
		stm = this.dataSource.getConnection().createStatement();
		// statement.setFetchSize(PAGE_SIZE);
		String q = cth.selectScript();
		logger.info(q);
		rs = stm.executeQuery(q);
		logger.info("initialized FlatTablePagingFetcher.");

	}

	@Override
	public void close() throws SQLException {
		rs.close();
		stm.close();
	}

	@Override
	public TabularDataSegment fetch() throws Exception {

		TabularDataSegment tds = new TabularDataSegment();
		tds.setSourceMetaData(sourceMetaData);
		if (!rs.isClosed()) {
			for (int i = 0; i < PAGE_SIZE && rs.next(); i++) {
				ArrayList<Object> rowset = new ArrayList<Object>(sourceMetaData.size());
				for (DataItem e : sourceMetaData.getDataItems()) {
					rowset.add(du.getValue(rs, e));
				}
				tds.addRowSet(rowset);
			}
			logger.info("fetch TDS: " + tds + " @ rows " + tds.size());
		}
		return tds;
	}

}
