package com.idata.etl.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

import com.idata.core.dataset.TabularDataSegment;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.DestinationMetaData;

public class BatchDeliver extends SimpleDeliver {

	public BatchDeliver(DestinationMetaData destinationMetaData, Connection connection) {
		super(destinationMetaData, connection);
	}

	/**
	 * create table with specified name if it doesn't exist.<br/>
	 * , then insert data into table.
	 * 
	 * @throws SQLException
	 */
	@Override
	public void deliver(TabularDataSegment tds) throws SQLException {

		
		ArrayList<Object> rowset = null;
		for (int i = 0; i < tds.getRowsets().size(); i++) {
			rowset = tds.getRowsets().get(i);
			for (int c = 0; c < colRef.size(); c++) {
				DataItem e = destinationMetaData.getDataItems().get(c);
				dataUtil.setValue(preparedStatement, c + 1, e, rowset.get(colRef.get(c).intValue()));
			}
			preparedStatement.addBatch();
		}
		preparedStatement.executeBatch();
		connection.commit();
	}

}
