package com.idata.log;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class IDataLogger {

	private String path = "./logs";

	private String sessionName;

	private long sessionID;

	private Logger logger;

	private FileHandler traceHandler;

	private FileHandler infoHandler;

	private FileHandler errorHandler;

	public IDataLogger(String sessionName, long sessionID) throws SecurityException, IOException {
		this.sessionID = sessionID;
		this.sessionName = sessionName;

		logger = Logger.getLogger(sessionName);
		
		Handler[] handlers = logger.getHandlers();
		for( Handler h  : handlers){
			logger.removeHandler(h);
		}

		logger.setLevel(Level.ALL);
		String logPath = path + "/" + this.sessionName + "-" +  this.sessionID;
		File f = new File(logPath);
		if (!f.exists()){
			f.mkdir();
		}

		logger.info("all loger for the session is here:" + logPath);
		
		traceHandler = new FileHandler(logPath + "/trace.log", true);
		traceHandler.setFilter(new Filter() {
			public boolean isLoggable(LogRecord record) {
				return record.getLevel().intValue() <= Level.FINE.intValue();
			}

		});
		traceHandler.setFormatter(new SimpleFormatter());
		logger.addHandler(traceHandler);

		infoHandler = new FileHandler(logPath + "/info.log", true);
		infoHandler.setFilter(new Filter() {
			public boolean isLoggable(LogRecord record) {
				return record.getLevel().equals(Level.INFO) || record.getLevel().equals(Level.CONFIG);
			}
		});
		infoHandler.setFormatter(new SimpleFormatter());
		logger.addHandler(infoHandler);

		errorHandler = new FileHandler(logPath + "/warning.log", true);
		errorHandler.setFilter(new Filter() {

			public boolean isLoggable(LogRecord record) {
				return record.getLevel().intValue() >= Level.WARNING.intValue();
			}
		});
		errorHandler.setFormatter(new SimpleFormatter());
		logger.addHandler(errorHandler);
	}

	public Logger getLogger() {
		return logger;
	}

	public void setLogger(Logger logger) {
		this.logger = logger;
	}

	public FileHandler getTraceHandler() {
		return traceHandler;
	}

	public void setTraceHandler(FileHandler traceHandler) {
		this.traceHandler = traceHandler;
	}

	public FileHandler getInfoHandler() {
		return infoHandler;
	}

	public void setInfoHandler(FileHandler infoHandler) {
		this.infoHandler = infoHandler;
	}

	public FileHandler getErrorHandler() {
		return errorHandler;
	}

	public void setErrorHandler(FileHandler errorHandler) {
		this.errorHandler = errorHandler;
	}

	public void trace(String msg) {
		logger.fine(msg);
	}

	public void trace(String msg, Throwable throwable) {
		logger.fine(msg);
		logger.fine(throwable.getMessage());
	}

	public void info(String msg) {
		logger.info(msg);
	}

	public void warning(String msg) {
		logger.warning(msg);
	}

	public void warning(String msg, Throwable throwable) {
	}

	
	public String getSessionName() {
		return sessionName;
	}

	public void setSessionName(String sessionName) {
		this.sessionName = sessionName;
	}

	public long getSessionID() {
		return sessionID;
	}

	public void setSessionID(long sessionID) {
		this.sessionID = sessionID;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

}
