/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;

import com.businesslogic.ireport.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;
import java.util.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "GroupsForm"
 * non viene creato nel metodo main().
 */
public class GroupsForm extends Form
{
	Report report=null;
	public GroupsForm()
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		

		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
	}

	public void setReport( Report rp)
	{
		report = rp;
		this.listView1.removeAllItems();
		Enumeration enum = rp.groups.elements();
							  
		while (enum.hasMoreElements())
		{
			Group g = (Group)enum.nextElement();
			DataListItem lid = new DataListItem(g,g.name,0);
			listView1.addItem(lid);
		}
	}
	/**
	 * GroupsForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void buttonModF_click(Object source, Event e)
	{	
		if (listView1.getSelectedItems().length > 0)
		{
			DataListItem dli = (DataListItem)(listView1.getSelectedItems()[0]);
			Group f = (Group)dli.getData();
		
			GroupForm ff = new GroupForm();
			ff.setGroup(f);
			int delta_h=0;
			int delta_l=0;
			
			if (ff.showDialog() == DialogResult.OK)
			{
				Group g = ff.getGroup();
				f.groupExpression = g.groupExpression;
				delta_h = ff.headerHeight - f.groupHeader.height;
				delta_l = ff.footerHeight - f.groupFooter.height;
				int edge_h =  Math.max( report.getBandYLocation(f.groupHeader), report.getBandYLocation(f.groupHeader)+delta_h);
				int edge_l = Math.max(report.getBandYLocation(f.groupFooter), report.getBandYLocation(f.groupFooter)+delta_h+delta_l);
				
				f.groupFooter.height = ff.footerHeight;
				f.groupHeader.height = ff.headerHeight;
				f.isReprintHeaderOnEachPage = g.isReprintHeaderOnEachPage;
				f.isResetPageNumber = g.isResetPageNumber;
				f.isStartNewColumn = g.isStartNewColumn;
				f.isStartNewPage = g.isStartNewPage;
				f.minHeightToStartNewPage = g.minHeightToStartNewPage;
				dli.setText( f.name);
				
				// We must modify the position of all components of
				// bands behind this...
				
				Enumeration enum = report.getElements().elements();
				while (enum.hasMoreElements())
				{
					ReportElement re = (ReportElement)enum.nextElement();
					if (re.position.y >= edge_h)	
						re.setPosition(new Point(re.position.x,Math.max(edge_h,re.position.y+delta_h)));	
					if (re.position.y >= edge_l)
						re.setPosition(new Point(re.position.x,Math.max(edge_l,re.position.y+delta_l)));	
				}
				
				ReportForm form = report.reportForm;
				if (form != null ) 
				{
					form.refreshAll();
				}	
			}
		}
		;
	}

	private void buttonNewF_click(Object source, Event e)
	{
		
		GroupForm ff = new GroupForm();
		if (ff.showDialog() == DialogResult.OK)
		{	
				Group g = ff.getGroup();
				// Add bands...
				g.groupFooter.height = ff.footerHeight;
				g.groupHeader.height = ff.headerHeight;
				g.groupFooter.name = g.name +"Footer";
				g.groupHeader.name = g.name +"Header";
				DataListItem dli = new DataListItem(g,g.name,0);
				listView1.addItem(dli);
				
				ReportForm form = report.reportForm;
				if (form != null ) 
				{
					report.addGroup(g); 	
					form.refreshAll();
				}			
		}
		;
	}

	private void button2_click(Object source, Event e)
	{
		this.dispose();
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	Panel panel1 = new Panel();
	ListView listView1 = new ListView();
	ColumnHeader columnHeader1 = new ColumnHeader();
	Button buttonModF = new Button();
	Button buttonNewF = new Button();
	Button buttonDelF = new Button();
	Button button2 = new Button();

	private void initForm()
	{
		this.setText("Groups");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.SIZABLE_TOOLWINDOW);
		this.setClientSize(new Point(317, 244));

		panel1.setDock(ControlDock.RIGHT);
		panel1.setLocation(new Point(233, 0));
		panel1.setSize(new Point(84, 244));
		panel1.setTabIndex(0);
		panel1.setText("panel1");

		columnHeader1.setText("Group name");
		columnHeader1.setWidth(225);

		listView1.setDock(ControlDock.FILL);
		listView1.setSize(new Point(233, 244));
		listView1.setTabIndex(1);
		listView1.setText("listView1");
		listView1.setFullRowSelect(true);
		listView1.setGridLines(true);
		listView1.setView(ViewEnum.REPORT);
		listView1.setColumns(new ColumnHeader[] {
							 columnHeader1});

		buttonModF.setFont(Font.DEFAULT_GUI);
		buttonModF.setLocation(new Point(4, 28));
		buttonModF.setSize(new Point(76, 24));
		buttonModF.setTabIndex(3);
		buttonModF.setText("Modify");
		buttonModF.addOnClick(new EventHandler(this.buttonModF_click));

		buttonNewF.setLocation(new Point(4, 4));
		buttonNewF.setSize(new Point(76, 24));
		buttonNewF.setTabIndex(0);
		buttonNewF.setText("New");
		buttonNewF.addOnClick(new EventHandler(this.buttonNewF_click));

		buttonDelF.setLocation(new Point(4, 52));
		buttonDelF.setSize(new Point(76, 24));
		buttonDelF.setTabIndex(2);
		buttonDelF.setText("Delete");

		button2.setAnchor(ControlAnchor.BOTTOMRIGHT);
		button2.setLocation(new Point(4, 213));
		button2.setSize(new Point(76, 24));
		button2.setTabIndex(1);
		button2.setText("Close");
		button2.addOnClick(new EventHandler(this.button2_click));

		this.setNewControls(new Control[] {
							listView1, 
							panel1});
		panel1.setNewControls(new Control[] {
							  button2, 
							  buttonDelF, 
							  buttonModF, 
							  buttonNewF});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new GroupsForm());
	}
}
