/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport;

import com.businesslogic.ireport.ui.*;
import com.businesslogic.ireport.util.*;

import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;

public class TextReportElement extends ReportElement 
{
	public String text;
	public Font   font;
	public String align;
	public String lineSpacing;
	public String fontName;
	public int size;
	public boolean bold;
	public boolean italic;
	public boolean stroke;
	public boolean underline;
	
	
	public TextReportElement(int x, int y, int width, int height, Brush hached)
	{
		super(x,y,width,height,hached);
		text = "Text";
		fontName = "Arial";
		size = 10;
		bold = false;
		italic = false;
		stroke = false;
		underline = false;
		font = new Font("Arial",6);
		align = "Left";
		lineSpacing = "Single";
		mode= "Transparent";
	}
	
	public void drawObject(Graphics g, double zoom_factor, int x_shift_origin, int y_shift_origin)
	{
		this.zoom_factor = zoom_factor;
		Font f = g.getFont();
		
		if (this.font == null)
		{
			font = new Font( fontName,(float)size*(float)0.7,FontSize.POINTS,(( bold )? 0 : 1),italic,underline,stroke);  
		}
		
		Font f2 = new Font(((font != null) ? font : f), (float)(zoom_factor* font.getSize()), font.getUnits()); 
	
		g.setFont(f2);
		g.setTextColor(this.fgcolor);
		int style=0;
		
		if (align.equalsIgnoreCase("Left"))
			style |= TextFormat.LEFT;
		else if (align.equalsIgnoreCase("Right"))
			style |= TextFormat.RIGHT;
		else if (align.equalsIgnoreCase("Center"))
			style |= TextFormat.HORIZONTALCENTER;
		else if (align.equalsIgnoreCase("Justify"))
			style |= TextFormat.HORIZONTALCENTER;
		
		if (!mode.equalsIgnoreCase("Transparent"))
			g.fill( getZoomedDim(position.x-10)+10-x_shift_origin,getZoomedDim(position.y-10)+10-y_shift_origin,getZoomedDim(width),getZoomedDim(height),new Brush(bgcolor, BrushStyle.SOLID));
		
		g.drawString(text, new Rectangle(getZoomedDim(position.x-10)+10-x_shift_origin,getZoomedDim(position.y-10)+10-y_shift_origin,getZoomedDim(width),getZoomedDim(height)),style   | TextFormat.WORDBREAK );
		
		g.setFont(f);
	}
}
