/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;

import com.businesslogic.ireport.*;
import com.businesslogic.ireport.util.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

import java.util.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "ReportForm"
 * non viene creato nel metodo main().
 */
public class ReportForm extends Form
{
	
	Report report;
	Graphics mypan=null;
	com.ms.wfc.ui.Bitmap bmp=null;
	Bitmap bmp2=null;
	Bitmap offscreenbm=null;
	Rectangle my_object;
	boolean selected=false;
	boolean drawbox=false;
	boolean first_draw_band=false;
	double zoom_factor = 1.0;
	Vector clipboardObjects = null;
	// Band dragging vars...
	boolean band_dragging=false;
	int band_dragging_origin=0;
	Band band_dragging_band=null;
	Cursor cursorplus;
	Cursor cursorminus;
	
	public Vector undoOperations;
	public int	  undoIndex=0;
	
		
	int box_x=0;
	int box_y=0;
	//ReportElement selectedElement=null;
	int transformation_type=-1;
	Point transformation_origin=null;
	Point transformation_undo_delta=null;
	boolean shift=false;
	
	boolean new_element = false;
	int new_element_type=0;
	boolean trasforming = false;
	boolean lens_mode = false;
	
	boolean drag_selection_mode = false;
	boolean drag_selection_mode_draw_first = false;
	Point drag_selection_mode_origin = null;

	public Vector selectedElements;
	
	Point mouse=null;
	boolean first_draw=true;
	boolean first_draw2=true;
	int x_scrolled=0;
	int y_scrolled=0;
	int k=0;
	Point ne = null; // Point clicked on New Element
	
	public Report getReport() {  return report; }
	
	public int getDisplayWidth()
	{
		return panel9.getSize().x;
	}
	public ReportForm(Report report)
	{
		super();

		initForm();	
		
		this.report=report;
		report.reportForm = this;
		this.setText(report.getReportName()+" "+report.getPagesize().x+"x"+report.getDesignHeight()+" ("+report.getReportFormat()+")");
		
		undoOperations  =new Vector();
		transformation_undo_delta = new Point(0,0);
		
		cursorplus = new Cursor( ResourceManager.getResource(getClass(), "cursorplus.cur"));
		cursorminus = new Cursor( ResourceManager.getResource(getClass(), "cursorminus.cur"));
		Enumeration enum = report.getElements().elements();
		Brush br = new Brush(imageList2.getBitmap(0));
		while (enum.hasMoreElements())
		{
			ReportElement re = (ReportElement)enum.nextElement();
			re.hached = br;
			
			if (re instanceof SubReportElement)
			{
				
				((SubReportElement)re).img = this.imageList4.getImage(0);
			}
		}
		
		this.HScrollBar1.setMaximum(report.getPagesize().x+19);
		this.HScrollBar1.setLargeChange(panel9.getSize().x);
		
		this.VScrollBar1.setMaximum(report.getPagesize().y+19);
		if (panel9.getSize().y > report.getPagesize().y+19)
			this.HScrollBar1.setLargeChange(panel9.getSize().y);
		else
			this.HScrollBar1.setLargeChange(report.getPagesize().y+19);
		Screen screen = Screen.getPrimary();
		offscreenbm = new Bitmap(screen.bounds.width,  screen.bounds.height);
		offscreenbm.getGraphics().setBackColor(panel9.getBackColor() );
		
		selectedElements = new Vector();
		
		redrawAll( offscreenbm.getGraphics(),new Rectangle(0,0,report.getPagesize().x,report.getPagesize().y),0);
		
		HScrollBar1.setValue(0);
		VScrollBar1.setValue(0);
		
		clipboardObjects = new  Vector();
		
		/*
		mouse = new Point();
		offscreenbm = new Bitmap(1000,5000);
		offscreenbm.getGraphics().setBackColor(Color.CONTROLDARK );
		offscreenbm.getGraphics().clearRect(new Rectangle(0,0,1000,5000));
		
		bmp = new Bitmap(100,100);
		bmp2 = new Bitmap("C:\\Documenti\\Immagini\\giulio.bmp");
		bmp.getGraphics().drawString("CIAOOO",new Point(40,40));
		//bmp.getGraphics().drawImage(bmp2,new Point(0,0));
		my_object = new Rectangle(0,0,bmp2.getSize().x,bmp2.getSize().y);
		
		offscreenbm.getGraphics().drawImage(bmp,new Rectangle(0,0,bmp.getSize().x, bmp.getSize().y), new Rectangle(0,0,bmp.getSize().x, bmp.getSize().y),false);
		offscreenbm.getGraphics().drawImage(bmp2,new Rectangle(0,0,bmp2.getSize().x, bmp2.getSize().y), my_object,false);
		*/
	}
	
	public void setSelectedElement(ReportElement el)
	{
		// Cancello le corone attorno a tutti gli elementi selezionati...
		boolean makerefreshAll = false;
		if (selectedElements.size() > 3)  makerefreshAll=true;
		while (selectedElements.size() > 0)
		{
			ReportElement re = (ReportElement)selectedElements.elementAt(0);
			selectedElements.removeElementAt(0);
			
			if (makerefreshAll) continue;
				
			Rectangle rect = new Rectangle(re.position.x-5,re.position.y-5,re.width+10, re.height+10);
			redrawAll(offscreenbm.getGraphics() ,rect,5);
			Rectangle clipRect = new Rectangle(getZoomedDim(re.position.x-10)-5+10-HScrollBar1.getValue(),
											   getZoomedDim(re.position.y-10)-5+10-VScrollBar1.getValue(),
											   getZoomedDim(re.width)+10,
											   getZoomedDim(re.height)+10);
			panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false);
						
			
			/*
			redrawAll(offscreenbm.getGraphics() ,rect);	
			Rectangle clipRect = new Rectangle(getZoomedDim(re.position.x-10)+10-5-HScrollBar1.getValue() ,getZoomedDim(re.position.y-10)+10-5-VScrollBar1.getValue(),getZoomedDim(re.width)+10, getZoomedDim(re.height)+10);
			//clipRect.offset(-HScrollBar1.getValue(),-VScrollBar1.getValue());
			panel9.createGraphics().drawImage( offscreenbm,rect, clipRect ,false); 
			*/
		}
		
		if (el != null)
		{
			Rectangle rect = new Rectangle(el.position.x-5,el.position.y-5,el.width+10, el.height+10);
			selectedElements.addElement(el);
			if (!makerefreshAll)
			{
				redrawAll(offscreenbm.getGraphics() ,rect,5);
				Rectangle clipRect = new Rectangle(getZoomedDim(el.position.x-10)-5+10-HScrollBar1.getValue(),
											   getZoomedDim(el.position.y-10)-5+10-VScrollBar1.getValue(),
											   getZoomedDim(el.width)+10,
											   getZoomedDim(el.height)+10);
			
				panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false);
			}
		}
		
		if (!makerefreshAll)
		{
			refreshAll();
		}
		
		MainForm mf = (MainForm)this.getMDIParent();
		if (mf != null)
		{
			if (mf.isPropertiesOpened())
			{
					mf.initReportForm();
					mf.ep.setEelement(this,el);
					mf.ep.show();
			}
		}
	}
	
	public void updateElement(ReportElement el,Rectangle oldrect)
	{
		if (el == null) return;
		if (oldrect != null)
		{
			redrawAll(offscreenbm.getGraphics(),oldrect,5);
			Rectangle clipRect = new Rectangle(oldrect);
			clipRect.x = getZoomedDim(oldrect.x+5)-HScrollBar1.getValue()-5;
			clipRect.y = getZoomedDim(oldrect.y+5)-VScrollBar1.getValue()-5;
			clipRect.width = getZoomedDim(clipRect.width-10)+10;
			clipRect.height = getZoomedDim(clipRect.height-10)+10;
			panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false);
		}
		
		
		Rectangle rect = new Rectangle(el.position.x-5,el.position.y-5,el.width+10, el.height+10);
		redrawAll(offscreenbm.getGraphics() ,rect,5);	
		Rectangle clipRect = new Rectangle(rect);
		clipRect.x = getZoomedDim(rect.x+5)-5-HScrollBar1.getValue();
		clipRect.y = getZoomedDim(rect.y+5)-5-VScrollBar1.getValue();
		clipRect.width = getZoomedDim(clipRect.width)+10;
		clipRect.height = getZoomedDim(clipRect.height)+10;
		panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false);
	}
	
	public void addSelectedElement(ReportElement el)
	{
		label1.setText("ADDEDD");
		// Faccio una corona non selected attorno al nuovo elemento...
		if (selectedElements.size() == 0)
		{
			setSelectedElement(el);
			return;
		}
		
		Rectangle rect = new Rectangle(el.position.x-5,el.position.y-5,el.width+10, el.height+10);
		selectedElements.addElement(el);
		redrawAll(offscreenbm.getGraphics() ,rect,5);
		Rectangle clipRect = new Rectangle(getZoomedDim(el.position.x-10)-5+10-HScrollBar1.getValue(),
											   getZoomedDim(el.position.y-10)-5+10-VScrollBar1.getValue(),
											   getZoomedDim(el.width)+10,
											   getZoomedDim(el.height)+10);
		panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false);
	}
	
	
	
	public void setRighelloVisible(boolean bVal)
	{
		this.panel5.setVisible(bVal);
		this.panel4.setVisible(bVal);
	}
	
	private void panel6_paint(Object source, PaintEvent e)
	{
		e.graphics.drawButton(new Rectangle(0,0,panel6.getWidth(),panel6.getHeight()),ButtonState.INACTIVE);
		//e.clipRect.
	} 
	
	private void panel2_paint(Object source, PaintEvent e)
	{
		e.graphics.drawSizeGrip(new Rectangle(0,0,panel2.getWidth(),panel2.getHeight()) );
	}

	private void panel9_paint(Object source, PaintEvent e)
	{
		// We must traslate the clipRect to document coords...
		Rectangle rect = new Rectangle(e.clipRect);
		rect.width = getLogicalDim( e.clipRect.width )+10;
		rect.height = getLogicalDim( e.clipRect.height )+10;
		rect.x = getLogicalDim(HScrollBar1.getValue() + e.clipRect.x )-5;
		rect.y = getLogicalDim(VScrollBar1.getValue() + e.clipRect.y )-5;
		redrawAll(offscreenbm.getGraphics() ,rect,5);
		e.graphics.drawImage( offscreenbm ,e.clipRect,e.clipRect ,false);
	}

	private void VScrollBar1_scroll(Object source, ScrollEvent e)
	{
		if (e.type == ScrollEventType.ENDSCROLL)
		{
			
			label1.setText(e.type +"");
			panel9_paint(panel9, new PaintEvent(panel9.createGraphics(),panel9.getClientRect()) );
			
		}
	}

	private void panel9_mouseMove(Object source, MouseEvent e)
	{
		// tracciamo una linea sul righello orizzontale...
		if (lens_mode) return;
		if (panel7.getVisible())
		{
			// Cancelliamo la linea...
			panel7.createGraphics().drawLine(e.x,0,e.x,16,RasterOp.SOURCE.xorWith(RasterOp.TARGET)); 
			if (!first_draw) panel7.createGraphics().drawLine(mouse.x,0,mouse.x,16,RasterOp.SOURCE.xorWith(RasterOp.TARGET));
			first_draw = false;
		}
		
		if (mouse == null) mouse = new Point();
		
		if (new_element && ne!= null)
		{
			if (new_element_type == ReportElementType.LINE_ELEMENT)
			{
				if (!first_draw2) panel9.createGraphics().drawLine(ne,new Point(mouse.x,mouse.y),RasterOp.SOURCE.xorWith(RasterOp.TARGET)); 
				panel9.createGraphics().drawLine( ne,new Point(e.x,e.y),RasterOp.SOURCE.xorWith(RasterOp.TARGET)); 
				first_draw2 = false;
			}
			else
			{
				// Ripristiniamo il vecchio cerchio...
				if (!first_draw2) panel9.createGraphics().drawLines(new Point[]{new Point(ne.x, ne.y),new Point(mouse.x, ne.y),new Point(mouse.x, mouse.y),new Point(ne.x, mouse.y),new Point(ne.x, ne.y)},RasterOp.SOURCE.xorWith(RasterOp.TARGET)); 
				panel9.createGraphics().drawLines(new Point[]{new Point(ne.x, ne.y),new Point(e.x, ne.y),new Point(e.x, e.y),new Point(ne.x, e.y),new Point(ne.x, ne.y)},RasterOp.SOURCE.xorWith(RasterOp.TARGET)); 
				first_draw2 = false;
			}
		}
		if (drag_selection_mode && drag_selection_mode_origin != null)
		{
			 if (!drag_selection_mode_draw_first) panel9.createGraphics().drawLines(new Point[]{new Point(drag_selection_mode_origin.x, drag_selection_mode_origin.y),new Point(mouse.x, drag_selection_mode_origin.y),new Point(mouse.x, mouse.y),new Point(drag_selection_mode_origin.x, mouse.y),new Point(drag_selection_mode_origin.x, drag_selection_mode_origin.y)},RasterOp.SOURCE.xorWith(RasterOp.TARGET)); 
			 panel9.createGraphics().drawLines(new Point[]{new Point(drag_selection_mode_origin.x, drag_selection_mode_origin.y),new Point(e.x, drag_selection_mode_origin.y),new Point(e.x, e.y),new Point(drag_selection_mode_origin.x, e.y),new Point(drag_selection_mode_origin.x, drag_selection_mode_origin.y)},RasterOp.SOURCE.xorWith(RasterOp.TARGET)); 
			 drag_selection_mode_draw_first = false;
			 mouse.x = e.x;
			 mouse.y = e.y;
			 return;
		}
		
		if (!new_element && !trasforming)
		{
			// Is the mouse over a band line ?...
			if (band_dragging)
			{
				//  2. delta = Max altezza banda precedente e position delta
				int delta = getLogicalDim( e.y-band_dragging_origin );
				this.label1.setText(band_dragging_band.name +  " band height: " +(band_dragging_band.height));
				if (delta != 0)
				{
					
					// Vediamo se  possibile andare pi su...
					// Non possiamo andare pi su della banda prima...
					//	1. Cerchiamo la banda precedente...
					
					int min_logical_base = getReport().topMargin+10;
					int base_position=0;// = Math.max(min_logical_base, getReport().getBandYLocation(band_dragging_band) +delta);
					base_position = getZoomedDim(getReport().getBandYLocation(band_dragging_band))+10- VScrollBar1.getValue();
					if (!first_draw_band) panel9.createGraphics().drawLine( new Point(0,Math.max(mouse.y,base_position)),new Point(panel9.getWidth(),Math.max(mouse.y,base_position)), RasterOp.SOURCE.xorWith(RasterOp.TARGET)); 
					panel9.createGraphics().drawLine(  new Point(0,Math.max(e.y,base_position)),new Point(panel9.getWidth(),Math.max(e.y,base_position)),RasterOp.SOURCE.xorWith(RasterOp.TARGET)); 
					first_draw_band = false;
					this.label1.setText(band_dragging_band.name +  " band height: " +(band_dragging_band.height + delta));
				}
			}
			else
			{
				int bl =  e.y+VScrollBar1.getValue();
				Enumeration enum = report.bands.elements();
				int y= report.topMargin;
				boolean found=false;
				while (!found && enum.hasMoreElements())
				{
					Band band = (Band)enum.nextElement();
					y += band.height;
					if (bl>getZoomedDim(y)+10-3 && bl < getZoomedDim(y)+3+10)
					{
						panel9.setCursor(Cursor.HSPLIT);
						this.label1.setText("Drag "+band.name);
						found = true;
					}
				}
				if (!found && panel9.getCursor() == Cursor.HSPLIT)
				{
						panel9.setCursor(Cursor.DEFAULT);
						this.label1.setText("");
				}
			}
		}
		
		if (selectedElements.size() >0 && !new_element)
		{
			// We are trasformation mode?
			if (transformation_type >=0 && trasforming)
			{
				
				boolean makerefreshAll = false;
				if (selectedElements.size() > 3)  makerefreshAll=true;
				//transformation_origin = new Point(e.x+HScrollBar1.getValue(),e.y+VScrollBar1.getValue());
				// Calcoliamo il delta
				Point p = new Point();		
				Enumeration enum = selectedElements.elements();
				p.x = getLogicalDim(e.x - transformation_origin.x);
				p.y = getLogicalDim(e.y - transformation_origin.y);
				
				// Search for minimum delta admitted
				Point real_delta = new Point(0,0);
				int kkk=0;
				while ((p.x!=0 || p.y!=0) && enum.hasMoreElements())
				{
					ReportElement selectedRe = (ReportElement)enum.nextElement();
					Point dt = selectedRe.trasformTest(p, transformation_type);
					if (kkk==0)
						real_delta = dt;
					else
					{
						real_delta.x = Math.min(dt.x,real_delta.x);
						real_delta.y = Math.min(dt.y,real_delta.y);
					}
				}
				
				transformation_undo_delta.x += real_delta.x;
				transformation_undo_delta.y += real_delta.y;
				
				enum = selectedElements.elements();
				int maxx = ((ReportElement)selectedElements.firstElement()).position.x+((ReportElement)selectedElements.firstElement()).width;

				while ((real_delta.x!=0 || real_delta.y!=0) && enum.hasMoreElements())
				{				
					ReportElement selectedRe = (ReportElement)enum.nextElement();
					// Redraw interessed area...
					Rectangle rect = new Rectangle(Math.min( selectedRe.position.x-5 ,selectedRe.position.x+p.x-5),
											   Math.min(selectedRe.position.y-5,selectedRe.position.y+p.y-5),
											   selectedRe.width + Math.abs(p.x)+10,selectedRe.height + Math.abs(p.y)+10);
				
					if (selectedRe.position.x >= maxx && panel9.getModifierKeys()== Key.SHIFT && transformation_type == TransformationType.TRANSFORMATION_RESIZE_E)
					{
							selectedRe.trasform(real_delta, TransformationType.TRANSFORMATION_RESIZE_W);
					}
					else
						selectedRe.trasform(real_delta, transformation_type);
					
					if (!makerefreshAll)
					{
						redrawAll(offscreenbm.getGraphics() , rect,5);
						// Get Real dimensions...
						Rectangle clipRect = new Rectangle(getZoomedDim(rect.x-10+5)-5+10,
													   getZoomedDim(rect.y-10+5)-5+10,
													   getZoomedDim(rect.width-10)+10,
													   getZoomedDim(rect.height-10)+10);
						clipRect.offset(-HScrollBar1.getValue(),-VScrollBar1.getValue());
						panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false); 
					}
				}
				if (makerefreshAll) refreshAll();
				if (p.x != 0) transformation_origin.x = e.x;
				if (p.y != 0) transformation_origin.y = e.y;
			}
			else
			{
				// Vediamo se siamo sopra la figura...
				Enumeration enum = selectedElements.elements();
				boolean found = false;
				boolean sizeall = false;
				while (!found && enum.hasMoreElements() )
				{
					
					ReportElement selectedRe = (ReportElement)enum.nextElement();
					Rectangle grip = new Rectangle(getZoomedDim(selectedRe.position.x-10)-5+10, getZoomedDim(selectedRe.position.y-10)-5+10,
												   getZoomedDim(selectedRe.width)+10,getZoomedDim(selectedRe.height)+10);
					Rectangle cursor = new Rectangle(e.x+HScrollBar1.getValue(),
											e.y+VScrollBar1.getValue(),
											 1,1);
										
					if (cursor.intersectsWith(grip))
					{
						sizeall = true;
						// Vediamo se interseca una grip...
						grip.width  = 5;
						grip.height = 5;
						
						if (cursor.intersectsWith(grip))
						{
							panel9.setCursor(Cursor.SIZENWSE);
							found =true;
							transformation_type = TransformationType.TRANSFORMATION_RESIZE_NW; 
						}
						
						if (!found)
						{
							grip.x = getZoomedDim(selectedRe.position.x-10+selectedRe.width)+10;
							grip.y = getZoomedDim(selectedRe.position.y-10)+10-5;
							grip.width  = 5;
							grip.height = 5;
							if (cursor.intersectsWith(grip))
							{
								panel9.setCursor(Cursor.SIZENESW);
									found =true;
								transformation_type = TransformationType.TRANSFORMATION_RESIZE_NE;
							}
						}
						
						if (!found)
						{
							grip.x = getZoomedDim(selectedRe.position.x-10)+10-5;
							grip.y = getZoomedDim(selectedRe.position.y+(selectedRe.height/2)-10)+10-2;
							grip.width  = 5;
							grip.height = 5;
								if (cursor.intersectsWith(grip))
							{
								panel9.setCursor(Cursor.SIZEWE);
								found =true;
								transformation_type = TransformationType.TRANSFORMATION_RESIZE_W;
							}
						}
						
						if (!found)
						{
							grip.x = getZoomedDim(selectedRe.position.x-10)+10-5;
							grip.y = getZoomedDim(selectedRe.position.y-10+selectedRe.height)+10;
							grip.width  = 5;
							grip.height = 5;
							if (cursor.intersectsWith(grip))
							{
								panel9.setCursor(Cursor.SIZENESW);
								found =true;
								transformation_type = TransformationType.TRANSFORMATION_RESIZE_SW;
							}
						}
						
						if (!found)
						{
							grip.x = getZoomedDim(selectedRe.position.x+(selectedRe.width/2)-10)+10-2;
							grip.y = getZoomedDim(selectedRe.position.y-10)+10-5;
							grip.width  = 5;
							grip.height = 5;
							if (cursor.intersectsWith(grip))
							{
								panel9.setCursor(Cursor.SIZENS);
								found =true;
								transformation_type = TransformationType.TRANSFORMATION_RESIZE_N;
							}
						}
						
						if (!found)
						{
							grip.x = getZoomedDim(selectedRe.position.x+(selectedRe.width/2)-10)+10-2;
							grip.y = getZoomedDim(selectedRe.position.y+selectedRe.height-10)+10;
							grip.width  = 5;
							grip.height = 5;
							if (cursor.intersectsWith(grip))
							{
								panel9.setCursor(Cursor.SIZENS);
								found =true;
								transformation_type = TransformationType.TRANSFORMATION_RESIZE_S;
							}
						}
						
						if (!found)
						{
							grip.x = getZoomedDim(selectedRe.position.x+selectedRe.width-10)+10;
							grip.y = getZoomedDim(selectedRe.position.y+selectedRe.height-10)+10;
							grip.width  = 5;
							grip.height = 5;
							if (cursor.intersectsWith(grip))
							{
								panel9.setCursor(Cursor.SIZENWSE);
								found =true;
								transformation_type = TransformationType.TRANSFORMATION_RESIZE_SE;
							}
						}
						
						if (!found)
						{
							grip.x = getZoomedDim(selectedRe.position.x+selectedRe.width-10)+10;
							grip.y = getZoomedDim(selectedRe.position.y+(selectedRe.height/2)-10)+10-2;
							grip.width  = 5;
							grip.height = 5;
							if (cursor.intersectsWith(grip))
							{
								panel9.setCursor(Cursor.SIZEWE);
								found =true;
								transformation_type = TransformationType.TRANSFORMATION_RESIZE_E;
							}
						}
						
						if (!found)
						{
							panel9.setCursor(Cursor.SIZEALL);
							transformation_type = TransformationType.TRANSFORMATION_MOVE;
						}
					}
				}
				if (!sizeall)
				{
						panel9.setCursor(Cursor.DEFAULT);
						transformation_type = TransformationType.TRANSFORMATION_NONE;
				}
			}
		}
		
		mouse.x = e.x;
		mouse.y = e.y;
	}

	public void prepareForNewElement(int elementType)
	{
		new_element = true;
		new_element_type = elementType;
		panel9.setCursor(Cursor.CROSS);
	}
	
	
	private void panel9_mouseDown(Object source, MouseEvent e)
	{
		if (e.button != MouseButton.LEFT) return;
		if (lens_mode)
		{
			// aumentiamo il fattore di ingrandimento del 50 %....
			if (shift)
				this.setZoomFactor(Math.max(0.1,zoom_factor/1.5));
			else
				this.setZoomFactor(Math.min(5,zoom_factor*1.5));
			
			return;
		}
		panel9.focus();
		if (new_element)
		{
			first_draw2 = false;
			ne = new Point(e.x,e.y);
			return;
		}
		
		if (selectedElements.size() > 0)
		{
			// We are trasformation mode?
			if (transformation_type >=0)
			{
				trasforming = true;
				transformation_origin = new Point(e.x,e.y);
				transformation_undo_delta = new Point(0,0);
				return;
			}
		}
		
		// We want drag a band edge?...
		if (panel9.getCursor() == Cursor.HSPLIT)
		{
				first_draw_band=true;
			    int bl = e.y+VScrollBar1.getValue();
				Enumeration enum = report.bands.elements();
				int y=report.topMargin;
				boolean found=false;
				Band band=null;
				
				
				
				if ( panel9.getModifierKeys() == Key.ALT)
				{
					label1.setText("Inverse search");
					y = getReport().getDesignHeight()-getReport().bottomMargin;
					for (int b =report.bands.size()-1; b>=0; --b)
					{
						band = (Band)report.bands.elementAt(b);
						
						if (bl>getZoomedDim(y)+10-3 && bl < getZoomedDim(y)+10+3)
						{
							break;
						}
						y -= band.height;
						
					}
				}
				else
				{
					while (enum.hasMoreElements())
					{
						band = (Band)enum.nextElement();
						y += band.height;
							if (bl>getZoomedDim(y)+10-3 && bl < getZoomedDim(y)+10+3)
						{
							break;
						}
					}
				}
				
				if (band != null) 
				{
					
					band_dragging = true;
					band_dragging_origin = e.y;
					band_dragging_band = band;
					this.label1.setText(band_dragging_band.name +  " band height: " +(band_dragging_band.height));
					return;
				}
		}
			
		for (int i=report.getElements().size()-1; i>=0; --i)
			{
				ReportElement re = (ReportElement)report.getElements().elementAt(i);
				if (re.intersects(new Point(getLogicalDim(e.x+HScrollBar1.getValue()-10)+10,getLogicalDim(e.y+VScrollBar1.getValue()-10)+10)))
				{
					if (selectedElements.size()>0 && re == ((ReportElement)selectedElements.firstElement())) return; 
					// 1.<Cancel old corona...
										
					if (selectedElements.size() > 0 && !shift)
					{
						ReportElement oldselected = (ReportElement)selectedElements.firstElement();
						Rectangle rect = new Rectangle(oldselected.position.x-5,oldselected.position.y-5,oldselected.width+10, oldselected.height+10);
						setSelectedElement(null);
						redrawAll(offscreenbm.getGraphics() ,rect,5);
						Rectangle clipRect = new Rectangle(getZoomedDim(oldselected.position.x-10)-5+10-HScrollBar1.getValue(),
													   getZoomedDim(oldselected.position.y-10)-5+10-VScrollBar1.getValue(),
													   getZoomedDim(oldselected.width)+10,
													   getZoomedDim(oldselected.height)+10);
						clipRect.offset(-HScrollBar1.getValue(),-VScrollBar1.getValue());
						panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false); 
					}
					
					
					//re.drawObject(offscreenbm.getGraphics());
					if (!shift || selectedElements.size()==0)
					{
						setSelectedElement(re);
					}
					else
					{
						addSelectedElement(re);						
					}
					trasforming = true;
					transformation_origin = new Point(e.x,e.y);
					transformation_type = TransformationType.TRANSFORMATION_MOVE;
					panel9.setCursor(Cursor.SIZEALL);
					return;
				}
			}
			if (selectedElements.size()>0)
			{
				ReportElement myre = (ReportElement)selectedElements.firstElement();
				if (myre != null)
				{
					Rectangle rect = new Rectangle(myre.position.x-5,myre.position.y-5,myre.width+10, myre.height+10);
					setSelectedElement(null);
					redrawAll(offscreenbm.getGraphics() ,rect,5);
					Rectangle clipRect =new Rectangle(getZoomedDim(myre.position.x-10)+10-5-HScrollBar1.getValue() ,
													  getZoomedDim(myre.position.y-10)+10-5-VScrollBar1.getValue(),
													  getZoomedDim(myre.width)+10,
													  getZoomedDim(myre.height)+10);
					//clipRect.offset(-HScrollBar1.getValue(),-VScrollBar1.getValue());
					panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false); 
				}
			}
			setSelectedElement(null);
			// We can enter in drag selection mode...
			drag_selection_mode = true;
			drag_selection_mode_draw_first = true;
			drag_selection_mode_origin = panel9.pointToClient( this.panel9.getMousePosition());
			mouse = new Point( drag_selection_mode_origin);
	}

	private void panel9_mouseUp(Object source, MouseEvent e)
	{
		if (e.button != MouseButton.LEFT) return;
		if (lens_mode)
		{
			//lens_mode = false;
			return;
		}
		this.selected=false;
		this.drawbox = false;
		
		if (drag_selection_mode)
		{
			 if (!drag_selection_mode_draw_first) panel9.createGraphics().drawLines(new Point[]{new Point(drag_selection_mode_origin.x, drag_selection_mode_origin.y),new Point(mouse.x, drag_selection_mode_origin.y),new Point(mouse.x, mouse.y),new Point(drag_selection_mode_origin.x, mouse.y),new Point(drag_selection_mode_origin.x, drag_selection_mode_origin.y)},RasterOp.SOURCE.xorWith(RasterOp.TARGET)); 
			 drag_selection_mode = false;
			 // Select all within the rect... 
			 int originX = getLogicalDim( Math.min(drag_selection_mode_origin.x-10+HScrollBar1.getValue(),e.x-10+HScrollBar1.getValue()))+10;
			 int originY = getLogicalDim( Math.min(drag_selection_mode_origin.y-10+VScrollBar1.getValue(),e.y-10+VScrollBar1.getValue()))+10;
			 int width  =  getLogicalDim(Math.abs( e.x-drag_selection_mode_origin.x));
			 int height =  getLogicalDim(Math.abs(e.y-drag_selection_mode_origin.y));
			 Rectangle  rect = new Rectangle(originX,originY,width, height);
			 Enumeration enum = report.getElements().elements();
			 while (enum.hasMoreElements())
			 {
				ReportElement re = (ReportElement)enum.nextElement();
				if (re.intersects(rect))
					//this.addSelectedElement(re);
					selectedElements.addElement(re);
			 }
			 refreshAll();
		}
		
		if (new_element)
		{
			new_element=false;
			first_draw2 = true;
			panel9.setCursor(Cursor.DEFAULT);
			ReportElement re = null;
			// Find the band to associate to the new element...
			Enumeration enum_bands = report.bands.elements();
			Band bname = null;
			int originX = getLogicalDim( Math.min(ne.x-10+HScrollBar1.getValue(),e.x-10+HScrollBar1.getValue()))+10;
			int originY = getLogicalDim( Math.min(ne.y-10+VScrollBar1.getValue(),e.y-10+VScrollBar1.getValue()))+10;
			int width  =  getLogicalDim(Math.abs( e.x-ne.x));
			int height =  getLogicalDim(Math.abs(e.y-ne.y));
			while (enum_bands.hasMoreElements())
			{
				Band b = (Band)enum_bands.nextElement();
				if (report.getBandYLocation(b) <= originY)
				{
					bname = b;
				}
			}
						
			if (new_element_type == ReportElementType.RECTANGLE_ELEMENT)
			{
				re = new RectangleReportElement( originX,originY,width,height, new Brush(imageList2.getBitmap(0))); 
			}
			else if (new_element_type == ReportElementType.SUBREPORT_ELEMENT)
			{
				re = new SubReportElement( originX,originY,width,height, new Brush(imageList2.getBitmap(0)));
				if (re instanceof SubReportElement)
				((SubReportElement)re).img = this.imageList4.getImage(0);
			}
			else if (new_element_type == ReportElementType.IMAGE_ELEMENT)
			{
				re = new ImageReportElement( originX,originY,width,height, new Brush(imageList2.getBitmap(0)));
				((ImageReportElement)re).defimg  = imageList3.getBitmap(0);
			}
			else if (new_element_type == ReportElementType.STATICTEXT_ELEMENT)
			{
				re = new StaticTextReportElement( originX,originY,width,height, new Brush(imageList2.getBitmap(0)));
			}
			else if (new_element_type == ReportElementType.LINE_ELEMENT)
			{
				String direction="BottomUp";
				if (ne.x<= e.x && ne.y <= e.y) direction="TopDown";
				else if (ne.x<= e.x && ne.y > e.y) direction="BottomUp";
				else if (ne.x > e.x && ne.y > e.y) direction="TopDown";	
				else if (ne.x > e.x && ne.y <= e.y) direction="BottomUp";	
				
				re = new LineReportElement( originX,originY,width,height, new Brush(imageList2.getBitmap(0)), direction);
			}
			else if (new_element_type == ReportElementType.TEXTFIELD_ELEMENT )
			{
				re = new TextFieldReportElement( originX,originY,width,height, new Brush(imageList2.getBitmap(0)));
			}
			else
			{
				re = new ReportElement( originX,originY,width,height, new Brush(imageList2.getBitmap(0)));
			}
			
			
			re.band = bname;
			report.getElements().addElement(re);
			
			if (selectedElements.size() > 0)
			{
				ReportElement oldselected = (ReportElement)selectedElements.firstElement();
				Rectangle rect = new Rectangle(oldselected.position.x-5,oldselected.position.y-5,oldselected.width+10, oldselected.height+10);
				setSelectedElement(null);
				redrawAll(offscreenbm.getGraphics() ,rect,5);
				Rectangle clipRect = new Rectangle(getZoomedDim(oldselected.position.x-10)-5+10-HScrollBar1.getValue(),
													   getZoomedDim(oldselected.position.y-10)-5+10-VScrollBar1.getValue(),
													   getZoomedDim(oldselected.width)+10,
													   getZoomedDim(oldselected.height)+10);
				clipRect.offset(-HScrollBar1.getValue(),-VScrollBar1.getValue());
				panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false); 
			}

			setSelectedElement(re);
			ne = null;		
			// Add undo operation...
			UndoOperation uo = new UndoOperation(UndoOperationType.UNDO_INSERT);
			uo.params.addElement(new Integer(1));
			ReportElement clone = re.cloneMe();
			
			uo.params.addElement(clone);
			addUndoOperation(uo);
			
			((MainForm)this.getMDIParent()).setPressed(0);			
		}
		
		if (trasforming)
		{
			trasforming = false;
			
			panel9.setCursor(Cursor.DEFAULT);
			
			Point p = new Point(transformation_undo_delta);		
		
			if (p.x!=0 || p.y != 0)
			{
				UndoOperation uo = new UndoOperation(UndoOperationType.UNDO_TRANSFORMATION); 
				uo.params.addElement(p);
				uo.params.addElement(new Integer( transformation_type ) );
				Enumeration enum = selectedElements.elements();
				while (enum.hasMoreElements())
				{
						uo.params.addElement(enum.nextElement());
				}
				addUndoOperation(uo);
			}
			transformation_undo_delta = new Point(0,0);
			transformation_type = TransformationType.TRANSFORMATION_NONE;
			MainForm mf = (MainForm)this.getMDIParent();
			if (mf != null)
			{
				if (mf.isPropertiesOpened())
				{
					mf.initReportForm();
					mf.ep.setEelement(this,(ReportElement)selectedElements.firstElement());
					mf.ep.show();
				}
			}
		}
		
		if (band_dragging )
		{
			band_dragging = false;
			
			// _________ BEGIN DRAGGING REAL TIME CODE ___________________
			// Work with logical dimensions...
			int delta = getLogicalDim( e.y-band_dragging_origin );
			if (delta != 0)
			{
				// Search for min_height that don't cover elements in this band...
				int min_height = 0;
				Enumeration enum = report.getElements().elements();
				int band_h =  report.getBandYLocation(band_dragging_band) +10;
				//	
				//	while (enum.hasMoreElements())
				//	{
				//		ReportElement re = (ReportElement)enum.nextElement();
				//		if (re.position.y+re.height >= band_h && re.position.y<= band_h+band_dragging_band.height)
				//		{
				//			min_height = Math.max(min_height, re.position.y+re.height-band_h); 
				//		}
				//	}
			
				if (delta < -(  band_dragging_band.height-min_height) ) delta= -(band_dragging_band.height-min_height);
				if (report.getDesignHeight()+delta > report.getPagesize().y) delta = report.getPagesize().y- report.getDesignHeight();
				// Redraw all under the min height...
				band_dragging_band.height += delta;
						
				this.panel9_resize(panel9,new Event());
	
				this.label1.setText("DRagged: "+band_dragging_band.name +" "+delta);
				int edge_y =  Math.min(report.getBandYLocation(band_dragging_band)+band_dragging_band.height,report.getBandYLocation(band_dragging_band)+band_dragging_band.height-delta);
				enum = report.getElements().elements();
				while (enum.hasMoreElements())
				{
					ReportElement re = (ReportElement)enum.nextElement();
					if (re.position.y >= edge_y)	
					{
						re.setPosition(new Point(re.position.x,re.position.y+delta));	
						//this.updateElement(re,new Rectangle(re.position.x-5,re.position.y-5-delta,re.width+10, re.height+10+delta));
					}	
					else if (re.position.y+re.height >= edge_y)
					{
						//this.updateElement(re,new Rectangle(re.position.x-5,re.position.y-5-delta,re.width+10, re.height+10+delta));
					}
				}		
			}
				
			//Rectangle rect = new Rectangle( getLogicalDim( HScrollBar1.getValue() ), Math.min(10+getLogicalDim(report.getBandYLocation(band_dragging_band)+band_dragging_band.height),10+getLogicalDim(report.getBandYLocation(band_dragging_band)+band_dragging_band.height-delta)),
			//												  getLogicalDim(panel9.getWidth()),getLogicalDim(panel9.getHeight()));
			Rectangle rect = panel9.getDisplayRect(); //new Rectangle(0,0,report.getPagesize().x, report.getDesignHeight());
						
			// drag down all elements under this band...
			redrawAll(offscreenbm.getGraphics(),rect,0);
			Rectangle clipRect = panel9.getDisplayRect();      //new Rectangle(rect);
			//clipRect.offset(-HScrollBar1.getValue(),-VScrollBar1.getValue());
			//panel9.createGraphics().drawRect(clipRect,RasterOp.BLACK);
			panel9.createGraphics().drawImage( offscreenbm,rect, clipRect ,false); 
// _________ STOP DRAGGING REAL TIME CODE ___________________	
			
			if (selectedElements.size()>0)
			{
				MainForm mf = (MainForm)this.getMDIParent();
				if (mf != null)
				{
					if (mf.isPropertiesOpened())
					{
						mf.initReportForm();
						mf.ep.setEelement(this,(ReportElement)selectedElements.firstElement());
						mf.ep.show();
					}
				}
			}
		}
	}
	

	private void HScrollBar1_scroll(Object source, ScrollEvent e)
	{
		if (e.type == ScrollEventType.ENDSCROLL)
		{
			
			label1.setText(e.type +"");
			panel9_paint(panel9, new PaintEvent(panel9.createGraphics(),panel9.getClientRect()) );
			panel7_paint(panel7, new PaintEvent(panel7.createGraphics(),panel7.getClientRect()));
		}	
	}
	
	/**
	 * ReportForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	/**
	 * Cut operation...
	 */
	public void cut(Vector clipboardObjects)
	{
		if (selectedElements.size() > 0)
		{
			clipboardObjects.removeAllElements();
			while (selectedElements.size() > 0)
			{
				ReportElement re = (ReportElement)selectedElements.elementAt(0);
				selectedElements.removeElementAt(0);
				report.getElements().removeElement(re);
				
				clipboardObjects.addElement(re.cloneMe());

				Rectangle rect = new Rectangle(re.position.x-5,re.position.y-5,re.width+10, re.height+10);
				redrawAll(offscreenbm.getGraphics() ,rect,5);
				Rectangle clipRect = new Rectangle(getZoomedDim(re.position.x-10)-5+10-HScrollBar1.getValue(),
											   getZoomedDim(re.position.y-10)-5+10-VScrollBar1.getValue(),
											   getZoomedDim(re.width)+10,
											   getZoomedDim(re.height)+10);
				panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false);
			}
			this.setSelectedElement(null);
		}
	}
	
	public void copy(Vector clipboardObjects)
	{
		if (selectedElements.size() > 0)
		{
			clipboardObjects.removeAllElements();
			for (int i=0; i<selectedElements.size(); ++i)
			{
				ReportElement re = (ReportElement)selectedElements.elementAt(i);
				clipboardObjects.addElement(re.cloneMe());
			}
		}
	}

	/**
	 * Paste operation...
	 */
	public void paste(Vector clipboardObjects)
	{
		if (clipboardObjects.size()>0)
			setSelectedElement(null);
		
		UndoOperation uo = new UndoOperation(UndoOperationType.UNDO_INSERT);
		int k=0;
		uo.params.addElement(new Integer( clipboardObjects.size() ));
		
		boolean makerefreshAll = false;
		if (clipboardObjects.size() > 3)  makerefreshAll=true;
		for (int i=0; i< clipboardObjects.size(); ++i)
		{
			ReportElement re = (ReportElement)clipboardObjects.elementAt(i);
			if (re == null) continue;
			re = re.cloneMe();
			// Find corresponding band...
			
			Enumeration enum = this.getReport().bands.elements();
			boolean find = false;
			while (re.band != null && enum.hasMoreElements())
			{
				Band b = (Band)enum.nextElement();
				if (b!=null && b.name != null && b.name.equals( re.band.name))
				{
					re.band = b;
					find = true;
					break;
				}
			}
			if (!find)
				re.band = (Band)this.getReport().bands.firstElement();
			
			getReport().getElements().addElement(re);
			ReportElement clone = re.cloneMe();
			uo.params.addElement(clone);
			k++;
			if (!makerefreshAll)
			{
				Rectangle rect = new Rectangle(re.position.x-5,re.position.y-5,re.width+10, re.height+10);
				redrawAll(offscreenbm.getGraphics() ,rect,5);
				Rectangle clipRect = new Rectangle(getZoomedDim(re.position.x-10)-5+10-HScrollBar1.getValue(),
										   getZoomedDim(re.position.y-10)-5+10-VScrollBar1.getValue(),
										   getZoomedDim(re.width)+10,
										   getZoomedDim(re.height)+10);
				panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false);
				addSelectedElement(re);			
			}
			else
			{
				selectedElements.addElement(re);
			}
		}
		if (makerefreshAll) refreshAll();
		
		addUndoOperation(uo);
	}
	
	/**
	 * Cut operation...
	 */
	public void copy()
	{

	}

	private void panel9_resize(Object source, Event e)
	{		
		if (panel9.getSize().x >= (getZoomedDim( report.getPagesize().x)+19))
		{
			HScrollBar1.setMaximum(report.getPagesize().x);
			HScrollBar1.setLargeChange( HScrollBar1.getMaximum());
			HScrollBar1.setValue(0);
			HScrollBar1_scroll(HScrollBar1, new ScrollEvent( ScrollEventType.ENDSCROLL,0));
		}
		else
		{
			HScrollBar1.setMaximum((getZoomedDim( report.getPagesize().x)+19));
			this.HScrollBar1.setLargeChange(panel9.getSize().x);
		}
		if (panel9.getSize().y >= getZoomedDim(report.getDesignHeight())+19)
		{
			VScrollBar1.setMaximum(report.getDesignHeight());
			VScrollBar1.setLargeChange( VScrollBar1.getMaximum());
			VScrollBar1.setValue(0);
			VScrollBar1_scroll(VScrollBar1, new ScrollEvent( ScrollEventType.ENDSCROLL,0));
		}
		else
		{
			VScrollBar1.setMaximum(getZoomedDim( report.getDesignHeight())+19);
			this.VScrollBar1.setLargeChange(panel9.getSize().y);
		}									 
	}


	private void panel7_paint(Object source, PaintEvent e)
	{
		// Disegnamo un righello...
		first_draw = true;
		double k=0;
		int line=0;
		int i = 10-HScrollBar1.getValue();
		e.graphics.clearRect(e.clipRect);
		e.graphics.drawLine(0,15,panel7.getSize().x,15);
		int oldi=-100;
		for (; i< panel7.getSize().x; )
		{
			if (i>=0)
			{
				if ((line%2)==0)
				{
					if (i-oldi > 12)
					{
						e.graphics.drawString( ((int)k)+"",i-50,-1,100,16, TextFormat.HORIZONTALCENTER);
						oldi= i;
					}
					e.graphics.drawLine(i,16,i,10,RasterOp.BLACK);
					//if (k==2)
					//e.graphics.drawLines(new Point[]{new Point(i-50,1),new Point(i+50,1), new Point(i+50,5),new Point(i-50,5) });
				}
				else //if ((k%5)==0)
				{
					//if (i-oldi > 7)
					{
						e.graphics.drawLine(i,16,i,12,RasterOp.BLACK);
						//oldi= i;
					}
				}
			}
			//else //if ((k%1)==0.5)
			//	e.graphics.drawLine(i,16,i,13,RasterOp.BLACK);

			line++;
			k = line*0.5;
			if ( ((MainForm)this.getParentForm()).ireportProperties.getProperty("DEFAULT_UNITS") != null &&
				 ((MainForm)this.getParentForm()).ireportProperties.getProperty("DEFAULT_UNITS").equals("inches"))
				i = getZoomedDim((int)UnitConverter.convertInchesToPixels(k))+10-HScrollBar1.getValue();
			else if ( ((MainForm)this.getParentForm()).ireportProperties.getProperty("DEFAULT_UNITS") != null &&
				 ((MainForm)this.getParentForm()).ireportProperties.getProperty("DEFAULT_UNITS").equals("pixels"))
				i = getZoomedDim((int)(10*k))+10-HScrollBar1.getValue();
			else 
				i = getZoomedDim((int)UnitConverter.convertCentimetersToPixels(k))+10-HScrollBar1.getValue();
		
			//label1.setText(label1.getText() +" "+k);
			
		}
	}
	
	public void drawVoidDoc(Graphics g)
	{
		g.drawRect(10-HScrollBar1.getValue(),10-VScrollBar1.getValue(),getZoomedDim(report.getPagesize().x), getZoomedDim(report.getDesignHeight()),RasterOp.WHITE );
		g.drawLines(new Point[]{new Point(9-HScrollBar1.getValue(),9-VScrollBar1.getValue()), new Point(getZoomedDim(report.getPagesize().x)+10-HScrollBar1.getValue(),9-VScrollBar1.getValue()),new Point(getZoomedDim(report.getPagesize().x)+10-HScrollBar1.getValue(),getZoomedDim(report.getDesignHeight())+10-VScrollBar1.getValue()), new Point(9-HScrollBar1.getValue(),getZoomedDim(report.getDesignHeight())+10-VScrollBar1.getValue()),new Point(9-HScrollBar1.getValue(),9-VScrollBar1.getValue())},RasterOp.BLACK);
		
		g.setBrush(new Brush(imageList1.getBitmap(0)));
		g.setBrushOrigin(getZoomedDim(report.getPagesize().x)+11-HScrollBar1.getValue(),9-VScrollBar1.getValue());
		g.fill(getZoomedDim(report.getPagesize().x)+11-HScrollBar1.getValue(),9-VScrollBar1.getValue(),9,9);
		
		g.setBrush(new Brush(imageList1.getBitmap(1)));
		g.setBrushOrigin(getZoomedDim(report.getPagesize().x)+11-HScrollBar1.getValue(),18-VScrollBar1.getValue());
		g.fill( getZoomedDim(report.getPagesize().x)+11-HScrollBar1.getValue(),18-VScrollBar1.getValue(), 9,getZoomedDim(report.getDesignHeight())-7);
		
		g.setBrush(new Brush(imageList1.getBitmap(2)));
		g.setBrushOrigin(getZoomedDim(report.getPagesize().x)+11-HScrollBar1.getValue(),getZoomedDim(report.getDesignHeight())+11-VScrollBar1.getValue());
		g.fill( getZoomedDim(report.getPagesize().x)+11-HScrollBar1.getValue(),getZoomedDim(report.getDesignHeight())+11-VScrollBar1.getValue(),9,9);
		
		g.setBrush(new Brush(imageList1.getBitmap(3)));
		g.setBrushOrigin(9-HScrollBar1.getValue(),getZoomedDim(report.getDesignHeight())+11-VScrollBar1.getValue());
		g.fill(9-HScrollBar1.getValue(),getZoomedDim(report.getDesignHeight())+11-VScrollBar1.getValue(), getZoomedDim(report.getPagesize().x)+2,9);
		
		g.setBrush(new Brush(imageList1.getBitmap(4)));
		g.setBrushOrigin(9-HScrollBar1.getValue(),getZoomedDim(report.getDesignHeight())+11-VScrollBar1.getValue());
		g.fill( 9-HScrollBar1.getValue(),getZoomedDim(report.getDesignHeight())+11-VScrollBar1.getValue(),9,9);
		
		// Draw document structure lines...
		g.setPen(new Pen(new Color(170,170,255)));
		// LEFT MARGINE LINE
		g.drawLine(getZoomedDim(report.leftMargin)+10-HScrollBar1.getValue(),
				   10-VScrollBar1.getValue(),
				   getZoomedDim(report.leftMargin)+10-HScrollBar1.getValue(),
				   getZoomedDim(report.getDesignHeight())+10-VScrollBar1.getValue()); 
		// RIGHT MARGIN LINE
		g.drawLine(getZoomedDim(report.getPagesize().x- report.rightMargin)+10-HScrollBar1.getValue(),
				   10-VScrollBar1.getValue(),
				   getZoomedDim(report.getPagesize().x-report.rightMargin)+10-HScrollBar1.getValue(),
				   getZoomedDim(report.getDesignHeight())+10-VScrollBar1.getValue());  
		
		g.drawLine( 10-HScrollBar1.getValue(),
					getZoomedDim(report.topMargin)+10-VScrollBar1.getValue(),
					getZoomedDim(report.getPagesize().x)+10-HScrollBar1.getValue(),
					getZoomedDim(report.topMargin)+10-VScrollBar1.getValue()); 
		
		g.drawLine( 10-HScrollBar1.getValue(),
					getZoomedDim(report.getDesignHeight()-report.bottomMargin)+10-VScrollBar1.getValue(),
					getZoomedDim(report.getPagesize().x)+10-HScrollBar1.getValue(),
					getZoomedDim(report.getDesignHeight()- report.bottomMargin)+10-VScrollBar1.getValue());
		
		Enumeration enum = report.bands.elements();
		int y=report.topMargin;
		g.setPen(new Pen(new Color(170,170,170)));
		Band page_header=null;
		Band page_footer=null;
		while (enum.hasMoreElements())
		{
			Band band = (Band)enum.nextElement();
			y += band.height;
			g.drawLine( 10-HScrollBar1.getValue(),getZoomedDim(y)+10-VScrollBar1.getValue(), getZoomedDim(report.getPagesize().x)+10-HScrollBar1.getValue(), getZoomedDim(y)+10-VScrollBar1.getValue());
			g.setOpaque(false);
			g.setTextColor(new Color(220,220,255));
			g.setFont( new Font("Arial",getZoomedDim(20)));
			g.drawString( band.name, getZoomedDim(report.leftMargin)+10-HScrollBar1.getValue(), getZoomedDim(y-band.height)+10-VScrollBar1.getValue(), getZoomedDim(report.getPagesize().x), getZoomedDim(band.height),TextFormat.HORIZONTALCENTER);
			if (band.name.equals("pageHeader")) page_header = band;
			if (band.name.equals("pageFooter")) page_footer = band;
		}
		
		// PAint columns...
		int y1 = report.getBandYLocation(page_header);
		int y2 = report.getBandYLocation(page_footer);
			
		for (int i=0; i< report.columnCount-1; ++i)
		{
			int x = 10+getZoomedDim(report.leftMargin+report.columnWidth + i*(report.columnWidth+report.columnSpacing));  
			if (i !=0 ) {
			}
			if (x<10+getZoomedDim(report.getPagesize().x))
			g.drawLine( x-HScrollBar1.getValue(),getZoomedDim(y1)+10-VScrollBar1.getValue(),
						x-HScrollBar1.getValue(), getZoomedDim(y2)+10-VScrollBar1.getValue());
			x = 10+getZoomedDim(report.leftMargin+ report.columnWidth+report.columnSpacing + i *(report.columnWidth+report.columnSpacing)); 
			if (x<10+getZoomedDim(report.getPagesize().x))
			g.drawLine( x-HScrollBar1.getValue(),getZoomedDim(y1)+10-VScrollBar1.getValue(),
						x-HScrollBar1.getValue(), getZoomedDim(y2)+10-VScrollBar1.getValue());
		}
		/*
		g.setPen(new Pen(new Color(170,170,255)));
		g.drawLine( 10,getZoomedDim(report.topMargin)+10, getZoomedDim(report.getPagesize().x)+10, getZoomedDim(report.topMargin)+10); 
		g.drawLine( 10,getZoomedDim(report.getDesignHeight())- getZoomedDim(report.topMargin)+10,  getZoomedDim(report.getPagesize().x)+10,getZoomedDim(report.getDesignHeight())- getZoomedDim(report.topMargin)+10);
		*/
		g.setPen(new Pen(Color.BLACK ));
		
	}

	public int getZoomedDim(int dim)
	{
		if (zoom_factor == 1.0) return dim;
		//if (((double)dim*(double)zoom_factor)<0.5) return 1;
		// Truncate, don't round!!
		return (int)((double)dim*zoom_factor);
		//return (int)Math.ceil((double)dim*zoom_factor);
	}
	
	public int getLogicalDim(int dim)
	{
		if (zoom_factor == 1.0) return dim;
		//if (Math.abs(  ((double)dim/(double)zoom_factor)) < 1 &&
		//	Math.abs(  ((double)dim/(double)zoom_factor)) > 0) return 1;
		// Truncate, don't round!!
		return (int)((double)dim/zoom_factor);
		//return (int)Math.ceil((double)dim/zoom_factor);
	}
	
	private void panel9_keyUp(Object source, KeyEvent e)
	{
		if (e.getKeyCode() == Key.SHIFT_KEY) 
		{
			label1.setText("shift up");
			shift = false;
			if (lens_mode)
			{
				panel9.setCursor( cursorplus  );
			}
		}
		else if (e.getKeyCode() == Key.ESCAPE)
		{
			if (new_element)
			{
				new_element=false;
				if (!first_draw2) panel9.createGraphics().drawLines(new Point[]{new Point(ne.x, ne.y),new Point(mouse.x, ne.y),new Point(mouse.x, mouse.y),new Point(ne.x, mouse.y),new Point(ne.x, ne.y)},RasterOp.SOURCE.xorWith(RasterOp.TARGET)); 
				first_draw2 = true;
				panel9.setCursor(Cursor.DEFAULT);
				ne = null;		
			}
		}
		else if (e.getKeyCode() == Key.DELETE   )
		{
			boolean makerefreshAll = false;
			if (selectedElements.size() > 3)  makerefreshAll=true;
			while (selectedElements.size() > 0)
			{
				ReportElement re = (ReportElement)selectedElements.elementAt(0);
				selectedElements.removeElementAt(0);
				report.getElements().removeElement(re);
				
				if (!makerefreshAll)
				{
					Rectangle rect = new Rectangle(re.position.x-5,re.position.y-5,re.width+10, re.height+10);
					redrawAll(offscreenbm.getGraphics() ,rect,5);
					Rectangle clipRect = new Rectangle(getZoomedDim(re.position.x-10)-5+10-HScrollBar1.getValue(),
											   getZoomedDim(re.position.y-10)-5+10-VScrollBar1.getValue(),
											   getZoomedDim(re.width)+10,
											   getZoomedDim(re.height)+10);
					panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false);
				}
			}
			if (makerefreshAll) refreshAll();
			
			this.setSelectedElement(null);
		}
		//else MessageBox.show(e.getKeyCode()+"");
	}
	
	public void cancelNewObject()
	{
			if (new_element)
			{
				new_element=false;
				if (!first_draw2) panel9.createGraphics().drawLines(new Point[]{new Point(ne.x, ne.y),new Point(mouse.x, ne.y),new Point(mouse.x, mouse.y),new Point(ne.x, mouse.y),new Point(ne.x, ne.y)},RasterOp.SOURCE.xorWith(RasterOp.TARGET)); 
				first_draw2 = true;
				panel9.setCursor(Cursor.DEFAULT);
				ne = null;		
			}
	}
	/**
	 *	Redraw all objects visible in the specified rectangle
	 * clipRect (=Logical rect)
	 */
	private void redrawAll(Graphics g, Rectangle clipRect, int margin)
	{
				if (clipRect ==null)
					clipRect = new Rectangle(0,0,this.getReport().getPagesize().x,this.getReport().getDesignHeight()); 
				
				Rectangle realRect = new Rectangle( getZoomedDim(clipRect.x-10 - margin)+ margin +10 - HScrollBar1.getValue(),
													getZoomedDim(clipRect.y-10 - margin)+ margin +10 - VScrollBar1.getValue(),
													getZoomedDim(clipRect.width-2*margin)+2*margin,
													getZoomedDim(clipRect.height-2*margin)+2*margin);
				
				g.clearRect(0,0,offscreenbm.getSize().x,offscreenbm.getSize().y);
				//g.clearRect(realRect);
				// 1. Draw the void document...
				drawVoidDoc(g);
				
				// 2. Draw all Reportelements...
				Enumeration enum = report.getElements().elements();
				while (enum.hasMoreElements())
				{
					ReportElement re = (ReportElement)enum.nextElement();
					if (re.intersects(clipRect))
						re.drawObject(g, zoom_factor, HScrollBar1.getValue(), VScrollBar1.getValue());
				}
		
				// If there's a selected element, draw a corona 
				if (selectedElements.size()>0)
				{
					//clipRect.x -=5;
					//clipRect.y -=5;
					//clipRect.width  +=10;
					//clipRect.height +=10;
					enum = selectedElements.elements();
					boolean master=true;
					while (enum.hasMoreElements())
					{
						ReportElement re = (ReportElement)enum.nextElement();
						if (re.intersects(clipRect))
							re.drawCorona(g,zoom_factor, HScrollBar1.getValue(), VScrollBar1.getValue(), master);
						master = false;
					}
				}
	}




	private void panel9_keyDown(Object source, KeyEvent e)
	{
		if (e.getKeyCode() == Key.SHIFT_KEY) 
		{
			label1.setText("shift down");
			shift = true;
			if (lens_mode)
			{
				panel9.setCursor( cursorminus );
			}
		}
	}

	private void panel9_doubleClick(Object source, Event e)
	{
		// If we are over a element, open element properties...
		//if (trasforming)
		if (lens_mode)
		{
			//lens_mode = false;
			return;
		}	
		if (selectedElements.size() > 0)
		{
			// We are trasformation mode?
			if (transformation_type >=0)
			{
				MainForm mf = (MainForm)this.getMDIParent();
				if (mf != null)
				{
					mf.initReportForm();
					mf.ep.setEelement(this,(ReportElement)selectedElements.firstElement());
					mf.ep.show();
					
				}
				trasforming = false;
				transformation_type = TransformationType.TRANSFORMATION_NONE;
				panel9.setCursor(Cursor.DEFAULT);
			}
			
		}
	}
	
	public void refreshAll()
	{
		Rectangle rect = new Rectangle(0,0,report.getPagesize().x+20, report.getPagesize().y+20);
		redrawAll(offscreenbm.getGraphics() ,null,0);
		Rectangle clipRect = panel9.getDisplayRect();
		panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false); 	
	}
	
	public void setZoomFactor(double zoom)
	{
		double old_zoom = this.zoom_factor;
		this.zoom_factor = zoom;
		
		this.label1.setText(""+zoom);
		// Adjust scrollsbar...
		
		int h_value= HScrollBar1.getValue();
		HScrollBar1.setValue(0);
		if (getZoomedDim(report.getPagesize().x)+19 <= panel9.getSize().x)
		{
			HScrollBar1.setValue(0);
			HScrollBar1.setMaximum(panel9.getSize().x);
			HScrollBar1.setLargeChange( panel9.getSize().x);
		}
		else
		{
			HScrollBar1.setMaximum( getZoomedDim(report.getPagesize().x)+19);
			HScrollBar1.setLargeChange(Math.min(panel9.getSize().x,getZoomedDim(report.getPagesize().x)));
			HScrollBar1.setValue(Math.min(getZoomedDim(h_value), HScrollBar1.getMaximum()-HScrollBar1.getLargeChange() ));
		}		
		
		int v_value= VScrollBar1.getValue();
		VScrollBar1.setValue(0);
		if (getZoomedDim(report.getDesignHeight())+19 <= panel9.getSize().y)
		{
			VScrollBar1.setMaximum(report.getDesignHeight());
			VScrollBar1.setLargeChange( panel9.getSize().y);
		}
		else
		{
			VScrollBar1.setMaximum( getZoomedDim(report.getDesignHeight())+19);
			VScrollBar1.setLargeChange(Math.min(panel9.getSize().y,getZoomedDim(report.getDesignHeight())));
			VScrollBar1.setValue(Math.min(getZoomedDim(v_value), VScrollBar1.getMaximum()-VScrollBar1.getLargeChange() ));
		}		
		
		first_draw = false;
		panel7_paint(panel7, new PaintEvent(panel7.createGraphics(), panel7.getDisplayRect()));
		/*
		if (panel9.getSize().y > report.getPagesize().y+19)
			this.HScrollBar1.setLargeChange(panel9.getSize().y);
		else
			this.HScrollBar1.setLargeChange(report.getPagesize().y+19);
		
		int v_value= VScrollBar1.getValue();
		VScrollBar1.setValue(0);
		VScrollBar1.setMaximum( getZoomedDim(report.getPagesize().y)+19);
		VScrollBar1.setValue(getZoomedDim(v_value));
		*/
		
		
		Rectangle rect = new Rectangle(0,0,report.getPagesize().x, report.getDesignHeight());
		redrawAll(offscreenbm.getGraphics() , rect,0);
		//Rectangle clipRect = new Rectangle( rect );
		//if (this.zoom_factor < old_zoom)
		//panel9.createGraphics().fill( panel9.getDisplayRect(), new Brush(Color.CONTROL) );
		//clipRect.offset(-HScrollBar1.getValue(),-VScrollBar1.getValue());
		panel9.createGraphics().drawImage( offscreenbm,panel9.getDisplayRect(), panel9.getDisplayRect() ,false); 
	}
	
	public void setLensMode(boolean b)
	{
		if (lens_mode == true)
				panel9.setCursor( Cursor.DEFAULT );
		else
		{
			if (shift)
				panel9.setCursor(cursorminus );
			else
				panel9.setCursor(cursorplus);
		}
		lens_mode = b;
	}

	private void panel9_dragOver(Object source, DragEvent e)
	{
		if ((DragElementsData)e.data.getData(DragElementsData.class) != null)
            e.effect = DragDropEffect.COPY;
        else  // We don't want this thing dropped on us.
            e.effect = DragDropEffect.NONE;
	}

	private void panel9_dragDrop(Object source, DragEvent e)
	{
		 DragElementsData  dData=(DragElementsData)e.data.getData(DragElementsData.class);
        
        // Insert field aligned...
        if (dData != null) { 
			if (dData.elements.size()>0)
				setSelectedElement(null);
		
			Enumeration enum_bands = report.bands.elements();
			Band bname = null;
			int x = getLogicalDim( panel9.pointToClient(panel9.getMousePosition()) .x -10+HScrollBar1.getValue())+10;
			int y = getLogicalDim( panel9.pointToClient(panel9.getMousePosition()).y -10+VScrollBar1.getValue())+10;
			while (enum_bands.hasMoreElements())
			{
				Band b = (Band)enum_bands.nextElement();
				if (report.getBandYLocation(b) <= y)
				{
					bname = b;
				}
			}
			Enumeration enum = dData.elements.elements();
			while (enum.hasMoreElements())
			{
				Object obj = enum.nextElement();
				TextFieldReportElement re = new TextFieldReportElement(x,y,80,11,new Brush(imageList2.getBitmap(0)));
				re.band = bname;
				if (obj instanceof JRVariable)
				{
					JRVariable jv = (JRVariable)obj;
					re.text = "$V{"+jv.name+"}";
					re.fieldClass = jv.classType; 	
				}
				else if (obj instanceof JRParameter)
				{
					JRParameter jp = (JRParameter)obj;
					re.text = "$P{"+jp.name+"}";
					re.fieldClass = jp.classType; 				
				}
				else if (obj instanceof JRField)
				{
					JRField jf = (JRField)obj;
					re.text = "$F{"+jf.name+"}";
					//re.fieldClass = jf.classType; 				
				}
				getReport().getElements().addElement(re);
				Rectangle rect = new Rectangle(re.position.x-5,re.position.y-5,re.width+10, re.height+10);
				redrawAll(offscreenbm.getGraphics() ,rect,5);
				Rectangle clipRect = new Rectangle(getZoomedDim(re.position.x-10)-5+10-HScrollBar1.getValue(),
									   getZoomedDim(re.position.y-10)-5+10-VScrollBar1.getValue(),
									   getZoomedDim(re.width)+10,
									   getZoomedDim(re.height)+10);
				panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false);
				if (selectedElements.size() == 0) 
					this.setSelectedElement(re);
				else
					addSelectedElement(re);
				x += 80;
			}
        }
	}
	
	public void makeOperation(int op)
	{
		if (selectedElements.size() == 0) return;
		Enumeration enum = selectedElements.elements();
		ReportElement re = null;
		switch (op)
		{
			case OperationType.ALIGN_LEFT:
				int left= ((ReportElement)selectedElements.firstElement()).position.x;
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					re.setPosition(new Point(left, re.position.y));
				}
				break;
			case OperationType.ALIGN_RIGHT:
				int right= ((ReportElement)selectedElements.firstElement()).position.x+((ReportElement)selectedElements.firstElement()).width;
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					re.setPosition(new Point(right-re.width, re.position.y));
				}
				break;
			case OperationType.ALIGN_TOP:
				int top= ((ReportElement)selectedElements.firstElement()).position.y;
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					re.setPosition(new Point(re.position.x, top));
				}
				break;
			case OperationType.ALIGN_BOTTOM:
				int bottom= ((ReportElement)selectedElements.firstElement()).position.y+((ReportElement)selectedElements.firstElement()).height;
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					re.setPosition(new Point(re.position.x, bottom-re.height));
				}
				break;
			case OperationType.ALIGN_HORIZONTAL_AXIS:
				re = (ReportElement)selectedElements.firstElement();
				int center = re.position.x + (re.width/2);
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					re.setPosition(new Point(center-(re.width/2), re.position.y));
				}
				break;
			case OperationType.ALIGN_VERTICAL_AXIS:
				re = (ReportElement)selectedElements.firstElement();
				center = re.position.y + (re.height/2);
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					re.setPosition(new Point(re.position.y, center-(re.height/2)));
				}
				break;
			case OperationType.ALIGN_CENTER_HORIZONTALLY:
				re = (ReportElement)selectedElements.firstElement();
				center = 10+this.report.getPagesize().x/2;
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					re.setPosition(new Point(center-(re.width/2), re.position.y));
				}
				break;
			case OperationType.ALIGN_CENTER_VERTICALLY:
				re = (ReportElement)selectedElements.firstElement();
				center = this.report.getBandYLocation(re.band)+10+re.band.height/2;
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					re.setPosition(new Point(re.position.x, center-(re.height/2)));
				}
				break;
			case OperationType.ALIGN_CENTER:
				re = (ReportElement)selectedElements.firstElement();
				int centerx = 10+this.report.getPagesize().x/2;
				int centery = this.report.getBandYLocation(re.band)+10+re.band.height/2;
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					re.setPosition(new Point(centerx-(re.width/2), this.report.getBandYLocation(re.band)+10+re.band.height/2-(re.height/2)));
				}
				break;
			case OperationType.SAME_WIDTH:
				re = (ReportElement)selectedElements.firstElement();
				int width = re.width;
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					re.trasform(new Point(width-re.width,0), TransformationType.TRANSFORMATION_RESIZE_SE); 
				}
				break;
			case OperationType.SAME_HEIGHT:
				re = (ReportElement)selectedElements.firstElement();
				int height = re.height;
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					re.trasform(new Point(0,height-re.height), TransformationType.TRANSFORMATION_RESIZE_SE); 
				}
				break;
			case OperationType.SAME_SIZE:
				re = (ReportElement)selectedElements.firstElement();
				height = re.height;
				width = re.width;
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					re.trasform(new Point(width-re.width,height-re.height), TransformationType.TRANSFORMATION_RESIZE_SE); 
				}
				break;
			case OperationType.ALIGN_TOP_TO_BAND:
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					re.trasform(new Point(0,getReport().getBandYLocation( re.band)+10- re.position.y), TransformationType.TRANSFORMATION_MOVE); 
				}
				break;
			case OperationType.BRING_TO_FRON:
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					if (getReport().getElements().removeElement(re))
						getReport().getElements().addElement( re); 
				}
				break;
			case OperationType.SEND__TO_BACK:
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					if (getReport().getElements().removeElement(re))
						getReport().getElements().insertElementAt( re,0); 
				}
				break;
			case OperationType.HSPACE_MAKE_EQUAL:
			{
				re = (ReportElement)selectedElements.firstElement();
				int min = re.position.x;
				int max = re.position.x+re.width;
				int available = 0;
				int sumspaces = 0;
				int elements = 0;
				// 1. Search for more left. Calc all size, calc available space
				Vector v = new Vector();
				ReportElement minE =re;
				ReportElement maxE =re;
				//MessageBox.show(selectedElements.size()+"");
				enum = selectedElements.elements();
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					v.addElement(re);
					elements++;
					sumspaces += re.width;
					if (re.position.x < min){
						min = re.position.x;
						minE = re;
					}
					if (re.position.x+re.width > max){
						max = re.position.x+re.width;
						maxE = re;
					}
				}
				
				// Calc space between
				int between = ((max-min)-sumspaces)/(elements-1);
				
				Vector orded_vector = new Vector();
				// for any element,adjust position...
				//MessageBox.show(""+min+" "+max+" btw:" + between+" "+v.size());
				while (v.size() > 0)
				{
					int x = max;
					ReportElement current_minus = (ReportElement)v.elementAt(0);
					for (int i=1; i<v.size(); ++i)
					{
						if ( ((ReportElement)v.elementAt(i)).position.x < current_minus.position.x)
							current_minus = (ReportElement)v.elementAt(i);
					}
					orded_vector.addElement(current_minus);
					v.removeElement(current_minus);
				}
				
				//MessageBox.show(""+min+" "+max+" btw:" + between+" "+v.size()+" "+orded_vector.size());
				Enumeration venum = orded_vector.elements();
				int current_x = minE.position.x+minE.width+between ;
				while (venum.hasMoreElements())
				{
					re = (ReportElement)venum.nextElement();
					if (re == minE || re == maxE) continue;
					re.setPosition(new Point(current_x, re.position.y));
					current_x = re.position.x+re.width+between;
				}
			}
			break;
			case OperationType.HSPACE_INCREASE:
			{
				re = (ReportElement)selectedElements.firstElement();
				int min = re.position.x;
				int max = re.position.x+re.width;
				int available = 0;
				int sumspaces = 0;
				int elements = 0;
				// 1. Search for more left. Calc all size, calc available space
				Vector v = new Vector();
				ReportElement minE =re;
				//MessageBox.show(selectedElements.size()+"");
				enum = selectedElements.elements();
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					v.addElement(re);
					if (re.position.x < min){
						min = re.position.x;
						minE = re;
					}
				}
				Vector orded_vector = new Vector();
				while (v.size() > 0)
				{
					int x = max;
					ReportElement current_minus = (ReportElement)v.elementAt(0);
					for (int i=1; i<v.size(); ++i)
					{
						if ( ((ReportElement)v.elementAt(i)).position.x < current_minus.position.x)
							current_minus = (ReportElement)v.elementAt(i);
					}
					orded_vector.addElement(current_minus);
					v.removeElement(current_minus);
				}
				Enumeration venum = orded_vector.elements();
				int current_x = minE.position.x+minE.width ;
				int addx = 0;
				while (venum.hasMoreElements())
				{
					re = (ReportElement)venum.nextElement();
					if (re == minE) 
					{
						continue;
					}
					addx += 2;
					re.setPosition(new Point(re.position.x+addx, re.position.y));
				}
			}
			break;
			case OperationType.HSPACE_DECREASE:
			{
				re = (ReportElement)selectedElements.firstElement();
				int min = re.position.x;
				int max = re.position.x+re.width;
				int available = 0;
				int sumspaces = 0;
				int elements = 0;
				// 1. Search for more left. Calc all size, calc available space
				Vector v = new Vector();
				ReportElement minE =re;
				//MessageBox.show(selectedElements.size()+"");
				enum = selectedElements.elements();
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					v.addElement(re);
					if (re.position.x < min){
						min = re.position.x;
						minE = re;
					}
				}
				Vector orded_vector = new Vector();
				while (v.size() > 0)
				{
					int x = max;
					ReportElement current_minus = (ReportElement)v.elementAt(0);
					for (int i=1; i<v.size(); ++i)
					{
						if ( ((ReportElement)v.elementAt(i)).position.x < current_minus.position.x)
							current_minus = (ReportElement)v.elementAt(i);
					}
					orded_vector.addElement(current_minus);
					v.removeElement(current_minus);
				}
				Enumeration venum = orded_vector.elements();
				int current_x = minE.position.x+minE.width ;
				int addx = 0;
				int minx = 0;
				while (venum.hasMoreElements())
				{
					re = (ReportElement)venum.nextElement();
					if (re == minE) 
					{
						minx = re.position.x+re.width;
						continue;
					}
					addx -= 2;
					re.setPosition(new Point(re.position.x+addx, re.position.y));
				}
			}
			break;
			case OperationType.HSPACE_REMOVE:
			{
				re = (ReportElement)selectedElements.firstElement();
				int min = re.position.x;
				int max = re.position.x+re.width;
				int available = 0;
				int sumspaces = 0;
				int elements = 0;
				// 1. Search for more left. Calc all size, calc available space
				Vector v = new Vector();
				ReportElement minE =re;
				//MessageBox.show(selectedElements.size()+"");
				enum = selectedElements.elements();
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					v.addElement(re);
					if (re.position.x < min){
						min = re.position.x;
						minE = re;
					}
				}
				Vector orded_vector = new Vector();
				while (v.size() > 0)
				{
					int x = max;
					ReportElement current_minus = (ReportElement)v.elementAt(0);
					for (int i=1; i<v.size(); ++i)
					{
						if ( ((ReportElement)v.elementAt(i)).position.x < current_minus.position.x)
							current_minus = (ReportElement)v.elementAt(i);
					}
					orded_vector.addElement(current_minus);
					v.removeElement(current_minus);
				}
				Enumeration venum = orded_vector.elements();
				int current_x = minE.position.x+minE.width ;
				int pos = 0;
				while (venum.hasMoreElements())
				{
					re = (ReportElement)venum.nextElement();
					if (re == minE) 
					{
						pos = re.position.x+re.width;
						continue;
					}
					re.setPosition(new Point(pos, re.position.y));
					pos = re.position.x+re.width;
				}
			}
			break;
			
			case OperationType.VSPACE_MAKE_EQUAL:
			{
				re = (ReportElement)selectedElements.firstElement();
				int min = re.position.y;
				int max = re.position.y+re.height;
				int available = 0;
				int sumspaces = 0;
				int elements = 0;
				// 1. Search for more left. Calc all size, calc available space
				Vector v = new Vector();
				ReportElement minE =re;
				ReportElement maxE =re;
				//MessageBox.show(selectedElements.size()+"");
				enum = selectedElements.elements();
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					v.addElement(re);
					elements++;
					sumspaces += re.height;
					if (re.position.y < min){
						min = re.position.y;
						minE = re;
					}
					if (re.position.y+re.height > max){
						max = re.position.y+re.height;
						maxE = re;
					}
				}
				
				// Calc space between
				int between = ((max-min)-sumspaces)/(elements-1);
				
				Vector orded_vector = new Vector();
				// for any element,adjust position...
				//MessageBox.show(""+min+" "+max+" btw:" + between+" "+v.size());
				while (v.size() > 0)
				{
					int x = max;
					ReportElement current_minus = (ReportElement)v.elementAt(0);
					for (int i=1; i<v.size(); ++i)
					{
						if ( ((ReportElement)v.elementAt(i)).position.y < current_minus.position.y)
							current_minus = (ReportElement)v.elementAt(i);
					}
					orded_vector.addElement(current_minus);
					v.removeElement(current_minus);
				}
				
				//MessageBox.show(""+min+" "+max+" btw:" + between+" "+v.size()+" "+orded_vector.size());
				Enumeration venum = orded_vector.elements();
				int current_x = minE.position.y+minE.height+between ;
				while (venum.hasMoreElements())
				{
					re = (ReportElement)venum.nextElement();
					if (re == minE || re == maxE) continue;
					re.setPosition(new Point(re.position.x,current_x));
					current_x = re.position.y+re.height+between;
				}
			}
			break;
			
			
			
			case OperationType.VSPACE_INCREASE:
			{
				re = (ReportElement)selectedElements.firstElement();
				int min = re.position.y;
				int max = re.position.y+re.height;
				int available = 0;
				int sumspaces = 0;
				int elements = 0;
				// 1. Search for more left. Calc all size, calc available space
				Vector v = new Vector();
				ReportElement minE =re;
				//MessageBox.show(selectedElements.size()+"");
				enum = selectedElements.elements();
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					v.addElement(re);
					if (re.position.y < min){
						min = re.position.y;
						minE = re;
					}
				}
				Vector orded_vector = new Vector();
				while (v.size() > 0)
				{
					int x = max;
					ReportElement current_minus = (ReportElement)v.elementAt(0);
					for (int i=1; i<v.size(); ++i)
					{
						if ( ((ReportElement)v.elementAt(i)).position.y < current_minus.position.y)
							current_minus = (ReportElement)v.elementAt(i);
					}
					orded_vector.addElement(current_minus);
					v.removeElement(current_minus);
				}
				Enumeration venum = orded_vector.elements();
				int current_x = minE.position.y+minE.height ;
				int addx = 0;
				while (venum.hasMoreElements())
				{
					re = (ReportElement)venum.nextElement();
					if (re == minE) 
					{
						continue;
					}
					addx += 2;
					re.setPosition(new Point(re.position.x, re.position.y+addx));
				}
			}
			break;
			case OperationType.VSPACE_DECREASE:
			{
				re = (ReportElement)selectedElements.firstElement();
				int min = re.position.y;
				int max = re.position.y+re.height;
				int available = 0;
				int sumspaces = 0;
				int elements = 0;
				// 1. Search for more left. Calc all size, calc available space
				Vector v = new Vector();
				ReportElement minE =re;
				//MessageBox.show(selectedElements.size()+"");
				enum = selectedElements.elements();
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					v.addElement(re);
					if (re.position.y < min){
						min = re.position.y;
						minE = re;
					}
				}
				Vector orded_vector = new Vector();
				while (v.size() > 0)
				{
					int x = max;
					ReportElement current_minus = (ReportElement)v.elementAt(0);
					for (int i=1; i<v.size(); ++i)
					{
						if ( ((ReportElement)v.elementAt(i)).position.y < current_minus.position.y)
							current_minus = (ReportElement)v.elementAt(i);
					}
					orded_vector.addElement(current_minus);
					v.removeElement(current_minus);
				}
				Enumeration venum = orded_vector.elements();
				int current_x = minE.position.y+minE.height ;
				int addx = 0;
				int minx = 0;
				while (venum.hasMoreElements())
				{
					re = (ReportElement)venum.nextElement();
					if (re == minE) 
					{
						minx = re.position.y+re.height;
						continue;
					}
					addx -= 2;
					re.setPosition(new Point(re.position.x, re.position.y+addx));
				}
			}
			break;
			case OperationType.VSPACE_REMOVE:
			{
				re = (ReportElement)selectedElements.firstElement();
				int min = re.position.y;
				int max = re.position.y+re.height;
				int available = 0;
				int sumspaces = 0;
				int elements = 0;
				// 1. Search for more left. Calc all size, calc available space
				Vector v = new Vector();
				ReportElement minE =re;
				//MessageBox.show(selectedElements.size()+"");
				enum = selectedElements.elements();
				while (enum.hasMoreElements()){
					re = (ReportElement)enum.nextElement();
					v.addElement(re);
					if (re.position.y < min){
						min = re.position.y;
						minE = re;
					}
				}
				Vector orded_vector = new Vector();
				while (v.size() > 0)
				{
					int x = max;
					ReportElement current_minus = (ReportElement)v.elementAt(0);
					for (int i=1; i<v.size(); ++i)
					{
						if ( ((ReportElement)v.elementAt(i)).position.y < current_minus.position.y)
							current_minus = (ReportElement)v.elementAt(i);
					}
					orded_vector.addElement(current_minus);
					v.removeElement(current_minus);
				}
				Enumeration venum = orded_vector.elements();
				int current_x = minE.position.y+minE.height ;
				int pos = 0;
				while (venum.hasMoreElements())
				{
					re = (ReportElement)venum.nextElement();
					if (re == minE) 
					{
						pos = re.position.y+re.height;
						continue;
					}
					re.setPosition(new Point( re.position.x,pos));
					pos = re.position.y+re.height;
				}
			}
			break;
			
			
		}	
		this.refreshAll();
	}
	
	public void addUndoOperation(UndoOperation uo)
	{
		while (undoOperations.size() > undoIndex )
		{
			undoOperations.removeElementAt(undoIndex);
		}					  
		undoOperations.addElement(uo);
		undoIndex++;
		
		((MainForm)this.getMDIParent()).updateUndoMenuState(this);
	}
	
	public void undo()
	{
		if (undoIndex>0)
		{
			UndoOperation uo = (UndoOperation)undoOperations.elementAt(undoIndex-1);
			switch (uo.type)
			{
				case UndoOperationType.UNDO_INSERT:	
					undoIndex--;
					setSelectedElement(null);
					for (int i= ((Integer)uo.params.elementAt(0)).intValue(); i>0; --i)
					{
						// Remove element with the same name...
						// For performance, strart search from end of vector...
						for (int k=report.getElements().size()-1; k>=0; --k)
						{	
							ReportElement re = (ReportElement)report.getElements().elementAt(k);
							if (re.name.equals(((ReportElement)uo.params.elementAt(i)).name))
							{
								report.getElements().removeElement(re);
								updateElement(re,null);
								break;
							}
						}
					}
					break;
				case UndoOperationType.UNDO_TRANSFORMATION:	
					undoIndex--;
					Point delta = (Point)uo.params.elementAt(0);
					Point p = new Point( -delta.x, -delta.y);
					int transf_type = ((Integer)uo.params.elementAt(1)).intValue();
					for (int i= uo.params.size()-1; i>1; --i)
					{
						ReportElement selectedRe = (ReportElement)uo.params.elementAt(i);
						selectedRe.trasform(p, transf_type);
						
						Rectangle rect = new Rectangle(Math.min( selectedRe.position.x-5 ,selectedRe.position.x-p.x-5),
											   Math.min(selectedRe.position.y-5,selectedRe.position.y-p.y-5),
											   selectedRe.width + Math.abs(p.x)+10,selectedRe.height + Math.abs(p.y)+10);
						redrawAll(offscreenbm.getGraphics() , rect,5);
						// Get Real dimensions...
						Rectangle clipRect = new Rectangle(getZoomedDim(rect.x-10+5)-5+10,
													   getZoomedDim(rect.y-10+5)-5+10,
													   getZoomedDim(rect.width-10)+10,
													   getZoomedDim(rect.height-10)+10);
					
						clipRect.offset(-HScrollBar1.getValue(),-VScrollBar1.getValue());
						panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false);
					}
					break;
			}
		}
		((MainForm)this.getMDIParent()).updateUndoMenuState(this);
	}
	
	public void redo()
	{
		if (undoIndex<undoOperations.size())
		{
			UndoOperation uo = (UndoOperation)undoOperations.elementAt(undoIndex);
			switch (uo.type)
			{
				case UndoOperationType.UNDO_INSERT:	
					undoIndex++;
					setSelectedElement(null);
					for (int i= ((Integer)uo.params.elementAt(0)).intValue(); i>0; --i)
					{
						report.getElements().addElement( ((ReportElement)uo.params.elementAt(i)).cloneMe());
						updateElement((ReportElement)uo.params.elementAt(i),null);
						addSelectedElement((ReportElement)uo.params.elementAt(i));
					}
					break;
				case UndoOperationType.UNDO_TRANSFORMATION:	
					undoIndex++;
					Point p = (Point)uo.params.elementAt(0);
					//Point p = new Point( -delta.x, -delta.y);
					int transf_type = ((Integer)uo.params.elementAt(1)).intValue();
					for (int i= uo.params.size()-1; i>1; --i)
					{
						ReportElement selectedRe = (ReportElement)uo.params.elementAt(i);
						selectedRe.trasform(p, transf_type);
						
						Rectangle rect = new Rectangle(Math.min( selectedRe.position.x-5 ,selectedRe.position.x-p.x-5),
											   Math.min(selectedRe.position.y-5,selectedRe.position.y-p.y-5),
											   selectedRe.width + Math.abs(p.x)+10,selectedRe.height + Math.abs(p.y)+10);
						redrawAll(offscreenbm.getGraphics() , rect,5);
						// Get Real dimensions...
						Rectangle clipRect = new Rectangle(getZoomedDim(rect.x-10+5)-5+10,
													   getZoomedDim(rect.y-10+5)-5+10,
													   getZoomedDim(rect.width-10)+10,
													   getZoomedDim(rect.height-10)+10);
					
						clipRect.offset(-HScrollBar1.getValue(),-VScrollBar1.getValue());
						panel9.createGraphics().drawImage( offscreenbm,clipRect, clipRect ,false);
					}
					break;
			}
		}
		((MainForm)this.getMDIParent()).updateUndoMenuState(this);
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */

	Container components = new Container();
	Panel panel1 = new Panel();
	Panel panel2 = new Panel();
	VScrollBar VScrollBar1 = new VScrollBar();
	HScrollBar HScrollBar1 = new HScrollBar();
	Panel panel3 = new Panel();
	Panel panel5 = new Panel();
	Panel panel6 = new Panel();
	Panel panel7 = new Panel();
	Panel panel4 = new Panel();
	Panel panel8 = new Panel();
	Panel panel9 = new Panel();
	Label label1 = new Label();
	ImageList imageList1 = new ImageList();
	ImageList imageList2 = new ImageList();
	ImageList imageList3 = new ImageList();
	ImageList imageList4 = new ImageList();

	private void initForm()
	{
		// NOTA: questo form contiene informazioni relative alle risorse in
		// un file esterno. Non modificare il parametro di tipo String delle
		// chiamate alla funzione resources.getObject(). Ad esempio, non
		// modificare"foo1_location" nella seguente riga di codice,
		// nemmeno se il nome dell'oggetto Foo viene modificato: 
		//	 foo1.setLocation((Point)resources.getObject("foo1_location"));

		IResourceManager resources = new ResourceManager(this, "ReportForm");
		this.setText("me");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setClientSize(new Point(461, 390));
		this.setWindowState(FormWindowState.MAXIMIZED);

		panel1.setDock(ControlDock.BOTTOM);
		panel1.setLocation(new Point(0, 374));
		panel1.setSize(new Point(461, 16));
		panel1.setTabIndex(0);
		panel1.setText("panel1");

		panel2.setDock(ControlDock.RIGHT);
		panel2.setLocation(new Point(445, 0));
		panel2.setSize(new Point(16, 16));
		panel2.setTabIndex(0);
		panel2.setText("panel2");
		panel2.addOnPaint(new PaintEventHandler(this.panel2_paint));

		VScrollBar1.setDock(ControlDock.RIGHT);
		VScrollBar1.setLocation(new Point(445, 0));
		VScrollBar1.setSize(new Point(16, 374));
		VScrollBar1.setTabIndex(1);
		VScrollBar1.setText("VScrollBar1");
		VScrollBar1.setLargeChange(0);
		VScrollBar1.setMaximum(1);
		VScrollBar1.addOnScroll(new ScrollEventHandler(this.VScrollBar1_scroll));

		HScrollBar1.setDock(ControlDock.FILL);
		HScrollBar1.setSize(new Point(445, 16));
		HScrollBar1.setTabIndex(1);
		HScrollBar1.setText("HScrollBar1");
		HScrollBar1.setLargeChange(1000);
		HScrollBar1.setMaximum(1000);
		HScrollBar1.setSmallChange(1000);
		HScrollBar1.setValue(1000);
		HScrollBar1.addOnScroll(new ScrollEventHandler(this.HScrollBar1_scroll));

		panel3.setDock(ControlDock.FILL);
		panel3.setSize(new Point(445, 374));
		panel3.setTabIndex(2);
		panel3.setText("panel3");

		panel5.setBackColor(Color.ACTIVECAPTIONTEXT);
		panel5.setDock(ControlDock.LEFT);
		panel5.setLocation(new Point(0, 16));
		panel5.setSize(new Point(16, 335));
		panel5.setTabIndex(0);
		panel5.setText("panel4");

		panel6.setDock(ControlDock.LEFT);
		panel6.setSize(new Point(16, 16));
		panel6.setTabIndex(0);
		panel6.setText("panel6");
		panel6.addOnPaint(new PaintEventHandler(this.panel6_paint));

		panel7.setBackColor(Color.ACTIVECAPTIONTEXT);
		panel7.setDock(ControlDock.FILL);
		panel7.setLocation(new Point(16, 0));
		panel7.setSize(new Point(429, 16));
		panel7.setTabIndex(1);
		panel7.setText("panel7");
		panel7.addOnPaint(new PaintEventHandler(this.panel7_paint));

		panel4.setBackColor(Color.ACTIVEBORDER);
		panel4.setDock(ControlDock.TOP);
		panel4.setSize(new Point(445, 16));
		panel4.setTabIndex(1);
		panel4.setText("panel4");

		panel8.setBackColor(Color.CONTROLDARK);
		panel8.setDock(ControlDock.FILL);
		panel8.setSize(new Point(445, 374));
		panel8.setTabIndex(0);
		panel8.setText("panel8");

		panel9.setAllowDrop(true);
		panel9.setDock(ControlDock.FILL);
		panel9.setLocation(new Point(16, 16));
		panel9.setSize(new Point(429, 335));
		panel9.setTabIndex(2);
		panel9.setTabStop(true);
		panel9.setText("panel9");
		panel9.addOnDoubleClick(new EventHandler(this.panel9_doubleClick));
		panel9.addOnKeyDown(new KeyEventHandler(this.panel9_keyDown));
		panel9.addOnKeyUp(new KeyEventHandler(this.panel9_keyUp));
		panel9.addOnMouseDown(new MouseEventHandler(this.panel9_mouseDown));
		panel9.addOnMouseMove(new MouseEventHandler(this.panel9_mouseMove));
		panel9.addOnMouseUp(new MouseEventHandler(this.panel9_mouseUp));
		panel9.addOnDragOver(new DragEventHandler(this.panel9_dragOver));
		panel9.addOnDragDrop(new DragEventHandler(this.panel9_dragDrop));
		panel9.addOnResize(new EventHandler(this.panel9_resize));
		panel9.addOnPaint(new PaintEventHandler(this.panel9_paint));

		label1.setBackColor(Color.ACTIVEBORDER);
		label1.setDock(ControlDock.BOTTOM);
		label1.setLocation(new Point(0, 351));
		label1.setSize(new Point(445, 23));
		label1.setTabIndex(3);
		label1.setTabStop(false);
		label1.setText("label1");
		label1.setBorderStyle(BorderStyle.FIXED_3D);

		imageList1.setImageSize(new Point(9, 9));
		imageList1.setColorDepth(ColorDepth.COLORDEPTH_MILLIONS_OF_COLORS);
		imageList1.setImageStream((ImageListStreamer)resources.getObject("imageList1_imageStream"));
		/* @designTimeOnly imageList1.setLocation(new Point(116, 156)); */

		imageList2.setImageSize(new Point(4, 4));
		imageList2.setMaskColor(Color.ACTIVECAPTIONTEXT);
		imageList2.setImageStream((ImageListStreamer)resources.getObject("imageList2_imageStream"));
		/* @designTimeOnly imageList2.setLocation(new Point(212, 204)); */

		imageList3.setImageSize(new Point(100, 80));
		imageList3.setColorDepth(ColorDepth.COLORDEPTH_64K_COLORS);
		imageList3.setImageStream((ImageListStreamer)resources.getObject("imageList3_imageStream"));
		/* @designTimeOnly imageList3.setLocation(new Point(104, 84)); */

		imageList4.setImageSize(new Point(32, 32));
		imageList4.setMaskColor(Color.ACTIVECAPTIONTEXT);
		imageList4.setColorDepth(ColorDepth.COLORDEPTH_64K_COLORS);
		imageList4.setImageStream((ImageListStreamer)resources.getObject("imageList4_imageStream"));
		/* @designTimeOnly imageList4.setLocation(new Point(240, 132)); */

		this.setNewControls(new Control[] {
							panel3, 
							VScrollBar1, 
							panel1});
		panel1.setNewControls(new Control[] {
							  HScrollBar1, 
							  panel2});
		panel3.setNewControls(new Control[] {
							  panel8});
		panel4.setNewControls(new Control[] {
							  panel7, 
							  panel6});
		panel8.setNewControls(new Control[] {
							  label1, 
							  panel9, 
							  panel5, 
							  panel4});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new ReportForm(null));
	}
}
