/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport;

import com.businesslogic.ireport.ui.*;
import com.businesslogic.ireport.util.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;

public class LineReportElement extends GraphicReportElement 
{

	public String direction;
	
	public LineReportElement(int x, int y, int width, int height, Brush hached)
	{
		this(x,y,width,height,hached,"TopDown");
	}
	
	public LineReportElement(int x, int y, int width, int height, Brush hached, String direction)
	{
		super(x,y,width,height,hached);
		graphicElementPen  = "Thin";
		this.bgcolor = Color.WHITE;
		this.fgcolor = Color.BLACK;
		this.direction = direction;
	}
	
	public void drawObject(Graphics g,double zoom_factor, int x_shift_origin, int y_shift_origin)
	{
		this.zoom_factor = zoom_factor;
		//g.fill( position.x,position.y,width,height,new Brush(bgcolor, BrushStyle.SOLID));
		Point a = new Point( getZoomedDim( position.x-10) +10-x_shift_origin, getZoomedDim( position.y-10) +10-y_shift_origin );
		Point b = new Point( getZoomedDim(position.x+width-10)+10-x_shift_origin,getZoomedDim( position.y+height-10)+10-y_shift_origin);
				
		if (!direction.equalsIgnoreCase("TopDown"))
		{
			b.y = getZoomedDim( position.y-10) +10-y_shift_origin;
			a.y = getZoomedDim( position.y+height-10)+10-y_shift_origin;
		}
		
		int width  = 0;
		//public Pen( Color color, int style, int width )
		int penp = 1;
		int style  = PenStyle.SOLID;
		if (graphicElementPen==null || graphicElementPen.equalsIgnoreCase("None")) return;
		else if (graphicElementPen.equalsIgnoreCase("Thin")) penp=(int)(Math.max(1,1.0*zoom_factor));
		else if (graphicElementPen.equalsIgnoreCase("1Point")) penp=(int)(Math.max(1,1.0*zoom_factor));
		else if (graphicElementPen.equalsIgnoreCase("2Point")) penp=(int)(Math.max(2,1.0*zoom_factor));
		else if (graphicElementPen.equalsIgnoreCase("4Point")) penp=(int)(Math.max(4,1.0*zoom_factor));
		else if (graphicElementPen.equalsIgnoreCase("Dotted"))
		{
			style = PenStyle.DASH;
		}
		
		Pen oldpen = g.getPen();
		g.setPen( new Pen(fgcolor,style,penp));
		g.drawLine(a,b);
		g.setPen(oldpen);
		//super.drawGraphicsElement(g,graphicElementPen);
	}
	
	public ReportElement cloneMe()
	{
		LineReportElement newReportElement = new LineReportElement(position.x, position.y, width, height, hached);
		newReportElement.name = new String(name);
		newReportElement.direction = direction;
		newReportElement.bgcolor = bgcolor;
		newReportElement.fgcolor = fgcolor;
		newReportElement.graphicElementPen = graphicElementPen;
		
		return newReportElement;
	}
}