/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class BarRecord
extends Record {
    public static final short sid = 4119;
    private short field_1_barSpace;
    private short field_2_categorySpace;
    private short field_3_formatFlags;
    private BitField horizontal = new BitField(1);
    private BitField stacked = new BitField(2);
    private BitField displayAsPercentage = new BitField(4);
    private BitField shadow = new BitField(8);

    public BarRecord() {
        this.field_2_categorySpace = (short)50;
    }

    public BarRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public BarRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 4119) {
            throw new RecordFormatException("Not a Bar record");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_barSpace = LittleEndian.getShort(data, 0 + offset);
        this.field_2_categorySpace = LittleEndian.getShort(data, 2 + offset);
        this.field_3_formatFlags = LittleEndian.getShort(data, 4 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[Bar]\n");
        buffer.append("    .barSpace             = ").append("0x").append(HexDump.toHex(this.getBarSpace())).append(" (").append(this.getBarSpace()).append(" )\n");
        buffer.append("    .categorySpace        = ").append("0x").append(HexDump.toHex(this.getCategorySpace())).append(" (").append(this.getCategorySpace()).append(" )\n");
        buffer.append("    .formatFlags          = ").append("0x").append(HexDump.toHex(this.getFormatFlags())).append(" (").append(this.getFormatFlags()).append(" )\n");
        buffer.append("         .horizontal               = ").append(this.isHorizontal()).append('\n');
        buffer.append("         .stacked                  = ").append(this.isStacked()).append('\n');
        buffer.append("         .displayAsPercentage      = ").append(this.isDisplayAsPercentage()).append('\n');
        buffer.append("         .shadow                   = ").append(this.isShadow()).append('\n');
        buffer.append("[/Bar]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)4119);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.field_1_barSpace);
        LittleEndian.putShort(data, 6 + offset, this.field_2_categorySpace);
        LittleEndian.putShort(data, 8 + offset, this.field_3_formatFlags);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 10;
    }

    public short getSid() {
        return 4119;
    }

    public short getBarSpace() {
        return this.field_1_barSpace;
    }

    public void setBarSpace(short field_1_barSpace) {
        this.field_1_barSpace = field_1_barSpace;
    }

    public short getCategorySpace() {
        return this.field_2_categorySpace;
    }

    public void setCategorySpace(short field_2_categorySpace) {
        this.field_2_categorySpace = field_2_categorySpace;
    }

    public short getFormatFlags() {
        return this.field_3_formatFlags;
    }

    public void setFormatFlags(short field_3_formatFlags) {
        this.field_3_formatFlags = field_3_formatFlags;
    }

    public void setHorizontal(boolean value) {
        this.field_3_formatFlags = this.horizontal.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isHorizontal() {
        return this.horizontal.isSet(this.field_3_formatFlags);
    }

    public void setStacked(boolean value) {
        this.field_3_formatFlags = this.stacked.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isStacked() {
        return this.stacked.isSet(this.field_3_formatFlags);
    }

    public void setDisplayAsPercentage(boolean value) {
        this.field_3_formatFlags = this.displayAsPercentage.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isDisplayAsPercentage() {
        return this.displayAsPercentage.isSet(this.field_3_formatFlags);
    }

    public void setShadow(boolean value) {
        this.field_3_formatFlags = this.shadow.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isShadow() {
        return this.shadow.isSet(this.field_3_formatFlags);
    }
}

