/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.poi.hssf.model.Sheet;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.usermodel.HSSFCell;

public class HSSFRow
implements Comparable {
    public static final int INITIAL_CAPACITY = 5;
    private short rowNum;
    private HashMap cells;
    private RowRecord row;
    private Workbook book;
    private Sheet sheet;

    protected HSSFRow() {
    }

    protected HSSFRow(Workbook book, Sheet sheet, short rowNum) {
        this.rowNum = rowNum;
        this.cells = new HashMap(10);
        this.book = book;
        this.sheet = sheet;
        this.row = new RowRecord();
        this.row.setHeight((short)255);
        this.row.setLastCol((short)-1);
        this.row.setFirstCol((short)-1);
        this.setRowNum(rowNum);
    }

    protected HSSFRow(Workbook book, Sheet sheet, RowRecord record) {
        this.rowNum = this.rowNum;
        this.cells = new HashMap();
        this.book = book;
        this.sheet = sheet;
        this.row = record;
        this.setRowNum(record.getRowNumber());
    }

    public HSSFCell createCell(short column) {
        HSSFCell cell = new HSSFCell(this.book, this.sheet, this.getRowNum(), column);
        this.addCell(cell);
        this.sheet.addValueRecord(this.getRowNum(), cell.getCellValueRecord());
        return cell;
    }

    public HSSFCell createCell(short column, int type) {
        HSSFCell cell = new HSSFCell(this.book, this.sheet, this.getRowNum(), column, type);
        this.addCell(cell);
        this.sheet.addValueRecord(this.getRowNum(), cell.getCellValueRecord());
        return cell;
    }

    public void removeCell(HSSFCell cell) {
        CellValueRecordInterface cval = cell.getCellValueRecord();
        this.sheet.removeValueRecord(this.getRowNum(), cval);
        this.cells.remove(new Integer(cell.getCellNum()));
        if (cell.getCellNum() == this.row.getLastCol()) {
            this.row.setLastCol(this.findLastCell(this.row.getLastCol()));
        }
        if (cell.getCellNum() == this.row.getFirstCol()) {
            this.row.setFirstCol(this.findFirstCell(this.row.getFirstCol()));
        }
    }

    protected HSSFCell createCellFromRecord(CellValueRecordInterface cell) {
        HSSFCell hcell = new HSSFCell(this.book, this.sheet, this.getRowNum(), cell);
        this.addCell(hcell);
        return hcell;
    }

    public void setRowNum(short rowNum) {
        this.rowNum = rowNum;
        if (this.row != null) {
            this.row.setRowNumber(rowNum);
        }
    }

    public short getRowNum() {
        return this.rowNum;
    }

    private void addCell(HSSFCell cell) {
        if (this.row.getFirstCol() == -1) {
            this.row.setFirstCol(cell.getCellNum());
        }
        if (this.row.getLastCol() == -1) {
            this.row.setLastCol(cell.getCellNum());
        }
        this.cells.put(new Integer(cell.getCellNum()), cell);
        if (cell.getCellNum() < this.row.getFirstCol()) {
            this.row.setFirstCol(cell.getCellNum());
        }
        if (cell.getCellNum() > this.row.getLastCol()) {
            this.row.setLastCol(cell.getCellNum());
        }
    }

    public HSSFCell getCell(short cellnum) {
        return (HSSFCell)this.cells.get(new Integer(cellnum));
    }

    public short getFirstCellNum() {
        if (this.getPhysicalNumberOfCells() == 0) {
            return -1;
        }
        return this.row.getFirstCol();
    }

    public short getLastCellNum() {
        if (this.getPhysicalNumberOfCells() == 0) {
            return -1;
        }
        return this.row.getLastCol();
    }

    public int getPhysicalNumberOfCells() {
        if (this.cells == null) {
            return 0;
        }
        return this.cells.size();
    }

    public void setHeight(short height) {
        this.row.setBadFontHeight(true);
        this.row.setHeight(height);
    }

    public void setHeightInPoints(float height) {
        this.row.setBadFontHeight(true);
        this.row.setHeight((short)(height * 20.0f));
    }

    public short getHeight() {
        return this.row.getHeight();
    }

    public float getHeightInPoints() {
        return this.row.getHeight() / 20;
    }

    protected RowRecord getRowRecord() {
        return this.row;
    }

    private short findLastCell(short lastcell) {
        short cellnum = (short)(lastcell - 1);
        HSSFCell r = this.getCell(cellnum);
        while (r == null && cellnum >= 0) {
            cellnum = (short)(cellnum - 1);
            r = this.getCell(cellnum);
        }
        return cellnum;
    }

    private short findFirstCell(short firstcell) {
        short cellnum = (short)(firstcell + 1);
        HSSFCell r = this.getCell(cellnum);
        while (r == null && cellnum <= this.getLastCellNum()) {
            cellnum = (short)(cellnum + 1);
            r = this.getCell(cellnum);
        }
        if (cellnum > this.getLastCellNum()) {
            return -1;
        }
        return cellnum;
    }

    public Iterator cellIterator() {
        return this.cells.values().iterator();
    }

    public int compareTo(Object obj) {
        HSSFRow loc = (HSSFRow)obj;
        if (this.getRowNum() == loc.getRowNum()) {
            return 0;
        }
        if (this.getRowNum() < loc.getRowNum()) {
            return -1;
        }
        if (this.getRowNum() > loc.getRowNum()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HSSFRow)) {
            return false;
        }
        HSSFRow loc = (HSSFRow)obj;
        return this.getRowNum() == loc.getRowNum();
    }
}

