/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.markup;

import com.lowagie.text.FontFactory;
import java.awt.Color;
import java.util.Properties;
import java.util.StringTokenizer;

public class MarkupParser {
    private MarkupParser() {
    }

    public static Properties parseAttributes(String string) {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string2 = stringTokenizer2.nextToken().trim();
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string3 = stringTokenizer2.nextToken().trim();
            if (string3.startsWith("\"")) {
                string3 = string3.substring(1);
            }
            if (string3.endsWith("\"")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            properties.setProperty(string2, string3);
        }
        return properties;
    }

    public static Properties parseFont(String string) {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        int n = 0;
        string = string.trim();
        while (string.length() > 0) {
            float f;
            String string2;
            if ((n = string.indexOf(" ", n)) == -1) {
                string2 = string;
                string = "";
            } else {
                string2 = string.substring(0, n);
                string = string.substring(n).trim();
            }
            if (string2.equalsIgnoreCase("bold")) {
                properties.setProperty("font-weight", "bold");
                continue;
            }
            if (string2.equalsIgnoreCase("italic")) {
                properties.setProperty("font-style", "italic");
                continue;
            }
            if (string2.equalsIgnoreCase("oblique")) {
                properties.setProperty("font-style", "oblique");
                continue;
            }
            float f2 = MarkupParser.parseLength(string2);
            if (f > 0.0f) {
                properties.setProperty("font-size", String.valueOf(f2) + "pt");
                int n2 = string2.indexOf("/");
                if (n2 > -1 && n2 < string2.length() - 1) {
                    properties.setProperty("line-height", String.valueOf(string2.substring(n2 + 1)) + "pt");
                }
            }
            if (string2.endsWith(",") && FontFactory.contains(string2 = string2.substring(0, string2.length() - 1))) {
                properties.setProperty("font-family", string2);
                return properties;
            }
            if (!"".equals(string) || !FontFactory.contains(string2)) continue;
            properties.setProperty("font-family", string2);
        }
        return properties;
    }

    public static float parseLength(String string) {
        int n = 0;
        int n2 = string.length();
        boolean bl = true;
        while (bl && n < n2) {
            switch (string.charAt(n)) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++n;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        if (n == 0) {
            return 0.0f;
        }
        if (n == n2) {
            return Float.valueOf(string + "f").floatValue();
        }
        float f = Float.valueOf(string.substring(0, n) + "f").floatValue();
        if ((string = string.substring(n)).startsWith("in")) {
            return f * 72.0f;
        }
        if (string.startsWith("cm")) {
            return f / 2.54f * 72.0f;
        }
        if (string.startsWith("mm")) {
            return f / 25.4f * 72.0f;
        }
        if (string.startsWith("pc")) {
            return f * 12.0f;
        }
        return f;
    }

    public static Color decodeColor(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(string.substring(1, 3), 16);
            n2 = Integer.parseInt(string.substring(3, 5), 16);
            n3 = Integer.parseInt(string.substring(5), 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Color(n, n2, n3);
    }
}

