/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PRDictionary;
import com.lowagie.text.pdf.PRName;
import com.lowagie.text.pdf.PRNumber;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

class PRStream
extends PdfStream {
    protected PRDictionary dictionary;
    protected PdfReader reader;
    protected int offset;
    protected int length;

    PRStream(PRDictionary pRDictionary, PdfReader pdfReader, int n) {
        this.dictionary = pRDictionary;
        this.reader = pdfReader;
        this.offset = n;
    }

    PRStream(PRDictionary pRDictionary, PdfReader pdfReader, byte[] byArray) {
        this.dictionary = pRDictionary;
        this.reader = pdfReader;
        this.offset = -1;
        if (Document.compress) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
                deflaterOutputStream.write(byArray);
                deflaterOutputStream.close();
                this.bytes = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            pRDictionary.put(new PRName("Filter"), new PRName("FlateDecode"));
        } else {
            this.bytes = byArray;
        }
        this.setLength(this.bytes.length);
    }

    void setLength(int n) {
        this.length = n;
        this.dictionary.put(new PRName("Length"), new PRNumber(n));
    }

    PRDictionary getDictionary() {
        return this.dictionary;
    }

    void setDictionary(PRDictionary pRDictionary) {
        this.dictionary = pRDictionary;
    }

    int getOffset() {
        return this.offset;
    }

    int getLength() {
        return this.length;
    }

    public byte[] toPdf(PdfWriter pdfWriter) {
        this.dicBytes = this.dictionary.toPdf(pdfWriter);
        return null;
    }

    int getStreamLength(PdfWriter pdfWriter) {
        if (this.dicBytes == null) {
            this.toPdf(pdfWriter);
        }
        return this.length + this.dicBytes.length + PdfStream.SIZESTREAM;
    }

    void writeTo(OutputStream outputStream, PdfWriter pdfWriter) throws IOException {
        if (this.dicBytes == null) {
            this.toPdf(pdfWriter);
        }
        outputStream.write(this.dicBytes);
        outputStream.write(PdfStream.STARTSTREAM);
        if (this.length > 0) {
            PdfEncryption pdfEncryption = pdfWriter.getEncryption();
            if (this.offset < 0) {
                if (pdfEncryption == null) {
                    outputStream.write(this.bytes);
                } else {
                    pdfEncryption.prepareKey();
                    byte[] byArray = new byte[this.length];
                    System.arraycopy(this.bytes, 0, byArray, 0, this.length);
                    pdfEncryption.encryptRC4(byArray);
                    outputStream.write(byArray);
                }
            } else {
                byte[] byArray = new byte[Math.min(this.length, 4092)];
                RandomAccessFileOrArray randomAccessFileOrArray = pdfWriter.getReaderFile(this.reader);
                randomAccessFileOrArray.seek(this.offset);
                int n = this.length;
                if (pdfEncryption != null) {
                    pdfEncryption.prepareKey();
                }
                while (n > 0) {
                    int n2 = randomAccessFileOrArray.read(byArray, 0, Math.min(n, byArray.length));
                    n -= n2;
                    if (pdfEncryption != null) {
                        pdfEncryption.encryptRC4(byArray, 0, n2);
                    }
                    outputStream.write(byArray, 0, n2);
                }
            }
        }
        outputStream.write(PdfStream.ENDSTREAM);
    }
}

