/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPrintable;

class PdfNumber
extends PdfObject
implements PdfPrintable {
    public static final int INTEGER = 0;
    public static final int REAL = 1;
    private int numberType;
    private double value;

    PdfNumber(int n, String string) throws BadPdfFormatException {
        super(2);
        this.numberType = n;
        switch (this.numberType) {
            case 0: {
                try {
                    int n2 = Integer.parseInt(string.trim());
                    this.setContent(String.valueOf(n2));
                    this.value = 1.0 * (double)n2;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BadPdfFormatException(string + " is not a valid integer.");
                }
            }
            case 1: {
                try {
                    double d = Double.valueOf(string.trim());
                    this.setContent(ByteBuffer.formatDouble(d));
                    this.value = d;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BadPdfFormatException(string + " is not a valid real.");
                }
            }
            default: {
                throw new BadPdfFormatException("Unknown type of number: " + n);
            }
        }
    }

    PdfNumber(int n) {
        super(2, String.valueOf(n));
        this.value = 1.0 * (double)n;
        this.numberType = 0;
    }

    PdfNumber(double d) {
        super(2, ByteBuffer.formatDouble(d));
        this.value = d;
        this.numberType = 1;
    }

    PdfNumber(float f) {
        this((double)f);
    }

    public String toString() {
        if (this.numberType == 0) {
            return String.valueOf((int)this.value);
        }
        return ByteBuffer.formatDouble(this.value);
    }

    final int intValue() {
        return (int)this.value;
    }

    final double doubleValue() {
        return this.value;
    }

    void increment() {
        this.value += 1.0;
        this.setContent(ByteBuffer.formatDouble(this.value));
    }
}

