/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfPatternPainter;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;

public class PdfPattern
extends PdfStream {
    PdfPattern(PdfPatternPainter pdfPatternPainter) {
        PdfNumber pdfNumber = new PdfNumber(1);
        PdfArray pdfArray = pdfPatternPainter.getMatrix();
        if (pdfArray != null) {
            this.dictionary.put(PdfName.MATRIX, pdfArray);
        }
        this.dictionary.put(PdfName.TYPE, PdfName.PATTERN);
        this.dictionary.put(PdfName.BBOX, new PdfRectangle(pdfPatternPainter.getBoundingBox()));
        this.dictionary.put(PdfName.RESOURCES, pdfPatternPainter.getResources());
        PdfName pdfName = new PdfName("TilingType");
        this.dictionary.put(pdfName, pdfNumber);
        pdfName = new PdfName("PatternType");
        this.dictionary.put(pdfName, pdfNumber);
        pdfName = new PdfName("PaintType");
        if (pdfPatternPainter.isStencil()) {
            this.dictionary.put(pdfName, new PdfNumber(2));
        } else {
            this.dictionary.put(pdfName, pdfNumber);
        }
        pdfName = new PdfName("XStep");
        this.dictionary.put(pdfName, new PdfNumber(pdfPatternPainter.getXStep()));
        pdfName = new PdfName("YStep");
        this.dictionary.put(pdfName, new PdfNumber(pdfPatternPainter.getYStep()));
        this.bytes = pdfPatternPainter.toPdf(null);
        this.dictionary.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
        try {
            this.flateCompress();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }
}

