/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.LZWDecoder;
import com.lowagie.text.pdf.PRArray;
import com.lowagie.text.pdf.PRDictionary;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRLiteral;
import com.lowagie.text.pdf.PRName;
import com.lowagie.text.pdf.PRNumber;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRString;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.InflaterInputStream;

public class PdfReader {
    static final PRName NAME_BBOX = new PRName("BBox");
    static final PRName NAME_COUNT = new PRName("Count");
    static final PRName NAME_CONTENTS = new PRName("Contents");
    static final PRName NAME_CROPBOX = new PRName("CropBox");
    static final PRName NAME_ENCRYPT = new PRName("Encrypt");
    static final PRName NAME_FORMTYPE = new PRName("FormType");
    static final PRName NAME_ID = new PRName("ID");
    static final PRName NAME_INFO = new PRName("Info");
    static final PRName NAME_KIDS = new PRName("Kids");
    static final PRName NAME_LENGTH = new PRName("Length");
    static final PRName NAME_MATRIX = new PRName("Matrix");
    static final PRName NAME_MEDIABOX = new PRName("MediaBox");
    static final PRName NAME_PAGE = new PRName("Page");
    static final PRName NAME_PAGES = new PRName("Pages");
    static final PRName NAME_PREV = new PRName("Prev");
    static final PRName NAME_RESOURCES = new PRName("Resources");
    static final PRName NAME_ROOT = new PRName("Root");
    static final PRName NAME_ROTATE = new PRName("Rotate");
    static final PRName NAME_SIZE = new PRName("Size");
    static final PRName NAME_SUBTYPE = new PRName("Subtype");
    static final PRName NAME_TYPE = new PRName("Type");
    static final PRName[] pageInhCandidates = new PRName[]{NAME_MEDIABOX, NAME_ROTATE, NAME_RESOURCES, NAME_CROPBOX};
    PRTokeniser tokens;
    int[] xref;
    PdfObject[] xrefObj;
    PRDictionary trailer;
    PRDictionary[] pages;
    ArrayList pageInh;
    int pagesCount;

    public PdfReader(String string) throws IOException {
        this.tokens = new PRTokeniser(string);
        this.readPdf();
    }

    public PdfReader(byte[] byArray) throws IOException {
        this.tokens = new PRTokeniser(byArray);
        this.readPdf();
    }

    RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    PdfReaderInstance getPdfReaderInstance(PdfWriter pdfWriter) {
        return new PdfReaderInstance(this, pdfWriter, this.xrefObj, this.pages);
    }

    public int getNumberOfPages() {
        return this.pages.length;
    }

    public int getPageRotation(int n) {
        PRDictionary pRDictionary = this.pages[n - 1];
        PRNumber pRNumber = (PRNumber)this.getPdfObject(pRDictionary.get(NAME_ROTATE));
        if (pRNumber == null) {
            return 0;
        }
        return pRNumber.intValue();
    }

    public Rectangle getPageSizeWithRotation(int n) {
        Rectangle rectangle = this.getPageSize(n);
        int n2 = this.getPageRotation(n);
        while (n2 > 0) {
            rectangle = rectangle.rotate();
            n2 -= 90;
        }
        return rectangle;
    }

    public Rectangle getPageSize(int n) {
        PRDictionary pRDictionary = this.pages[n - 1];
        PRArray pRArray = (PRArray)this.getPdfObject(pRDictionary.get(NAME_MEDIABOX));
        return PdfReader.getNormalizedRectangle(pRArray);
    }

    public Rectangle getCropBox(int n) {
        PRDictionary pRDictionary = this.pages[n - 1];
        PRArray pRArray = (PRArray)this.getPdfObject(pRDictionary.get(NAME_MEDIABOX));
        if (pRArray == null) {
            return this.getPageSize(n);
        }
        return PdfReader.getNormalizedRectangle(pRArray);
    }

    static Rectangle getNormalizedRectangle(PRArray pRArray) {
        ArrayList arrayList = pRArray.getArrayList();
        float f = ((PRNumber)arrayList.get(0)).floatValue();
        float f2 = ((PRNumber)arrayList.get(1)).floatValue();
        float f3 = ((PRNumber)arrayList.get(2)).floatValue();
        float f4 = ((PRNumber)arrayList.get(3)).floatValue();
        return new Rectangle(Math.min(f, f3), Math.min(f2, f4), Math.max(f, f3), Math.max(f2, f4));
    }

    void readPdf() throws IOException {
        try {
            this.tokens.checkPdfHeader();
            this.readXref();
            this.readDocObj();
            this.readPages();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                this.tokens.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.tokens.close();
        }
        catch (Exception exception) {}
    }

    PdfObject getPdfObject(PdfObject pdfObject) {
        if (pdfObject == null) {
            return null;
        }
        if (pdfObject.type() != 10) {
            return pdfObject;
        }
        int n = ((PRIndirectReference)pdfObject).getNumber();
        if ((pdfObject = this.xrefObj[n]) == null) {
            return PdfNull.PDFNULL;
        }
        return pdfObject;
    }

    void pushPageAttributes(PRDictionary pRDictionary) {
        PRDictionary pRDictionary2 = new PRDictionary();
        if (this.pageInh.size() != 0) {
            pRDictionary2.putAll((PRDictionary)this.pageInh.get(this.pageInh.size() - 1));
        }
        int n = 0;
        while (n < pageInhCandidates.length) {
            PdfObject pdfObject = pRDictionary.get(pageInhCandidates[n]);
            if (pdfObject != null) {
                pRDictionary2.put(pageInhCandidates[n], pdfObject);
            }
            ++n;
        }
        this.pageInh.add(pRDictionary2);
    }

    void popPageAttributes() {
        this.pageInh.remove(this.pageInh.size() - 1);
    }

    void iteratePages(PRDictionary pRDictionary) throws IOException {
        PRName pRName = (PRName)this.getPdfObject(pRDictionary.get(NAME_TYPE));
        if (pRName.equals(NAME_PAGE)) {
            PRDictionary pRDictionary2 = (PRDictionary)this.pageInh.get(this.pageInh.size() - 1);
            Iterator iterator = pRDictionary2.getIterator();
            while (iterator.hasNext()) {
                PRName pRName2 = (PRName)iterator.next();
                if (pRDictionary.get(pRName2) != null) continue;
                pRDictionary.put(pRName2, pRDictionary2.get(pRName2));
            }
            this.pages[this.pagesCount++] = pRDictionary;
        } else {
            this.pushPageAttributes(pRDictionary);
            PRArray pRArray = (PRArray)this.getPdfObject(pRDictionary.get(NAME_KIDS));
            ArrayList arrayList = pRArray.getArrayList();
            int n = 0;
            while (n < arrayList.size()) {
                PRDictionary pRDictionary3 = (PRDictionary)this.getPdfObject((PdfObject)arrayList.get(n));
                this.iteratePages(pRDictionary3);
                ++n;
            }
            this.popPageAttributes();
        }
    }

    void readPages() throws IOException {
        this.pageInh = new ArrayList();
        PRDictionary pRDictionary = (PRDictionary)this.getPdfObject(this.trailer.get(NAME_ROOT));
        PRDictionary pRDictionary2 = (PRDictionary)this.getPdfObject(pRDictionary.get(NAME_PAGES));
        PRNumber pRNumber = (PRNumber)this.getPdfObject(pRDictionary2.get(NAME_COUNT));
        this.pages = new PRDictionary[pRNumber.intValue()];
        this.pagesCount = 0;
        this.iteratePages(pRDictionary2);
        this.pageInh = null;
    }

    void readDocObj() throws IOException {
        int n;
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        this.xrefObj = new PdfObject[this.xref.length];
        int n2 = 1;
        while (n2 < this.xrefObj.length) {
            n = this.xref[n2];
            if (n > 0) {
                PdfObject pdfObject;
                this.tokens.seek(n);
                this.tokens.nextValidToken();
                if (this.tokens.getTokenType() != 1) {
                    this.tokens.throwError("Invalid object number.");
                }
                int n3 = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (this.tokens.getTokenType() != 1) {
                    this.tokens.throwError("Invalid generation number.");
                }
                int n4 = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (!this.tokens.getStringValue().equals("obj")) {
                    this.tokens.throwError("Token 'obj' expected.");
                }
                this.xrefObj[n2] = pdfObject = this.readPRObject();
                if (pdfObject.type() == 7) {
                    arrayList.add(pdfObject);
                }
            }
            ++n2;
        }
        n = 0;
        while (n < arrayList.size()) {
            PRStream pRStream = (PRStream)arrayList.get(n);
            PdfObject pdfObject = this.getPdfObject(pRStream.getDictionary().get(NAME_LENGTH));
            pRStream.setLength(((PRNumber)pdfObject).intValue());
            ++n;
        }
    }

    void readXref() throws IOException {
        PRNumber pRNumber;
        int n;
        this.tokens.seek(this.tokens.getStartxref());
        this.tokens.nextToken();
        if (!this.tokens.getStringValue().equals("startxref")) {
            throw new IOException("startxref not found.");
        }
        this.tokens.nextToken();
        if (this.tokens.getTokenType() != 1) {
            throw new IOException("startxref is not followed by a number.");
        }
        int n2 = this.tokens.intValue();
        this.tokens.seek(n2);
        while ((n = this.tokens.read()) != -1 && n != 116) {
        }
        if (n == -1) {
            throw new IOException("Unexpected end of file.");
        }
        this.tokens.backOnePosition();
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("trailer")) {
            throw new IOException("trailer not found.");
        }
        this.trailer = (PRDictionary)this.readPRObject();
        if (this.trailer.get(NAME_ENCRYPT) != null) {
            throw new IOException("Encrypted files are not supported.");
        }
        PRNumber pRNumber2 = (PRNumber)this.trailer.get(NAME_SIZE);
        this.xref = new int[pRNumber2.intValue()];
        this.tokens.seek(n2);
        this.readXrefSection();
        PRDictionary pRDictionary = this.trailer;
        while ((pRNumber = (PRNumber)pRDictionary.get(NAME_PREV)) != null) {
            this.tokens.seek(pRNumber.intValue());
            this.readXrefSection();
            pRDictionary = (PRDictionary)this.readPRObject();
        }
    }

    void readXrefSection() throws IOException {
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("xref")) {
            this.tokens.throwError("xref subsection not found");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block0: while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getStringValue().equals("trailer")) break;
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Object number of the first object in this xref subsection not found");
            }
            n = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Number of entries in this xref subsection not found");
            }
            n2 = this.tokens.intValue() + n;
            int n5 = n;
            while (true) {
                if (n5 >= n2) continue block0;
                this.tokens.nextValidToken();
                n3 = this.tokens.intValue();
                this.tokens.nextValidToken();
                n4 = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (this.tokens.getStringValue().equals("n")) {
                    if (this.xref[n5] == 0) {
                        this.xref[n5] = n3;
                    }
                } else if (this.tokens.getStringValue().equals("f")) {
                    if (this.xref[n5] == 0) {
                        this.xref[n5] = -1;
                    }
                } else {
                    this.tokens.throwError("Invalid cross-reference entry in this xref subsection");
                }
                ++n5;
            }
            break;
        }
    }

    PRDictionary readDictionary() throws IOException {
        PRDictionary pRDictionary = new PRDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == 8) break;
            if (this.tokens.getTokenType() != 3) {
                this.tokens.throwError("Dictionary key is not a name.");
            }
            PRName pRName = new PRName(this.tokens.getStringValue());
            PdfObject pdfObject = this.readPRObject();
            int n = pdfObject.type();
            if (-n == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            if (-n == 6) {
                this.tokens.throwError("Unexpected ']'");
            }
            pRDictionary.put(pRName, pdfObject);
        }
        return pRDictionary;
    }

    PRArray readArray() throws IOException {
        PdfObject pdfObject;
        int n;
        PRArray pRArray = new PRArray();
        while (-(n = (pdfObject = this.readPRObject()).type()) != 6) {
            if (-n == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            pRArray.add(pdfObject);
        }
        return pRArray;
    }

    PdfObject readPRObject() throws IOException {
        this.tokens.nextValidToken();
        int n = this.tokens.getTokenType();
        switch (n) {
            case 7: {
                PRDictionary pRDictionary = this.readDictionary();
                int n2 = this.tokens.getFilePointer();
                this.tokens.nextValidToken();
                if (this.tokens.getStringValue().equals("stream")) {
                    int n3 = this.tokens.read();
                    if (n3 == 13) {
                        n3 = this.tokens.read();
                    }
                    if (n3 != 10) {
                        this.tokens.backOnePosition();
                    }
                    return new PRStream(pRDictionary, this, this.tokens.getFilePointer());
                }
                this.tokens.seek(n2);
                return pRDictionary;
            }
            case 5: {
                return this.readArray();
            }
            case 1: {
                return new PRNumber(this.tokens.getStringValue());
            }
            case 2: {
                return new PRString(this.tokens.getStringValue());
            }
            case 3: {
                return new PRName(this.tokens.getStringValue());
            }
            case 9: {
                return new PRIndirectReference(this, this.tokens.getReference(), this.tokens.getReference());
            }
        }
        return new PRLiteral(-n, this.tokens.getStringValue());
    }

    static byte[] FlateDecode(byte[] byArray) {
        byte[] byArray2 = PdfReader.FlateDecode(byArray, true);
        if (byArray2 == null) {
            return PdfReader.FlateDecode(byArray, false);
        }
        return byArray2;
    }

    static byte[] FlateDecode(byte[] byArray, boolean bl) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[bl ? 4092 : 1];
        try {
            int n;
            while ((n = inflaterInputStream.read(byArray2)) >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            inflaterInputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (bl) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    static byte[] ASCIIHexDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2] & 0xFF;
            if (n3 == 62) break;
            if (!PRTokeniser.isWhitespace(n3)) {
                int n4 = PRTokeniser.getHex(n3);
                if (n4 == -1) {
                    throw new RuntimeException("Illegal character in ASCIIHexDecode.");
                }
                if (bl) {
                    n = n4;
                } else {
                    byteArrayOutputStream.write((byte)((n << 4) + n4));
                }
                bl = !bl;
            }
            ++n2;
        }
        if (!bl) {
            byteArrayOutputStream.write((byte)(n << 4));
        }
        return byteArrayOutputStream.toByteArray();
    }

    static byte[] ASCII85Decode(byte[] byArray) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        int[] nArray = new int[5];
        int n3 = 0;
        while (n3 < byArray.length) {
            n = byArray[n3] & 0xFF;
            if (n == 126) break;
            if (!PRTokeniser.isWhitespace(n)) {
                if (n == 122 && n2 == 0) {
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                } else {
                    if (n < 33 || n > 117) {
                        throw new RuntimeException("Illegal character in ASCII85Decode.");
                    }
                    nArray[n2] = n - 33;
                    if (++n2 == 5) {
                        n2 = 0;
                        int n4 = 0;
                        int n5 = 0;
                        while (n5 < 5) {
                            n4 = n4 * 85 + nArray[n5];
                            ++n5;
                        }
                        byteArrayOutputStream.write((byte)(n4 >> 24));
                        byteArrayOutputStream.write((byte)(n4 >> 16));
                        byteArrayOutputStream.write((byte)(n4 >> 8));
                        byteArrayOutputStream.write((byte)n4);
                    }
                }
            }
            ++n3;
        }
        n = 0;
        if (n2 == 1) {
            throw new RuntimeException("Illegal length in ASCII85Decode.");
        }
        if (n2 == 2) {
            n = nArray[0] * 85 + nArray[1];
            byteArrayOutputStream.write((byte)n);
        } else if (n2 == 3) {
            n = nArray[0] * 85 * 85 + nArray[1] * 85 + nArray[2];
            byteArrayOutputStream.write((byte)(n >> 8));
            byteArrayOutputStream.write((byte)n);
        } else if (n2 == 4) {
            n = nArray[0] * 85 * 85 * 85 + nArray[1] * 85 * 85 + nArray[2] * 85 + nArray[3];
            byteArrayOutputStream.write((byte)(n >> 16));
            byteArrayOutputStream.write((byte)(n >> 8));
            byteArrayOutputStream.write((byte)n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static byte[] LZWDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LZWDecoder lZWDecoder = new LZWDecoder();
        lZWDecoder.decode(byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

