/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColorDetails;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.FontDetails;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfImage;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfPages;
import com.lowagie.text.pdf.PdfPatternPainter;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfResources;
import com.lowagie.text.pdf.PdfSpotColor;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfXObjectDictionary;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SpotColor;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class PdfWriter
extends DocWriter {
    public static final int PageLayoutSinglePage = 1;
    public static final int PageLayoutOneColumn = 2;
    public static final int PageLayoutTwoColumnLeft = 4;
    public static final int PageLayoutTwoColumnRight = 8;
    public static final int PageModeUseNone = 16;
    public static final int PageModeUseOutlines = 32;
    public static final int PageModeUseThumbs = 64;
    public static final int PageModeFullScreen = 128;
    public static final int HideToolbar = 256;
    public static final int HideMenubar = 512;
    public static final int HideWindowUI = 1024;
    public static final int FitWindow = 2048;
    public static final int CenterWindow = 4096;
    public static final int NonFullScreenPageModeUseNone = 8192;
    public static final int NonFullScreenPageModeUseOutlines = 16384;
    public static final int NonFullScreenPageModeUseThumbs = 32768;
    public static final int DirectionL2R = 65536;
    public static final int DirectionR2L = 131072;
    static final int ViewerPreferencesMask = 261888;
    public static final int AllowPrinting = 2052;
    public static final int AllowModifyContents = 8;
    public static final int AllowCopy = 16;
    public static final int AllowModifyAnnotations = 32;
    public static final int AllowFillIn = 256;
    public static final int AllowScreenReaders = 512;
    public static final int AllowAssembly = 1024;
    public static final int AllowDegradedPrinting = 4;
    public static final boolean STRENGTH40BITS = false;
    public static final boolean STRENGTH128BITS = true;
    public static final int SIGNATURE_EXISTS = 1;
    public static final int SIGNATURE_APPEND_ONLY = 2;
    public static final char VERSION_1_2 = '2';
    public static final char VERSION_1_3 = '3';
    public static final char VERSION_1_4 = '4';
    private static final int VPOINT = 7;
    private byte[] HEADER = DocWriter.getISOBytes("%PDF-1.4\n%\u00e0\u00e1\u00e2\u00e3\n");
    private int OFFSET = this.HEADER.length;
    private static final int ROOT = 1;
    private static final PdfIndirectReference ROOTREFERENCE = new PdfIndirectReference(6, 1);
    protected PdfPages root = new PdfPages();
    protected PdfXObjectDictionary imageDictionary = new PdfXObjectDictionary();
    protected HashMap formXObjects = new HashMap();
    protected int formXObjectsCounter = 1;
    protected int fontNumber = 1;
    protected int colorNumber = 1;
    protected int patternNumber = 1;
    protected PdfContentByte directContent;
    protected PdfContentByte directContentUnder;
    protected HashMap documentFonts = new HashMap();
    protected HashMap documentColors = new HashMap();
    protected HashMap documentPatterns = new HashMap();
    protected ColorDetails patternColorspaceRGB;
    protected ColorDetails patternColorspaceGRAY;
    protected ColorDetails patternColorspaceCMYK;
    protected HashMap documentSpotPatterns = new HashMap();
    private PdfBody body = new PdfBody(this.OFFSET, this);
    private PdfDocument pdf;
    private PdfPageEvent pageEvent;
    private PdfEncryption crypto;
    private HashMap importedPages = new HashMap();
    private PdfReaderInstance currentPdfReaderInstance;
    private ArrayList pageReferences = new ArrayList();
    private int currentPageNumber = 1;

    protected PdfWriter(PdfDocument pdfDocument, OutputStream outputStream) {
        super(pdfDocument, outputStream);
        this.pdf = pdfDocument;
        this.directContent = new PdfContentByte(this);
        this.directContentUnder = new PdfContentByte(this);
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream, DocListener docListener) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        pdfDocument.addDocListener(docListener);
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    public PdfIndirectReference add(PdfPage pdfPage, PdfContents pdfContents) throws PdfException {
        if (!this.open) {
            throw new PdfException("The document isn't open.");
        }
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfContents);
        try {
            pdfIndirectObject.writeTo(this.os);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        pdfPage.add(pdfIndirectObject.getIndirectReference());
        pdfPage.setParent(ROOTREFERENCE);
        PdfIndirectObject pdfIndirectObject2 = this.body.add((PdfObject)pdfPage, this.getPageReference(this.currentPageNumber++));
        try {
            pdfIndirectObject2.writeTo(this.os);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        this.root.add(pdfIndirectObject2.getIndirectReference());
        return pdfIndirectObject2.getIndirectReference();
    }

    public PdfIndirectReference add(PdfImage pdfImage) throws PdfException {
        if (!this.imageDictionary.contains(pdfImage)) {
            PdfIndirectObject pdfIndirectObject = this.body.add(pdfImage);
            try {
                pdfIndirectObject.writeTo(this.os);
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.imageDictionary.put(pdfImage.name(), pdfIndirectObject.getIndirectReference());
            return pdfIndirectObject.getIndirectReference();
        }
        return (PdfIndirectReference)this.imageDictionary.get(pdfImage.name());
    }

    public PdfIndirectReference getImageReference(PdfName pdfName) {
        return (PdfIndirectReference)this.imageDictionary.get(pdfName);
    }

    public PdfIndirectReference add(PdfOutline pdfOutline) throws PdfException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfOutline);
        try {
            pdfIndirectObject.writeTo(this.os);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        return pdfIndirectObject.getIndirectReference();
    }

    public void open() {
        try {
            this.os.write(this.HEADER);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public synchronized void close() {
        if (this.open) {
            if (this.currentPageNumber - 1 != this.pageReferences.size()) {
                throw new RuntimeException("The page " + this.pageReferences.size() + " was requested but the document has only " + (this.currentPageNumber - 1) + " pages.");
            }
            this.pdf.close();
            try {
                Object object;
                PdfIndirectObject pdfIndirectObject;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Iterator iterator = this.documentFonts.values().iterator();
                while (iterator.hasNext()) {
                    object6 = (FontDetails)iterator.next();
                    ((FontDetails)object6).writeFont(this);
                }
                object6 = this.formXObjects.keySet().iterator();
                while (object6.hasNext()) {
                    object5 = (PdfTemplate)object6.next();
                    if (((PdfTemplate)object5).getType() != 1) continue;
                    object4 = this.body.add((PdfObject)((PdfTemplate)object5).getFormXObject(), ((PdfTemplate)object5).getIndirectReference());
                    ((PdfIndirectObject)object4).writeTo(this.os);
                }
                object5 = this.importedPages.values().iterator();
                while (object5.hasNext()) {
                    this.currentPdfReaderInstance = (PdfReaderInstance)object5.next();
                    this.currentPdfReaderInstance.writeAllPages();
                }
                object4 = this.documentColors.values().iterator();
                while (object4.hasNext()) {
                    object3 = (ColorDetails)object4.next();
                    object2 = this.body.add((PdfObject)((ColorDetails)object3).getSpotColor(), ((ColorDetails)object3).getIndirectReference());
                    ((PdfIndirectObject)object2).writeTo(this.os);
                }
                object3 = this.documentPatterns.keySet().iterator();
                while (object3.hasNext()) {
                    object2 = (PdfPatternPainter)object3.next();
                    pdfIndirectObject = this.body.add((PdfObject)((PdfPatternPainter)object2).getPattern(), ((PdfTemplate)object2).getIndirectReference());
                    pdfIndirectObject.writeTo(this.os);
                }
                object2 = this.body.add(this.root);
                ((PdfIndirectObject)object2).writeTo(this.os);
                pdfIndirectObject = this.body.add(((PdfDocument)this.document).getCatalog(((PdfIndirectObject)object2).getIndirectReference()));
                pdfIndirectObject.writeTo(this.os);
                PdfIndirectObject pdfIndirectObject2 = this.body.add(((PdfDocument)this.document).getInfo());
                pdfIndirectObject2.writeTo(this.os);
                PdfIndirectReference pdfIndirectReference = null;
                PdfLiteral pdfLiteral = null;
                if (this.crypto != null) {
                    object = this.body.add(this.crypto.getEncryptionDictionary());
                    ((PdfIndirectObject)object).writeTo(this.os);
                    pdfIndirectReference = ((PdfIndirectObject)object).getIndirectReference();
                    pdfLiteral = this.crypto.getFileID();
                }
                this.os.write(this.body.getCrossReferenceTable());
                object = new PdfTrailer(this.body.size(), this.body.offset(), pdfIndirectObject.getIndirectReference(), pdfIndirectObject2.getIndirectReference(), pdfIndirectReference, pdfLiteral);
                this.os.write(((PdfTrailer)object).toPdf(this));
                super.close();
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
    }

    int size() {
        return this.body.size();
    }

    public float getTableBottom(Table table) {
        return this.pdf.bottom(table) - this.pdf.indentBottom();
    }

    public boolean fitsPage(Table table, float f) {
        return this.pdf.bottom(table) > this.pdf.indentBottom() + f;
    }

    public boolean fitsPage(Table table) {
        return this.fitsPage(table, 0.0f);
    }

    public boolean fitsPage(PdfPTable pdfPTable, float f) {
        return this.pdf.fitsPage(pdfPTable, f);
    }

    public boolean fitsPage(PdfPTable pdfPTable) {
        return this.pdf.fitsPage(pdfPTable, 0.0f);
    }

    boolean isPaused() {
        return this.pause;
    }

    public PdfContentByte getDirectContent() {
        return this.directContent;
    }

    public PdfContentByte getDirectContentUnder() {
        return this.directContentUnder;
    }

    void resetContent() {
        this.directContent.reset();
        this.directContentUnder.reset();
    }

    public PdfAcroForm getAcroForm() {
        return this.pdf.getAcroForm();
    }

    public PdfOutline getRootOutline() {
        return this.directContent.getRootOutline();
    }

    FontDetails add(BaseFont baseFont) {
        FontDetails fontDetails = this.addSimple(baseFont);
        this.pdf.addFont(fontDetails.getFontName(), fontDetails.getIndirectReference());
        return fontDetails;
    }

    FontDetails addSimple(BaseFont baseFont) {
        FontDetails fontDetails = (FontDetails)this.documentFonts.get(baseFont);
        if (fontDetails == null) {
            fontDetails = new FontDetails(new PdfName("F" + this.fontNumber++), this.body.getPdfIndirectReference(), baseFont);
            this.documentFonts.put(baseFont, fontDetails);
        }
        return fontDetails;
    }

    void eliminateFontSubset(PdfDictionary pdfDictionary) {
        Iterator iterator = this.documentFonts.values().iterator();
        while (iterator.hasNext()) {
            FontDetails fontDetails = (FontDetails)iterator.next();
            if (pdfDictionary.get(fontDetails.getFontName()) == null) continue;
            fontDetails.setSubset(false);
        }
    }

    ColorDetails add(PdfSpotColor pdfSpotColor) {
        ColorDetails colorDetails = this.addSimple(pdfSpotColor);
        this.pdf.addColor(colorDetails.getColorName(), colorDetails.getIndirectReference());
        return colorDetails;
    }

    ColorDetails addSimple(PdfSpotColor pdfSpotColor) {
        ColorDetails colorDetails = (ColorDetails)this.documentColors.get(pdfSpotColor);
        if (colorDetails == null) {
            colorDetails = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), pdfSpotColor);
            this.documentColors.put(pdfSpotColor, colorDetails);
        }
        return colorDetails;
    }

    ColorDetails addSimplePatternColorspace(Color color) {
        int n = ExtendedColor.getType(color);
        if (n == 4) {
            throw new RuntimeException("An uncolored tile pattern can not have another pattern as color.");
        }
        try {
            switch (n) {
                case 0: {
                    if (this.patternColorspaceRGB == null) {
                        this.patternColorspaceRGB = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICERGB);
                        PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)pdfArray, this.patternColorspaceRGB.getIndirectReference());
                        pdfIndirectObject.writeTo(this.os);
                    }
                    return this.patternColorspaceRGB;
                }
                case 2: {
                    if (this.patternColorspaceCMYK == null) {
                        this.patternColorspaceCMYK = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICECMYK);
                        PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)pdfArray, this.patternColorspaceCMYK.getIndirectReference());
                        pdfIndirectObject.writeTo(this.os);
                    }
                    return this.patternColorspaceCMYK;
                }
                case 1: {
                    if (this.patternColorspaceGRAY == null) {
                        this.patternColorspaceGRAY = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICEGRAY);
                        PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)pdfArray, this.patternColorspaceGRAY.getIndirectReference());
                        pdfIndirectObject.writeTo(this.os);
                    }
                    return this.patternColorspaceGRAY;
                }
                case 3: {
                    ColorDetails colorDetails = this.addSimple(((SpotColor)color).getPdfSpotColor());
                    ColorDetails colorDetails2 = (ColorDetails)this.documentSpotPatterns.get(colorDetails);
                    if (colorDetails2 == null) {
                        colorDetails2 = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(colorDetails.getIndirectReference());
                        PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)pdfArray, colorDetails2.getIndirectReference());
                        pdfIndirectObject.writeTo(this.os);
                    }
                    return colorDetails2;
                }
            }
            throw new RuntimeException("Invalid color type in PdfWriter.addSimplePatternColorspace().");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    PdfDocument getPdfDocument() {
        return this.pdf;
    }

    PdfIndirectReference getPdfIndirectReference() {
        return this.body.getPdfIndirectReference();
    }

    int getIndirectReferenceNumber() {
        return this.body.getIndirectReferenceNumber();
    }

    PdfName addSimplePattern(PdfPatternPainter pdfPatternPainter) {
        PdfName pdfName = (PdfName)this.documentPatterns.get(pdfPatternPainter);
        try {
            if (pdfName == null) {
                pdfName = new PdfName("P" + this.patternNumber);
                ++this.patternNumber;
                this.documentPatterns.put(pdfPatternPainter, pdfName);
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return pdfName;
    }

    PdfName addDirectTemplateSimple(PdfTemplate pdfTemplate) {
        PdfName pdfName = (PdfName)this.formXObjects.get(pdfTemplate);
        try {
            if (pdfName == null) {
                pdfName = new PdfName("Xf" + this.formXObjectsCounter);
                ++this.formXObjectsCounter;
                this.formXObjects.put(pdfTemplate, pdfName);
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return pdfName;
    }

    public void setPageEvent(PdfPageEvent pdfPageEvent) {
        this.pageEvent = pdfPageEvent;
    }

    public PdfPageEvent getPageEvent() {
        return this.pageEvent;
    }

    void addLocalDestinations(TreeMap treeMap) throws IOException {
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object[] objectArray = (Object[])treeMap.get(string);
            PdfDestination pdfDestination = (PdfDestination)objectArray[2];
            if (pdfDestination == null) {
                throw new RuntimeException("The name '" + string + "' has no local destination.");
            }
            if (objectArray[1] == null) {
                objectArray[1] = this.getPdfIndirectReference();
            }
            PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)pdfDestination, (PdfIndirectReference)objectArray[1]);
            pdfIndirectObject.writeTo(this.os);
        }
    }

    public int getPageNumber() {
        return this.pdf.getPageNumber();
    }

    public void setViewerPreferences(int n) {
        this.pdf.setViewerPreferences(n);
    }

    public void setEncryption(byte[] byArray, byte[] byArray2, int n, boolean bl) throws DocumentException {
        if (this.pdf.isOpen()) {
            throw new DocumentException("Encryption can only be added before opening the document.");
        }
        this.crypto = new PdfEncryption();
        this.crypto.setupAllKeys(byArray, byArray2, n, bl);
    }

    public void setEncryption(boolean bl, String string, String string2, int n) throws DocumentException {
        this.setEncryption(DocWriter.getISOBytes(string), DocWriter.getISOBytes(string2), n, bl);
    }

    PdfIndirectObject addToBody(PdfObject pdfObject) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject);
        pdfIndirectObject.writeTo(this.os);
        return pdfIndirectObject;
    }

    PdfIndirectObject addToBody(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject, pdfIndirectReference);
        pdfIndirectObject.writeTo(this.os);
        return pdfIndirectObject;
    }

    PdfIndirectObject addToBody(PdfObject pdfObject, int n) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject, n);
        pdfIndirectObject.writeTo(this.os);
        return pdfIndirectObject;
    }

    public void setOpenAction(String string) {
        this.pdf.setOpenAction(string);
    }

    public void setOpenAction(PdfAction pdfAction) {
        this.pdf.setOpenAction(pdfAction);
    }

    public void setPageLabels(PdfPageLabels pdfPageLabels) {
        this.pdf.setPageLabels(pdfPageLabels);
    }

    PdfEncryption getEncryption() {
        return this.crypto;
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        return this.currentPdfReaderInstance.getReaderFile();
    }

    int getNewObjectNumber(PdfReader pdfReader, int n, int n2) {
        return this.currentPdfReaderInstance.getNewObjectNumber(n, n2);
    }

    public PdfImportedPage getImportedPage(PdfReader pdfReader, int n) {
        PdfReaderInstance pdfReaderInstance = (PdfReaderInstance)this.importedPages.get(pdfReader);
        if (pdfReaderInstance == null) {
            pdfReaderInstance = pdfReader.getPdfReaderInstance(this);
            this.importedPages.put(pdfReader, pdfReaderInstance);
        }
        return pdfReaderInstance.getImportedPage(n);
    }

    public void addJavaScript(PdfAction pdfAction) {
        this.pdf.addJavaScript(pdfAction);
    }

    public void addJavaScript(String string, boolean bl) {
        this.addJavaScript(PdfAction.javaScript(string, this, bl));
    }

    public void addJavaScript(String string) {
        this.addJavaScript(string, false);
    }

    public void setCropBoxSize(Rectangle rectangle) {
        this.pdf.setCropBoxSize(rectangle);
    }

    PdfIndirectReference getPageReference(int n) {
        PdfIndirectReference pdfIndirectReference;
        if (--n < 0) {
            throw new IndexOutOfBoundsException("The page numbers start at 1.");
        }
        if (n < this.pageReferences.size()) {
            pdfIndirectReference = (PdfIndirectReference)this.pageReferences.get(n);
            if (pdfIndirectReference == null) {
                pdfIndirectReference = this.body.getPdfIndirectReference();
                this.pageReferences.set(n, pdfIndirectReference);
            }
        } else {
            int n2 = n - this.pageReferences.size();
            int n3 = 0;
            while (n3 < n2) {
                this.pageReferences.add(null);
                ++n3;
            }
            pdfIndirectReference = this.body.getPdfIndirectReference();
            this.pageReferences.add(pdfIndirectReference);
        }
        return pdfIndirectReference;
    }

    PdfIndirectReference getCurrentPage() {
        return this.getPageReference(this.currentPageNumber);
    }

    int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public void addCalculationOrder(PdfFormField pdfFormField) {
        this.pdf.addCalculationOrder(pdfFormField);
    }

    public void setSigFlags(int n) {
        this.pdf.setSigFlags(n);
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        this.pdf.addAnnotation(pdfAnnotation);
    }

    public void setPdfVersion(char c) {
        this.HEADER[7] = (byte)c;
    }

    class PdfTrailer {
        private byte[] bytes;

        PdfTrailer(int n, int n2, PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2, PdfIndirectReference pdfIndirectReference3, PdfObject pdfObject) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(DocWriter.getISOBytes("trailer\n"));
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.SIZE, new PdfNumber(n));
                pdfDictionary.put(PdfName.ROOT, pdfIndirectReference);
                if (pdfIndirectReference2 != null) {
                    pdfDictionary.put(PdfName.INFO, pdfIndirectReference2);
                }
                if (pdfIndirectReference3 != null) {
                    pdfDictionary.put(PdfName.ENCRYPT, pdfIndirectReference3);
                }
                if (pdfObject != null) {
                    pdfDictionary.put(PdfName.ID, pdfObject);
                }
                byteArrayOutputStream.write(pdfDictionary.toPdf(null));
                byteArrayOutputStream.write(DocWriter.getISOBytes("\nstartxref\n"));
                byteArrayOutputStream.write(DocWriter.getISOBytes(String.valueOf(n2)));
                byteArrayOutputStream.write(DocWriter.getISOBytes("\n%%EOF\n"));
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.bytes = byteArrayOutputStream.toByteArray();
        }

        final byte[] toPdf(PdfWriter pdfWriter) {
            return this.bytes;
        }
    }

    public class PdfBody {
        private int rootOffset;
        private ArrayList xrefs = new ArrayList();
        private int position;
        private PdfWriter writer;

        PdfBody(int n, PdfWriter pdfWriter2) {
            this.xrefs.add(new PdfCrossReference(0, 65535));
            this.xrefs.add(new PdfCrossReference(0));
            this.position = n;
            this.writer = pdfWriter2;
        }

        final PdfIndirectObject add(PdfObject pdfObject) {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(this.size(), pdfObject, this.writer);
            this.xrefs.add(new PdfCrossReference(this.position));
            this.position += pdfIndirectObject.length();
            return pdfIndirectObject;
        }

        final PdfIndirectReference getPdfIndirectReference() {
            this.xrefs.add(new PdfCrossReference(0));
            return new PdfIndirectReference(0, this.size() - 1);
        }

        final int getIndirectReferenceNumber() {
            this.xrefs.add(new PdfCrossReference(0));
            return this.size() - 1;
        }

        final PdfIndirectObject add(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference) {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(pdfIndirectReference.getNumber(), pdfObject, this.writer);
            this.xrefs.set(pdfIndirectReference.getNumber(), new PdfCrossReference(this.position));
            this.position += pdfIndirectObject.length();
            return pdfIndirectObject;
        }

        final PdfIndirectObject add(PdfObject pdfObject, int n) {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(n, pdfObject, this.writer);
            this.xrefs.set(n, new PdfCrossReference(this.position));
            this.position += pdfIndirectObject.length();
            return pdfIndirectObject;
        }

        final PdfIndirectObject add(PdfResources pdfResources) {
            return this.add(pdfResources);
        }

        final PdfIndirectObject add(PdfPages pdfPages) {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(1, pdfPages, this.writer);
            this.rootOffset = this.position;
            this.position += pdfIndirectObject.length();
            return pdfIndirectObject;
        }

        final int offset() {
            return this.position;
        }

        final int size() {
            return this.xrefs.size();
        }

        final byte[] getCrossReferenceTable() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(DocWriter.getISOBytes("xref\n0 "));
                byteArrayOutputStream.write(DocWriter.getISOBytes(String.valueOf(this.size())));
                byteArrayOutputStream.write(DocWriter.getISOBytes("\n"));
                this.xrefs.set(1, new PdfCrossReference(this.rootOffset));
                Iterator iterator = ((AbstractList)this.xrefs).iterator();
                while (iterator.hasNext()) {
                    PdfCrossReference pdfCrossReference = (PdfCrossReference)iterator.next();
                    byteArrayOutputStream.write(pdfCrossReference.toPdf(null));
                }
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            return byteArrayOutputStream.toByteArray();
        }

        class PdfCrossReference {
            private int offset;
            private int generation;

            PdfCrossReference(int n, int n2) {
                this.offset = n;
                this.generation = n2;
            }

            PdfCrossReference(int n) {
                this(n, 0);
            }

            final byte[] toPdf(PdfWriter pdfWriter) {
                String string = "0000000000" + this.offset;
                StringBuffer stringBuffer = new StringBuffer(string.substring(string.length() - 10));
                string = "00000" + this.generation;
                StringBuffer stringBuffer2 = new StringBuffer(string.substring(string.length() - 5));
                if (this.generation == 65535) {
                    return DocWriter.getISOBytes(stringBuffer.append(' ').append((Object)stringBuffer2).append(" f \n").toString());
                }
                return DocWriter.getISOBytes(stringBuffer.append(' ').append((Object)stringBuffer2).append(" n \n").toString());
            }
        }
    }
}

