/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.TrueTypeFontSubSet;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;

class TrueTypeFont
extends BaseFont {
    static final String[] codePages = new String[]{"1252 Latin 1", "1250 Latin 2: Eastern Europe", "1251 Cyrillic", "1253 Greek", "1254 Turkish", "1255 Hebrew", "1256 Arabic", "1257 Windows Baltic", "1258 Vietnamese", null, null, null, null, null, null, null, "874 Thai", "932 JIS/Japan", "936 Chinese: Simplified chars--PRC and Singapore", "949 Korean Wansung", "950 Chinese: Traditional chars--Taiwan and Hong Kong", "1361 Korean Johab", null, null, null, null, null, null, null, "Macintosh Character Set (US Roman)", "OEM Character Set", "Symbol Character Set", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "869 IBM Greek", "866 MS-DOS Russian", "865 MS-DOS Nordic", "864 Arabic", "863 MS-DOS Canadian French", "862 Hebrew", "861 MS-DOS Icelandic", "860 MS-DOS Portuguese", "857 IBM Turkish", "855 IBM Cyrillic; primarily Russian", "852 Latin 2", "775 MS-DOS Baltic", "737 Greek; former 437 G", "708 Arabic; ASMO 708", "850 WE/Latin 1", "437 US"};
    protected HashMap tables;
    protected RandomAccessFileOrArray rf;
    protected String fileName;
    protected int directoryOffset;
    protected String ttcIndex;
    protected String style = "";
    protected FontHeader head = new FontHeader();
    protected HorizontalHeader hhea = new HorizontalHeader();
    protected WindowsMetrics os_2 = new WindowsMetrics();
    protected int[] GlyphWidths;
    protected HashMap cmap10;
    protected HashMap cmap31;
    protected HashMap kerning;
    protected String fontName;
    protected String[][] fullName;
    protected String[][] familyName;
    protected double italicAngle;
    protected boolean isFixedPitch = false;

    protected TrueTypeFont() {
    }

    TrueTypeFont(String string, String string2, boolean bl, byte[] byArray) throws DocumentException, IOException {
        String string3 = BaseFont.getBaseName(string);
        String string4 = TrueTypeFont.getTTCName(string3);
        if (string3.length() < string.length()) {
            this.style = string.substring(string3.length());
        }
        this.encoding = string2;
        this.embedded = bl;
        this.fileName = string4;
        this.fontType = 1;
        this.ttcIndex = "";
        if (string4.length() < string3.length()) {
            this.ttcIndex = string3.substring(string4.length() + 1);
        }
        if (!this.fileName.toLowerCase().endsWith(".ttf") && !this.fileName.toLowerCase().endsWith(".ttc")) {
            throw new DocumentException(this.fileName + this.style + " is not a TTF or TTC font file.");
        }
        this.process(byArray);
        try {
            " ".getBytes(string2);
            this.createEncoding();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DocumentException(unsupportedEncodingException.getMessage());
        }
    }

    protected static String getTTCName(String string) {
        int n = string.toLowerCase().indexOf(".ttc,");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n + 4);
    }

    void fillTables() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("head");
        if (nArray == null) {
            throw new DocumentException("Table 'head' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 16);
        this.head.flags = this.rf.readUnsignedShort();
        this.head.unitsPerEm = this.rf.readUnsignedShort();
        this.rf.skipBytes(16);
        this.head.xMin = this.rf.readShort();
        this.head.yMin = this.rf.readShort();
        this.head.xMax = this.rf.readShort();
        this.head.yMax = this.rf.readShort();
        this.head.macStyle = this.rf.readUnsignedShort();
        nArray = (int[])this.tables.get("hhea");
        if (nArray == null) {
            throw new DocumentException("Table 'hhea' does not exist " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 4);
        this.hhea.Ascender = this.rf.readShort();
        this.hhea.Descender = this.rf.readShort();
        this.hhea.LineGap = this.rf.readShort();
        this.hhea.advanceWidthMax = this.rf.readUnsignedShort();
        this.hhea.minLeftSideBearing = this.rf.readShort();
        this.hhea.minRightSideBearing = this.rf.readShort();
        this.hhea.xMaxExtent = this.rf.readShort();
        this.hhea.caretSlopeRise = this.rf.readShort();
        this.hhea.caretSlopeRun = this.rf.readShort();
        this.rf.skipBytes(12);
        this.hhea.numberOfHMetrics = this.rf.readUnsignedShort();
        nArray = (int[])this.tables.get("OS/2");
        if (nArray == null) {
            throw new DocumentException("Table 'OS/2' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0]);
        int n = this.rf.readUnsignedShort();
        this.os_2.xAvgCharWidth = this.rf.readShort();
        this.os_2.usWeightClass = this.rf.readUnsignedShort();
        this.os_2.usWidthClass = this.rf.readUnsignedShort();
        this.os_2.fsType = this.rf.readShort();
        this.os_2.ySubscriptXSize = this.rf.readShort();
        this.os_2.ySubscriptYSize = this.rf.readShort();
        this.os_2.ySubscriptXOffset = this.rf.readShort();
        this.os_2.ySubscriptYOffset = this.rf.readShort();
        this.os_2.ySuperscriptXSize = this.rf.readShort();
        this.os_2.ySuperscriptYSize = this.rf.readShort();
        this.os_2.ySuperscriptXOffset = this.rf.readShort();
        this.os_2.ySuperscriptYOffset = this.rf.readShort();
        this.os_2.yStrikeoutSize = this.rf.readShort();
        this.os_2.yStrikeoutPosition = this.rf.readShort();
        this.os_2.sFamilyClass = this.rf.readShort();
        this.rf.readFully(this.os_2.panose);
        this.rf.skipBytes(16);
        this.rf.readFully(this.os_2.achVendID);
        this.os_2.fsSelection = this.rf.readUnsignedShort();
        this.os_2.usFirstCharIndex = this.rf.readUnsignedShort();
        this.os_2.usLastCharIndex = this.rf.readUnsignedShort();
        this.os_2.sTypoAscender = this.rf.readShort();
        this.os_2.sTypoDescender = this.rf.readShort();
        this.os_2.sTypoLineGap = this.rf.readShort();
        this.os_2.usWinAscent = this.rf.readUnsignedShort();
        this.os_2.usWinDescent = this.rf.readUnsignedShort();
        this.os_2.ulCodePageRange1 = 0;
        this.os_2.ulCodePageRange2 = 0;
        if (n > 0) {
            this.os_2.ulCodePageRange1 = this.rf.readInt();
            this.os_2.ulCodePageRange2 = this.rf.readInt();
        }
        if (n > 1) {
            this.rf.skipBytes(2);
            this.os_2.sCapHeight = this.rf.readShort();
        } else {
            this.os_2.sCapHeight = (int)(0.7 * (double)this.head.unitsPerEm);
        }
        nArray = (int[])this.tables.get("post");
        if (nArray == null) {
            this.italicAngle = -Math.atan2(this.hhea.caretSlopeRun, this.hhea.caretSlopeRise) * 180.0 / Math.PI;
            return;
        }
        this.rf.seek(nArray[0] + 4);
        short s = this.rf.readShort();
        int n2 = this.rf.readUnsignedShort();
        this.italicAngle = (double)s + (double)n2 / 16384.0;
        this.rf.skipBytes(4);
        this.isFixedPitch = this.rf.readInt() != 0;
    }

    String getBaseFont() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("name");
        if (nArray == null) {
            throw new DocumentException("Table 'name' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 2);
        int n = this.rf.readUnsignedShort();
        int n2 = this.rf.readUnsignedShort();
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.rf.readUnsignedShort();
            int n5 = this.rf.readUnsignedShort();
            int n6 = this.rf.readUnsignedShort();
            int n7 = this.rf.readUnsignedShort();
            int n8 = this.rf.readUnsignedShort();
            int n9 = this.rf.readUnsignedShort();
            if (n7 == 6) {
                this.rf.seek(nArray[0] + n2 + n9);
                if (n4 == 0 || n4 == 3) {
                    return this.readUnicodeString(n8);
                }
                return this.readStandardString(n8);
            }
            ++n3;
        }
        File file = new File(this.fileName);
        return file.getName().replace(' ', '-');
    }

    String[][] getNames(int n) throws DocumentException, IOException {
        int n2;
        int[] nArray = (int[])this.tables.get("name");
        if (nArray == null) {
            throw new DocumentException("Table 'name' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 2);
        int n3 = this.rf.readUnsignedShort();
        int n4 = this.rf.readUnsignedShort();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n5 = 0;
        while (n5 < n3) {
            int n6 = this.rf.readUnsignedShort();
            n2 = this.rf.readUnsignedShort();
            int n7 = this.rf.readUnsignedShort();
            int n8 = this.rf.readUnsignedShort();
            int n9 = this.rf.readUnsignedShort();
            int n10 = this.rf.readUnsignedShort();
            if (n8 == n) {
                int n11 = this.rf.getFilePointer();
                this.rf.seek(nArray[0] + n4 + n10);
                String string = n6 == 0 || n6 == 3 || n6 == 2 && n2 == 1 ? this.readUnicodeString(n9) : this.readStandardString(n9);
                arrayList.add(new String[]{String.valueOf(n6), String.valueOf(n2), String.valueOf(n7), string});
                this.rf.seek(n11);
            }
            ++n5;
        }
        String[][] stringArray = new String[arrayList.size()][];
        n2 = 0;
        while (n2 < arrayList.size()) {
            stringArray[n2] = (String[])arrayList.get(n2);
            ++n2;
        }
        return stringArray;
    }

    void process(byte[] byArray) throws DocumentException, IOException {
        block11: {
            this.tables = new HashMap();
            try {
                int n;
                this.rf = byArray == null ? new RandomAccessFileOrArray(this.fileName) : new RandomAccessFileOrArray(byArray);
                if (this.ttcIndex.length() > 0) {
                    n = Integer.parseInt(this.ttcIndex);
                    if (n < 0) {
                        throw new DocumentException("The font index for " + this.fileName + " must be positive.");
                    }
                    String string = this.readStandardString(4);
                    if (!string.equals("ttcf")) {
                        throw new DocumentException(this.fileName + " is not a valid TTC file.");
                    }
                    this.rf.skipBytes(4);
                    int n2 = this.rf.readInt();
                    if (n >= n2) {
                        throw new DocumentException("The font index for " + this.fileName + " must be between 0 and " + (n2 - 1) + ". It was " + n + ".");
                    }
                    this.rf.skipBytes(n * 4);
                    this.directoryOffset = this.rf.readInt();
                }
                this.rf.seek(this.directoryOffset);
                if (this.rf.readInt() != 65536) {
                    throw new DocumentException(this.fileName + " is not a valid TTF file.");
                }
                n = this.rf.readUnsignedShort();
                this.rf.skipBytes(6);
                int n3 = 0;
                while (n3 < n) {
                    String string = this.readStandardString(4);
                    this.rf.skipBytes(4);
                    int[] nArray = new int[]{this.rf.readInt(), this.rf.readInt()};
                    this.tables.put(string, nArray);
                    ++n3;
                }
                this.fontName = this.getBaseFont();
                this.fullName = this.getNames(4);
                this.familyName = this.getNames(1);
                this.fillTables();
                this.readGlyphWidths();
                this.readCMaps();
                this.readKerning();
                Object var7_8 = null;
                if (this.rf == null) break block11;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (this.rf != null) {
                    this.rf.close();
                    if (!this.embedded) {
                        this.rf = null;
                    }
                }
                throw throwable;
            }
            this.rf.close();
            if (!this.embedded) {
                this.rf = null;
            }
        }
    }

    protected String readStandardString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.rf.readFully(byArray);
        try {
            return new String(byArray, "ISO-8859-1");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    protected String readUnicodeString(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        n /= 2;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.rf.readChar());
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void readGlyphWidths() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("hmtx");
        if (nArray == null) {
            throw new DocumentException("Table 'hmtx' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0]);
        this.GlyphWidths = new int[this.hhea.numberOfHMetrics];
        int n = 0;
        while (n < this.hhea.numberOfHMetrics) {
            this.GlyphWidths[n] = this.rf.readUnsignedShort() * 1000 / this.head.unitsPerEm;
            this.rf.readUnsignedShort();
            ++n;
        }
    }

    public int getGlyphWidth(int n) {
        if (n >= this.GlyphWidths.length) {
            n = this.GlyphWidths.length - 1;
        }
        return this.GlyphWidths[n];
    }

    void readCMaps() throws DocumentException, IOException {
        int n;
        int[] nArray = (int[])this.tables.get("cmap");
        if (nArray == null) {
            throw new DocumentException("Table 'cmap' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0]);
        this.rf.skipBytes(2);
        int n2 = this.rf.readUnsignedShort();
        this.fontSpecific = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            n = this.rf.readUnsignedShort();
            int n6 = this.rf.readUnsignedShort();
            int n7 = this.rf.readInt();
            if (n == 3 && n6 == 0) {
                this.fontSpecific = true;
            } else if (n == 3 && n6 == 1) {
                n4 = n7;
            }
            if (n == 1 && n6 == 0) {
                n3 = n7;
            }
            ++n5;
        }
        if (n3 > 0) {
            this.rf.seek(nArray[0] + n3);
            n = this.rf.readUnsignedShort();
            switch (n) {
                case 0: {
                    this.cmap10 = this.readFormat0();
                    break;
                }
                case 4: {
                    this.cmap10 = this.readFormat4();
                    break;
                }
                case 6: {
                    this.cmap10 = this.readFormat6();
                }
            }
        }
        if (n4 > 0) {
            this.rf.seek(nArray[0] + n4);
            n = this.rf.readUnsignedShort();
            if (n == 4) {
                this.cmap31 = this.readFormat4();
            }
        }
    }

    HashMap readFormat0() throws IOException {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        this.rf.skipBytes(4);
        int n = 0;
        while (n < 256) {
            int[] nArray;
            nArray = new int[]{this.rf.readUnsignedByte(), this.getGlyphWidth(nArray[0])};
            hashMap.put(new Integer(n), nArray);
            ++n;
        }
        return hashMap;
    }

    HashMap readFormat4() throws IOException {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        int n = this.rf.readUnsignedShort();
        this.rf.skipBytes(2);
        int n2 = this.rf.readUnsignedShort() / 2;
        this.rf.skipBytes(6);
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = this.rf.readUnsignedShort();
            ++n3;
        }
        this.rf.skipBytes(2);
        int[] nArray2 = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            nArray2[n4] = this.rf.readUnsignedShort();
            ++n4;
        }
        int[] nArray3 = new int[n2];
        int n5 = 0;
        while (n5 < n2) {
            nArray3[n5] = this.rf.readUnsignedShort();
            ++n5;
        }
        int[] nArray4 = new int[n2];
        int n6 = 0;
        while (n6 < n2) {
            nArray4[n6] = this.rf.readUnsignedShort();
            ++n6;
        }
        int[] nArray5 = new int[n / 2 - 8 - n2 * 4];
        int n7 = 0;
        while (n7 < nArray5.length) {
            nArray5[n7] = this.rf.readUnsignedShort();
            ++n7;
        }
        int n8 = 0;
        while (n8 < n2) {
            int n9 = nArray2[n8];
            while (n9 <= nArray[n8] && n9 != 65535) {
                int[] nArray6;
                int n10;
                if (nArray4[n8] == 0) {
                    n10 = n9 + nArray3[n8] & 0xFFFF;
                } else {
                    int n11 = n8 + nArray4[n8] / 2 - n2 + n9 - nArray2[n8];
                    n10 = nArray5[n11] + nArray3[n8] & 0xFFFF;
                }
                nArray6 = new int[]{n10, this.getGlyphWidth(nArray6[0])};
                hashMap.put(new Integer(n9), nArray6);
                ++n9;
            }
            ++n8;
        }
        return hashMap;
    }

    HashMap readFormat6() throws IOException {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        this.rf.skipBytes(4);
        int n = this.rf.readUnsignedShort();
        int n2 = this.rf.readUnsignedShort();
        int n3 = 0;
        while (n3 < n2) {
            int[] nArray;
            nArray = new int[]{this.rf.readUnsignedShort(), this.getGlyphWidth(nArray[0])};
            hashMap.put(new Integer(n3 + n), nArray);
            ++n3;
        }
        return hashMap;
    }

    void readKerning() throws IOException {
        int[] nArray = (int[])this.tables.get("kern");
        if (nArray == null) {
            return;
        }
        this.rf.seek(nArray[0] + 2);
        int n = this.rf.readUnsignedShort();
        this.kerning = new HashMap();
        int n2 = nArray[0] + 4;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            this.rf.seek(n2 += n3);
            this.rf.skipBytes(2);
            n3 = this.rf.readUnsignedShort();
            int n5 = this.rf.readUnsignedShort();
            if ((n5 & 0xFFF7) == 1) {
                int n6 = this.rf.readUnsignedShort();
                this.rf.skipBytes(6);
                int n7 = 0;
                while (n7 < n6) {
                    Integer n8 = new Integer(this.rf.readInt());
                    Integer n9 = new Integer(this.rf.readShort() * 1000 / this.head.unitsPerEm);
                    this.kerning.put(n8, n9);
                    ++n7;
                }
            }
            ++n4;
        }
    }

    public int getKerning(char c, char c2) {
        Integer n = (Integer)this.kerning.get(new Integer((c << 16) + c2));
        if (n == null) {
            return 0;
        }
        return n;
    }

    protected int getRawWidth(int n, String string) {
        HashMap hashMap = null;
        hashMap = string == null ? this.cmap10 : this.cmap31;
        if (hashMap == null) {
            return 0;
        }
        int[] nArray = (int[])hashMap.get(new Integer(n));
        if (nArray == null) {
            return 0;
        }
        return nArray[1];
    }

    protected PdfDictionary getFontDescriptor(PdfIndirectReference pdfIndirectReference, String string) throws DocumentException {
        PdfDictionary pdfDictionary = new PdfDictionary(new PdfName("FontDescriptor"));
        pdfDictionary.put(new PdfName("Ascent"), new PdfNumber(this.os_2.sTypoAscender * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(new PdfName("CapHeight"), new PdfNumber(this.os_2.sCapHeight * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(new PdfName("Descent"), new PdfNumber(this.os_2.sTypoDescender * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(new PdfName("FontBBox"), new PdfRectangle(this.head.xMin * 1000 / this.head.unitsPerEm, this.head.yMin * 1000 / this.head.unitsPerEm, this.head.xMax * 1000 / this.head.unitsPerEm, this.head.yMax * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(new PdfName("FontName"), new PdfName(string + this.fontName + this.style));
        pdfDictionary.put(new PdfName("ItalicAngle"), new PdfNumber(this.italicAngle));
        pdfDictionary.put(new PdfName("StemV"), new PdfNumber(80));
        if (pdfIndirectReference != null) {
            pdfDictionary.put(new PdfName("FontFile2"), pdfIndirectReference);
        }
        int n = 0;
        if (this.isFixedPitch) {
            n |= 1;
        }
        n |= this.fontSpecific ? 4 : 32;
        if ((this.head.macStyle & 2) != 0) {
            n |= 0x40;
        }
        if ((this.head.macStyle & 1) != 0) {
            n |= 0x40000;
        }
        pdfDictionary.put(new PdfName("Flags"), new PdfNumber(n));
        return pdfDictionary;
    }

    protected PdfDictionary getFontBaseType(PdfIndirectReference pdfIndirectReference, String string, int n, int n2, byte[] byArray) throws DocumentException {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        pdfDictionary.put(PdfName.SUBTYPE, new PdfName("TrueType"));
        pdfDictionary.put(PdfName.BASEFONT, new PdfName(string + this.fontName + this.style));
        if (!this.fontSpecific) {
            int n3 = n;
            while (n3 <= n2) {
                if (!this.differences[n3].equals(".notdef")) {
                    n = n3;
                    break;
                }
                ++n3;
            }
            if (this.encoding.equals("Cp1252") || this.encoding.equals("MacRoman")) {
                pdfDictionary.put(PdfName.ENCODING, this.encoding.equals("Cp1252") ? PdfName.WIN_ANSI_ENCODING : PdfName.MAC_ROMAN_ENCODING);
            } else {
                PdfDictionary pdfDictionary2 = new PdfDictionary(new PdfName("Encoding"));
                PdfArray pdfArray = new PdfArray();
                boolean bl = true;
                int n4 = n;
                while (n4 <= n2) {
                    if (byArray[n4] != 0) {
                        if (bl) {
                            pdfArray.add(new PdfNumber(n4));
                            bl = false;
                        }
                        pdfArray.add(new PdfName(this.differences[n4]));
                    } else {
                        bl = true;
                    }
                    ++n4;
                }
                pdfDictionary2.put(new PdfName("Differences"), pdfArray);
                pdfDictionary.put(PdfName.ENCODING, pdfDictionary2);
            }
        }
        pdfDictionary.put(new PdfName("FirstChar"), new PdfNumber(n));
        pdfDictionary.put(new PdfName("LastChar"), new PdfNumber(n2));
        PdfArray pdfArray = new PdfArray();
        int n5 = n;
        while (n5 <= n2) {
            if (byArray[n5] == 0) {
                pdfArray.add(new PdfNumber(0));
            } else {
                pdfArray.add(new PdfNumber(this.widths[n5]));
            }
            ++n5;
        }
        pdfDictionary.put(new PdfName("Widths"), pdfArray);
        if (pdfIndirectReference != null) {
            pdfDictionary.put(new PdfName("FontDescriptor"), pdfIndirectReference);
        }
        return pdfDictionary;
    }

    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        byte[] byArray = (byte[])objectArray[2];
        if (!this.subset) {
            n = 0;
            n2 = byArray.length - 1;
            int n3 = 0;
            while (n3 < byArray.length) {
                byArray[n3] = 1;
                ++n3;
            }
        }
        PdfIndirectReference pdfIndirectReference2 = null;
        PdfObject pdfObject = null;
        PdfIndirectObject pdfIndirectObject = null;
        String string = "";
        if (this.embedded) {
            Object object;
            string = this.createSubsetPrefix();
            HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
            int n4 = n;
            while (n4 <= n2) {
                if (byArray[n4] != 0 && (object = this.fontSpecific ? this.getMetricsTT(n4) : (Object)this.getMetricsTT(this.unicodeDifferences[n4])) != null) {
                    hashMap.put(new Integer(object[0]), null);
                }
                ++n4;
            }
            object = new TrueTypeFontSubSet(this.fileName, this.rf, hashMap, this.directoryOffset, true);
            byte[] byArray2 = object.process();
            int[] nArray = new int[]{byArray2.length};
            pdfObject = new BaseFont.StreamFont(byArray2, nArray);
            pdfIndirectObject = pdfWriter.addToBody(pdfObject);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        if ((pdfObject = this.getFontDescriptor(pdfIndirectReference2, string)) != null) {
            pdfIndirectObject = pdfWriter.addToBody(pdfObject);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        pdfObject = this.getFontBaseType(pdfIndirectReference2, string, n, n2, byArray);
        pdfWriter.addToBody(pdfObject, pdfIndirectReference);
    }

    public float getFontDescriptor(int n, float f) {
        switch (n) {
            case 1: {
                return (float)this.os_2.sTypoAscender * f / (float)this.head.unitsPerEm;
            }
            case 2: {
                return (float)this.os_2.sCapHeight * f / (float)this.head.unitsPerEm;
            }
            case 3: {
                return (float)this.os_2.sTypoDescender * f / (float)this.head.unitsPerEm;
            }
            case 4: {
                return (float)this.italicAngle;
            }
            case 5: {
                return f * (float)this.head.xMin / (float)this.head.unitsPerEm;
            }
            case 6: {
                return f * (float)this.head.yMin / (float)this.head.unitsPerEm;
            }
            case 7: {
                return f * (float)this.head.xMax / (float)this.head.unitsPerEm;
            }
            case 8: {
                return f * (float)this.head.yMax / (float)this.head.unitsPerEm;
            }
            case 9: {
                return f * (float)this.hhea.Ascender / (float)this.head.unitsPerEm;
            }
            case 10: {
                return f * (float)this.hhea.Descender / (float)this.head.unitsPerEm;
            }
            case 11: {
                return f * (float)this.hhea.LineGap / (float)this.head.unitsPerEm;
            }
            case 12: {
                return f * (float)this.hhea.advanceWidthMax / (float)this.head.unitsPerEm;
            }
        }
        return 0.0f;
    }

    public int[] getMetricsTT(int n) {
        if (!this.fontSpecific && this.cmap31 != null) {
            return (int[])this.cmap31.get(new Integer(n));
        }
        if (this.fontSpecific && this.cmap10 != null) {
            return (int[])this.cmap10.get(new Integer(n));
        }
        return null;
    }

    public String getPostscriptFontName() {
        return this.fontName;
    }

    public String[] getCodePagesSupported() {
        long l = ((long)this.os_2.ulCodePageRange2 << 32) + ((long)this.os_2.ulCodePageRange1 & 0xFFFFFFFFL);
        int n = 0;
        long l2 = 1L;
        int n2 = 0;
        while (n2 < 64) {
            if ((l & l2) != 0L && codePages[n2] != null) {
                ++n;
            }
            l2 <<= 1;
            ++n2;
        }
        String[] stringArray = new String[n];
        n = 0;
        l2 = 1L;
        int n3 = 0;
        while (n3 < 64) {
            if ((l & l2) != 0L && codePages[n3] != null) {
                stringArray[n++] = codePages[n3];
            }
            l2 <<= 1;
            ++n3;
        }
        return stringArray;
    }

    public String[][] getFullFontName() {
        return this.fullName;
    }

    public String[][] getFamilyFontName() {
        return this.familyName;
    }

    protected class WindowsMetrics {
        short xAvgCharWidth;
        int usWeightClass;
        int usWidthClass;
        short fsType;
        short ySubscriptXSize;
        short ySubscriptYSize;
        short ySubscriptXOffset;
        short ySubscriptYOffset;
        short ySuperscriptXSize;
        short ySuperscriptYSize;
        short ySuperscriptXOffset;
        short ySuperscriptYOffset;
        short yStrikeoutSize;
        short yStrikeoutPosition;
        short sFamilyClass;
        byte[] panose = new byte[10];
        byte[] achVendID = new byte[4];
        int fsSelection;
        int usFirstCharIndex;
        int usLastCharIndex;
        short sTypoAscender;
        short sTypoDescender;
        short sTypoLineGap;
        int usWinAscent;
        int usWinDescent;
        int ulCodePageRange1;
        int ulCodePageRange2;
        int sCapHeight;

        protected WindowsMetrics() {
        }
    }

    protected class HorizontalHeader {
        short Ascender;
        short Descender;
        short LineGap;
        int advanceWidthMax;
        short minLeftSideBearing;
        short minRightSideBearing;
        short xMaxExtent;
        short caretSlopeRise;
        short caretSlopeRun;
        int numberOfHMetrics;

        protected HorizontalHeader() {
        }
    }

    protected class FontHeader {
        int flags;
        int unitsPerEm;
        short xMin;
        short yMin;
        short xMax;
        short yMax;
        int macStyle;

        protected FontHeader() {
        }
    }
}

