/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfCell;
import com.lowagie.text.rtf.RtfRow;
import com.lowagie.text.rtf.RtfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfTable {
    private ArrayList rowsList = new ArrayList();
    private RtfWriter writer = null;
    private Table origTable = null;

    public RtfTable(RtfWriter rtfWriter) {
        this.writer = rtfWriter;
    }

    public boolean importTable(Table table, int n) {
        this.origTable = table;
        Iterator iterator = table.iterator();
        Row row = null;
        int n2 = (int)table.widthPercentage();
        int n3 = (int)((double)table.cellpadding() * 20.5714);
        int n4 = (int)((double)table.cellspacing() * 20.5714);
        float[] fArray = table.getProportionalWidths();
        int n5 = table.border();
        Color color = table.borderColor();
        float f = table.borderWidth();
        int n6 = 0;
        while (n6 < table.size()) {
            RtfRow rtfRow = new RtfRow(this.writer, this);
            rtfRow.pregenerateRows(table.columns());
            this.rowsList.add(rtfRow);
            ++n6;
        }
        int n7 = 0;
        while (iterator.hasNext()) {
            row = (Row)iterator.next();
            RtfRow rtfRow = (RtfRow)this.rowsList.get(n7);
            rtfRow.importRow(row, fArray, n2, n, n3, n4, n5, color, f, n7);
            ++n7;
        }
        return true;
    }

    public boolean writeTable(OutputStream outputStream) throws DocumentException, IOException {
        int n = this.rowsList.size();
        int n2 = 0;
        while (n2 < n) {
            RtfRow rtfRow = (RtfRow)this.rowsList.get(n2);
            rtfRow.writeRow(outputStream, n2, this.origTable);
            ++n2;
        }
        outputStream.write(92);
        outputStream.write(RtfWriter.paragraphDefaults);
        outputStream.write(RtfWriter.paragraph);
        return true;
    }

    public void setMerge(int n, int n2, int n3, RtfCell rtfCell) {
        RtfRow rtfRow = (RtfRow)this.rowsList.get(n2);
        rtfRow.setMerge(n, n3, rtfCell);
    }
}

