/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.export;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import dori.jasper.engine.JRAbstractExporter;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JRFont;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRPrintGraphicElement;
import dori.jasper.engine.JRPrintImage;
import dori.jasper.engine.JRPrintLine;
import dori.jasper.engine.JRPrintPage;
import dori.jasper.engine.JRPrintRectangle;
import dori.jasper.engine.JRPrintText;
import dori.jasper.engine.JRReportFont;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.design.JRDesignReportFont;
import dori.jasper.engine.util.JRImageLoader;
import dori.jasper.engine.util.JRLoader;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class JRPdfExporter
extends JRAbstractExporter {
    private JasperPrint jasperPrint = null;
    private Document document = null;
    private PdfContentByte pdfContentByte = null;
    private JRReportFont defaultFont = null;

    private JRReportFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRDesignReportFont();
            }
        }
        return this.defaultFont;
    }

    public void exportReport() throws JRException {
        OutputStream os;
        this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
        if (this.jasperPrint == null) {
            InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
            if (is != null) {
                this.jasperPrint = (JasperPrint)JRLoader.loadObject(is);
            } else {
                URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                if (url != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(url);
                } else {
                    File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                    if (file != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                    } else {
                        String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                        if (fileName != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(fileName);
                        } else {
                            throw new JRException("No input source supplied to the exporter.");
                        }
                    }
                }
            }
        }
        if ((os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM)) == null) {
            File file = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
            if (file != null) {
                try {
                    os = new FileOutputStream(file);
                }
                catch (IOException e) {
                    throw new JRException("Error trying to export to file : " + file, e);
                }
            } else {
                String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                if (fileName != null) {
                    try {
                        os = new FileOutputStream(fileName);
                    }
                    catch (FileNotFoundException e) {
                        throw new JRException("Error trying to export to file : " + fileName, e);
                    }
                } else {
                    throw new JRException("No output specified for the exporter.");
                }
            }
        }
        this.exportReportToStream(os);
    }

    private void exportReportToStream(OutputStream os) throws JRException {
        this.document = new Document(new Rectangle((float)this.jasperPrint.getPageWidth(), (float)this.jasperPrint.getPageHeight()));
        try {
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)os);
            this.document.open();
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                Chunk chunk = null;
                ColumnText colText = null;
                JRPrintPage page = null;
                int i = 1;
                Iterator it = pages.iterator();
                while (it.hasNext()) {
                    page = (JRPrintPage)it.next();
                    this.document.newPage();
                    this.pdfContentByte = pdfWriter.getDirectContent();
                    chunk = new Chunk(" ");
                    chunk.setLocalDestination("JR_PAGE_ANCHOR_" + i);
                    colText = new ColumnText(this.pdfContentByte);
                    colText.setSimpleColumn(new Phrase(chunk), 0.0f, (float)this.jasperPrint.getPageHeight(), 1.0f, 1.0f, 0.0f, 0);
                    colText.go();
                    this.exportPage(page);
                    ++i;
                }
            }
            this.document.close();
        }
        catch (DocumentException e) {
            throw new JRException("PDF Document error : " + this.jasperPrint.getName(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new JRException("Error generating PDF report : " + this.jasperPrint.getName(), e);
        }
    }

    private void exportPage(JRPrintPage page) throws DocumentException, IOException {
        JRPrintElement element = null;
        Collection elements = page.getElements();
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRPrintElement)it.next();
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintGraphicElement)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (!(element instanceof JRPrintText)) continue;
                this.exportText((JRPrintText)element);
            }
        }
    }

    private void exportLine(JRPrintLine line) {
        if (line.getPen() != 0) {
            this.pdfContentByte.setRGBColorStroke(line.getForecolor().getRed(), line.getForecolor().getGreen(), line.getForecolor().getBlue());
            switch (line.getPen()) {
                case 4: {
                    this.pdfContentByte.setLineWidth(1.0f);
                    this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                    break;
                }
                case 3: {
                    this.pdfContentByte.setLineWidth(4.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                case 2: {
                    this.pdfContentByte.setLineWidth(2.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                case 0: {
                    break;
                }
                case 5: {
                    this.pdfContentByte.setLineWidth(0.5f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                default: {
                    this.pdfContentByte.setLineWidth(1.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                }
            }
            if (line.getDirection() == 1) {
                this.pdfContentByte.moveTo((float)line.getX(), (float)(this.jasperPrint.getPageHeight() - line.getY()));
                this.pdfContentByte.lineTo((float)(line.getX() + line.getWidth()), (float)(this.jasperPrint.getPageHeight() - line.getY() - line.getHeight()));
            } else {
                this.pdfContentByte.moveTo((float)line.getX(), (float)(this.jasperPrint.getPageHeight() - line.getY() - line.getHeight()));
                this.pdfContentByte.lineTo((float)(line.getX() + line.getWidth()), (float)(this.jasperPrint.getPageHeight() - line.getY()));
            }
            this.pdfContentByte.stroke();
        }
    }

    private void exportRectangle(JRPrintGraphicElement rectangle) {
        this.pdfContentByte.setRGBColorStroke(rectangle.getForecolor().getRed(), rectangle.getForecolor().getGreen(), rectangle.getForecolor().getBlue());
        this.pdfContentByte.setRGBColorFill(rectangle.getBackcolor().getRed(), rectangle.getBackcolor().getGreen(), rectangle.getBackcolor().getBlue());
        switch (rectangle.getPen()) {
            case 4: {
                this.pdfContentByte.setLineWidth(1.0f);
                this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                break;
            }
            case 3: {
                this.pdfContentByte.setLineWidth(4.0f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 2: {
                this.pdfContentByte.setLineWidth(2.0f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 5: {
                this.pdfContentByte.setLineWidth(0.5f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 0: {
                this.pdfContentByte.setLineWidth(0.0f);
                this.pdfContentByte.setLineDash(0.0f);
                this.pdfContentByte.setRGBColorStroke(rectangle.getBackcolor().getRed(), rectangle.getBackcolor().getGreen(), rectangle.getBackcolor().getBlue());
                break;
            }
            default: {
                this.pdfContentByte.setLineWidth(1.0f);
                this.pdfContentByte.setLineDash(0.0f);
            }
        }
        if (rectangle.getMode() == 1) {
            this.pdfContentByte.rectangle((float)rectangle.getX(), (float)(this.jasperPrint.getPageHeight() - rectangle.getY()), (float)rectangle.getWidth(), (float)(-rectangle.getHeight()));
            this.pdfContentByte.fillStroke();
        } else if (rectangle.getPen() != 0) {
            this.pdfContentByte.rectangle((float)rectangle.getX(), (float)(this.jasperPrint.getPageHeight() - rectangle.getY()), (float)rectangle.getWidth(), (float)(-rectangle.getHeight()));
            this.pdfContentByte.stroke();
        }
    }

    private void exportImage(JRPrintImage printImage) throws DocumentException, IOException {
        this.pdfContentByte.setRGBColorFill(printImage.getBackcolor().getRed(), printImage.getBackcolor().getGreen(), printImage.getBackcolor().getBlue());
        if (printImage.getMode() == 1) {
            this.pdfContentByte.setRGBColorStroke(printImage.getBackcolor().getRed(), printImage.getBackcolor().getGreen(), printImage.getBackcolor().getBlue());
            this.pdfContentByte.setLineWidth(0.1f);
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.rectangle((float)printImage.getX(), (float)(this.jasperPrint.getPageHeight() - printImage.getY()), (float)printImage.getWidth(), (float)(-printImage.getHeight()));
            this.pdfContentByte.fillStroke();
        }
        int borderOffset = 0;
        float lineWidth = 1.0f;
        boolean isLineDotted = false;
        switch (printImage.getPen()) {
            case 4: {
                borderOffset = 0;
                lineWidth = 1.0f;
                isLineDotted = true;
                break;
            }
            case 3: {
                borderOffset = 2;
                lineWidth = 4.0f;
                isLineDotted = false;
                break;
            }
            case 2: {
                borderOffset = 1;
                lineWidth = 2.0f;
                isLineDotted = false;
                break;
            }
            case 5: {
                borderOffset = 0;
                lineWidth = 0.5f;
                isLineDotted = false;
                break;
            }
            case 0: {
                borderOffset = 0;
                lineWidth = 1.0f;
                isLineDotted = false;
                break;
            }
            default: {
                borderOffset = 0;
                lineWidth = 1.0f;
                isLineDotted = false;
            }
        }
        int availableImageWidth = printImage.getWidth() - 2 * borderOffset;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - 2 * borderOffset;
        int n = availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        if (availableImageWidth > 0 && availableImageHeight > 0) {
            Image awtImage = JRImageLoader.loadImage(printImage.getImageData());
            com.lowagie.text.Image image = com.lowagie.text.Image.getInstance((Image)awtImage, null);
            switch (printImage.getScaleImage()) {
                case 1: {
                    BufferedImage bi = new BufferedImage(awtImage.getWidth(null), awtImage.getHeight(null), 1);
                    Graphics g = bi.getGraphics();
                    g.setColor(printImage.getBackcolor());
                    g.fillRect(0, 0, awtImage.getWidth(null), awtImage.getHeight(null));
                    g.drawImage(awtImage, 0, 0, null);
                    int minWidth = awtImage.getWidth(null) <= printImage.getWidth() - 2 * borderOffset ? awtImage.getWidth(null) : printImage.getWidth() - 2 * borderOffset;
                    int minHeight = awtImage.getHeight(null) <= printImage.getHeight() - 2 * borderOffset ? awtImage.getHeight(null) : printImage.getHeight() - 2 * borderOffset;
                    awtImage = bi.getSubimage(0, 0, minWidth, minHeight);
                    image = com.lowagie.text.Image.getInstance((Image)awtImage, null);
                    break;
                }
                case 2: {
                    image.scaleAbsolute((float)(printImage.getWidth() - 2 * borderOffset), (float)(printImage.getHeight() - 2 * borderOffset));
                    break;
                }
                default: {
                    image.scaleToFit((float)(printImage.getWidth() - 2 * borderOffset), (float)(printImage.getHeight() - 2 * borderOffset));
                }
            }
            Chunk chunk = new Chunk(image, 0.0f, 0.0f);
            if (printImage.getAnchorName() != null) {
                chunk.setLocalDestination(printImage.getAnchorName());
            }
            switch (printImage.getHyperlinkType()) {
                case 2: {
                    if (printImage.getHyperlinkReference() == null) break;
                    chunk.setAnchor(printImage.getHyperlinkReference());
                    break;
                }
                case 3: {
                    if (printImage.getHyperlinkAnchor() == null) break;
                    chunk.setLocalGoto(printImage.getHyperlinkAnchor());
                    break;
                }
                case 4: {
                    if (printImage.getHyperlinkPage() == null) break;
                    chunk.setLocalGoto("JR_PAGE_ANCHOR_" + printImage.getHyperlinkPage().toString());
                    break;
                }
                case 5: {
                    if (printImage.getHyperlinkReference() == null || printImage.getHyperlinkAnchor() == null) break;
                    chunk.setRemoteGoto(printImage.getHyperlinkReference(), printImage.getHyperlinkAnchor());
                    break;
                }
                case 6: {
                    if (printImage.getHyperlinkReference() == null || printImage.getHyperlinkPage() == null) break;
                    chunk.setRemoteGoto(printImage.getHyperlinkReference(), printImage.getHyperlinkPage().intValue());
                    break;
                }
            }
            ColumnText colText = new ColumnText(this.pdfContentByte);
            colText.setSimpleColumn(new Phrase(chunk), (float)(printImage.getX() + borderOffset), (float)(this.jasperPrint.getPageHeight() - printImage.getY()) - image.scaledHeight() - (float)borderOffset, (float)(printImage.getX() + borderOffset) + image.scaledWidth(), (float)(this.jasperPrint.getPageHeight() - printImage.getY() - borderOffset), image.scaledHeight(), 0);
            colText.go();
        }
        if (printImage.getPen() != 0) {
            this.pdfContentByte.setRGBColorStroke(printImage.getForecolor().getRed(), printImage.getForecolor().getGreen(), printImage.getForecolor().getBlue());
            this.pdfContentByte.setLineWidth(lineWidth);
            if (isLineDotted) {
                this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
            } else {
                this.pdfContentByte.setLineDash(0.0f);
            }
            this.pdfContentByte.rectangle((float)printImage.getX(), (float)(this.jasperPrint.getPageHeight() - printImage.getY()), (float)printImage.getWidth(), (float)(-printImage.getHeight()));
            this.pdfContentByte.stroke();
        }
    }

    private void exportText(JRPrintText text) throws DocumentException, IOException {
        JRFont jrFont;
        String strText = text.getText();
        if (strText.length() == 0) {
            strText = " ";
        }
        if (text.getMode() == 1) {
            this.pdfContentByte.setRGBColorStroke(text.getBackcolor().getRed(), text.getBackcolor().getGreen(), text.getBackcolor().getBlue());
            this.pdfContentByte.setRGBColorFill(text.getBackcolor().getRed(), text.getBackcolor().getGreen(), text.getBackcolor().getBlue());
            this.pdfContentByte.setLineWidth(0.1f);
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.rectangle((float)text.getX(), (float)(this.jasperPrint.getPageHeight() - text.getY()), (float)text.getWidth(), (float)(-text.getHeight()));
            this.pdfContentByte.fillStroke();
        }
        if ((jrFont = text.getFont()) == null) {
            jrFont = this.getDefaultFont();
        }
        Font font = new Font(BaseFont.createFont((String)jrFont.getPdfFontName(), (String)jrFont.getPdfEncoding(), (boolean)jrFont.isPdfEmbedded()), (float)jrFont.getSize(), (jrFont.isBold() ? 1 : 0) + (jrFont.isItalic() ? 2 : 0) + (jrFont.isUnderline() ? 4 : 0) + (jrFont.isStrikeThrough() ? 8 : 0), text.getForecolor());
        int textAlignment = 0;
        switch (text.getTextAlignment()) {
            case 1: {
                textAlignment = 0;
                break;
            }
            case 2: {
                textAlignment = 1;
                break;
            }
            case 3: {
                textAlignment = 2;
                break;
            }
            case 4: {
                textAlignment = 3;
                break;
            }
            default: {
                textAlignment = 0;
            }
        }
        Chunk chunk = new Chunk(strText, font);
        if (text.getAnchorName() != null) {
            chunk.setLocalDestination(text.getAnchorName());
        }
        switch (text.getHyperlinkType()) {
            case 2: {
                if (text.getHyperlinkReference() == null) break;
                chunk.setAnchor(text.getHyperlinkReference());
                break;
            }
            case 3: {
                if (text.getHyperlinkAnchor() == null) break;
                chunk.setLocalGoto(text.getHyperlinkAnchor());
                break;
            }
            case 4: {
                if (text.getHyperlinkPage() == null) break;
                chunk.setLocalGoto("JR_PAGE_ANCHOR_" + text.getHyperlinkPage().toString());
                break;
            }
            case 5: {
                if (text.getHyperlinkReference() == null || text.getHyperlinkAnchor() == null) break;
                chunk.setRemoteGoto(text.getHyperlinkReference(), text.getHyperlinkAnchor());
                break;
            }
            case 6: {
                if (text.getHyperlinkReference() == null || text.getHyperlinkPage() == null) break;
                chunk.setRemoteGoto(text.getHyperlinkReference(), text.getHyperlinkPage().intValue());
                break;
            }
        }
        ColumnText colText = new ColumnText(this.pdfContentByte);
        colText.setSimpleColumn(new Phrase(chunk), (float)text.getX(), (float)(this.jasperPrint.getPageHeight() - text.getY()), (float)(text.getX() + text.getWidth()), (float)(this.jasperPrint.getPageHeight() - text.getY() - text.getHeight()), text.getAbsoluteLineSpacing(), textAlignment);
        colText.go();
    }
}

