/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.JRElement;
import dori.jasper.engine.JRElementGroup;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExpression;
import dori.jasper.engine.JRGroup;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.fill.JRBaseFiller;
import dori.jasper.engine.fill.JRFillBand;
import dori.jasper.engine.fill.JRFillElementGroup;
import dori.jasper.engine.fill.JRFillObjectFactory;
import dori.jasper.engine.fill.JRTemplateElement;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class JRFillElement
implements JRElement {
    protected JRElement parent = null;
    protected JRTemplateElement template = null;
    protected JRBaseFiller filler = null;
    protected JRGroup printWhenGroupChanges = null;
    protected JRFillElementGroup elementGroup = null;
    protected JRFillBand band = null;
    private boolean isPrintWhenExpressionNull = true;
    private boolean isPrintWhenTrue = true;
    private boolean isToPrint = true;
    private boolean isReprinted = false;
    private boolean isAlreadyPrinted = false;
    private Collection dependantElements = new ArrayList();
    private int relativeY = 0;
    private int stretchHeight = 0;
    private int bandBottomY = 0;

    protected JRFillElement(JRBaseFiller filler, JRElement element, Map fillObjectsMap) {
        fillObjectsMap.put(element, this);
        this.parent = element;
        this.filler = filler;
        this.printWhenGroupChanges = JRFillObjectFactory.getGroup(filler, element.getPrintWhenGroupChanges(), fillObjectsMap);
        this.elementGroup = JRFillObjectFactory.getElementGroup(filler, element.getElementGroup(), fillObjectsMap);
    }

    public byte getPositionType() {
        return this.parent.getPositionType();
    }

    public boolean isPrintRepeatedValues() {
        return this.parent.isPrintRepeatedValues();
    }

    public byte getMode() {
        return this.parent.getMode();
    }

    public int getX() {
        return this.parent.getX();
    }

    public int getY() {
        return this.parent.getY();
    }

    public int getWidth() {
        return this.parent.getWidth();
    }

    public int getHeight() {
        return this.parent.getHeight();
    }

    public boolean isRemoveLineWhenBlank() {
        return this.parent.isRemoveLineWhenBlank();
    }

    public boolean isPrintInFirstWholeBand() {
        return this.parent.isPrintInFirstWholeBand();
    }

    public boolean isPrintWhenDetailOverflows() {
        return this.parent.isPrintWhenDetailOverflows();
    }

    public Color getForecolor() {
        return this.parent.getForecolor();
    }

    public Color getBackcolor() {
        return this.parent.getBackcolor();
    }

    public JRExpression getPrintWhenExpression() {
        return this.parent.getPrintWhenExpression();
    }

    public JRGroup getPrintWhenGroupChanges() {
        return this.printWhenGroupChanges;
    }

    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    protected boolean isPrintWhenExpressionNull() {
        return this.isPrintWhenExpressionNull;
    }

    protected void setPrintWhenExpressionNull(boolean isPrintWhenExpressionNull) {
        this.isPrintWhenExpressionNull = isPrintWhenExpressionNull;
    }

    protected boolean isPrintWhenTrue() {
        return this.isPrintWhenTrue;
    }

    protected void setPrintWhenTrue(boolean isPrintWhenTrue) {
        this.isPrintWhenTrue = isPrintWhenTrue;
    }

    protected boolean isToPrint() {
        return this.isToPrint;
    }

    protected void setToPrint(boolean isToPrint) {
        this.isToPrint = isToPrint;
    }

    protected boolean isReprinted() {
        return this.isReprinted;
    }

    protected void setReprinted(boolean isReprinted) {
        this.isReprinted = isReprinted;
    }

    protected boolean isAlreadyPrinted() {
        return this.isAlreadyPrinted;
    }

    protected void setAlreadyPrinted(boolean isAlreadyPrinted) {
        this.isAlreadyPrinted = isAlreadyPrinted;
    }

    protected JRElement[] getGroupElements() {
        JRElement[] groupElements = null;
        if (this.elementGroup != null) {
            groupElements = this.elementGroup.getElements();
        }
        return groupElements;
    }

    protected Collection getDependantElements() {
        return this.dependantElements;
    }

    protected void addDependantElement(JRElement element) {
        this.dependantElements.add(element);
    }

    protected int getRelativeY() {
        return this.relativeY;
    }

    protected void setRelativeY(int relativeY) {
        this.relativeY = relativeY;
    }

    protected int getStretchHeight() {
        return this.stretchHeight;
    }

    protected void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight > this.getHeight() ? stretchHeight : this.getHeight();
    }

    protected int getBandBottomY() {
        return this.bandBottomY;
    }

    protected void setBandBottomY(int bandBottomY) {
        this.bandBottomY = bandBottomY;
    }

    protected JRFillBand getBand() {
        return this.band;
    }

    protected void setBand(JRFillBand band) {
        this.band = band;
    }

    public void reset() {
        this.relativeY = this.parent.getY();
        this.stretchHeight = this.parent.getHeight();
    }

    protected abstract void evaluate(byte var1) throws JRException;

    protected void evaluatePrintWhenExpression(byte evaluation) throws JRException {
        boolean isPrintWhenExpressionNull = true;
        boolean isPrintWhenTrue = false;
        JRExpression expression = this.getPrintWhenExpression();
        if (expression != null) {
            isPrintWhenExpressionNull = false;
            Boolean printWhenExpressionValue = (Boolean)this.filler.calculator.evaluate(expression, evaluation);
            isPrintWhenTrue = printWhenExpressionValue == null ? false : printWhenExpressionValue;
        }
        this.setPrintWhenExpressionNull(isPrintWhenExpressionNull);
        this.setPrintWhenTrue(isPrintWhenTrue);
    }

    protected abstract JRPrintElement fill() throws JRException;

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        this.setReprinted(false);
        return false;
    }

    protected void stretchElement(int bandStretch) throws JRException {
    }

    protected void moveDependantElements() throws JRException {
        Collection elements = this.getDependantElements();
        if (elements != null && elements.size() > 0) {
            JRFillElement element = null;
            int diffY = 0;
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRFillElement)it.next();
                diffY = element.getY() - this.getY() - this.getHeight() - (element.getRelativeY() - this.getRelativeY() - this.getStretchHeight());
                if (diffY < 0) {
                    diffY = 0;
                }
                element.setRelativeY(element.getRelativeY() + diffY);
            }
        }
    }
}

