/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.JRFont;
import dori.jasper.engine.JRTextElement;
import dori.jasper.engine.design.JRDesignFont;
import dori.jasper.engine.fill.JRBaseFiller;
import dori.jasper.engine.fill.JRFillElement;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class JRFillTextElement
extends JRFillElement
implements JRTextElement {
    private JRFont font = null;
    private Map textAttributes = null;
    private float floatLineSpacing = 0.0f;
    private float absoluteLineSpacing = 0.0f;
    private int textStart = 0;
    private int textEnd = 0;
    private static FontRenderContext fontRenderContext = null;

    protected JRFillTextElement(JRBaseFiller filler, JRTextElement textElement, Map fillObjectsMap) {
        super(filler, textElement, fillObjectsMap);
    }

    public byte getTextAlignment() {
        return ((JRTextElement)this.parent).getTextAlignment();
    }

    public byte getLineSpacing() {
        return ((JRTextElement)this.parent).getLineSpacing();
    }

    public JRFont getFont() {
        if (this.font == null) {
            this.font = ((JRTextElement)this.parent).getFont();
            if (this.font == null) {
                this.font = this.filler.defaultFont;
                if (this.font == null) {
                    this.font = new JRDesignFont();
                }
            }
        }
        return this.font;
    }

    protected float getFloatLineSpacing() {
        if (this.floatLineSpacing == 0.0f) {
            this.floatLineSpacing = 1.0f;
            switch (this.getLineSpacing()) {
                case 0: {
                    this.floatLineSpacing = 1.0f;
                    break;
                }
                case 1: {
                    this.floatLineSpacing = 1.5f;
                    break;
                }
                case 2: {
                    this.floatLineSpacing = 2.0f;
                    break;
                }
                default: {
                    this.floatLineSpacing = 1.0f;
                }
            }
        }
        return this.floatLineSpacing;
    }

    protected static FontRenderContext getFontRenderContext() {
        if (fontRenderContext == null) {
            AffineTransform atrans = new AffineTransform();
            fontRenderContext = new FontRenderContext(atrans, true, true);
        }
        return fontRenderContext;
    }

    protected float getAbsoluteLineSpacing() {
        return this.absoluteLineSpacing;
    }

    protected void setAbsoluteLineSpacing(float absoluteLineSpacing) {
        this.absoluteLineSpacing = absoluteLineSpacing;
    }

    protected int getTextStart() {
        return this.textStart;
    }

    protected void setTextStart(int textStart) {
        this.textStart = textStart;
    }

    protected int getTextEnd() {
        return this.textEnd;
    }

    protected void setTextEnd(int textEnd) {
        this.textEnd = textEnd;
    }

    protected String getText() {
        return null;
    }

    protected void chopTextElement(int availableStretchHeight) {
        if (this.getText() == null || this.getText().length() == 0) {
            return;
        }
        String allText = this.getText().substring(this.getTextEnd());
        if (allText.length() == 0) {
            return;
        }
        float formatWidth = this.getWidth();
        float lineSpacing = this.getFloatLineSpacing();
        int maxHeight = this.getHeight() + availableStretchHeight;
        FontRenderContext fontRenderContext = JRFillTextElement.getFontRenderContext();
        Map fontAttributes = this.getFont().getAttributes();
        AttributedString atext = null;
        AttributedCharacterIterator paragraph = null;
        LineBreakMeasurer lineMeasurer = null;
        TextLayout layout = null;
        int paragraphStart = 0;
        int paragraphEnd = 0;
        float drawPosY = 0.0f;
        float lastDrawPosY = 0.0f;
        String paragr_text = null;
        int strpos = 0;
        int lastPosition = 0;
        int lines = 0;
        boolean isMaxHeightReached = false;
        boolean wasDelim = false;
        StringTokenizer tkzer = new StringTokenizer(allText, "\n", true);
        while (tkzer.hasMoreTokens() && !isMaxHeightReached) {
            paragr_text = tkzer.nextToken();
            if ("\n".equals(paragr_text)) {
                wasDelim = true;
                continue;
            }
            atext = new AttributedString(paragr_text, fontAttributes);
            paragraph = atext.getIterator();
            paragraphStart = paragraph.getBeginIndex();
            paragraphEnd = paragraph.getEndIndex();
            lineMeasurer = new LineBreakMeasurer(paragraph, fontRenderContext);
            lineMeasurer.setPosition(paragraphStart);
            lastPosition = lineMeasurer.getPosition();
            while (lineMeasurer.getPosition() < paragraphEnd && !isMaxHeightReached) {
                layout = lineMeasurer.nextLayout(formatWidth);
                if ((drawPosY += layout.getLeading() + lineSpacing * layout.getAscent()) + layout.getDescent() <= (float)maxHeight) {
                    ++lines;
                    lastPosition = lineMeasurer.getPosition();
                    lastDrawPosY = drawPosY;
                    drawPosY += layout.getDescent();
                    continue;
                }
                drawPosY -= layout.getLeading() + lineSpacing * layout.getAscent();
                isMaxHeightReached = true;
            }
            if (isMaxHeightReached) {
                strpos += lastPosition;
                if (lastPosition <= 0 || !wasDelim) continue;
                ++strpos;
                continue;
            }
            strpos += paragr_text.length();
            if (!wasDelim) continue;
            ++strpos;
        }
        this.setStretchHeight((int)drawPosY + 1);
        this.setTextStart(this.getTextEnd());
        this.setTextEnd(this.getTextStart() + strpos);
        if (lines != 0) {
            this.setAbsoluteLineSpacing((lastDrawPosY - 1.0f) / (float)lines);
        } else {
            this.setAbsoluteLineSpacing(0.0f);
        }
    }
}

