/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.rss;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.apache.commons.digester.rss.Image;
import org.apache.commons.digester.rss.Item;
import org.apache.commons.digester.rss.TextInput;

public class Channel {
    protected ArrayList items = new ArrayList();
    protected ArrayList skipDays = new ArrayList();
    protected ArrayList skipHours = new ArrayList();
    protected String copyright = null;
    protected String description = null;
    protected String docs = null;
    protected Image image = null;
    protected String language = null;
    protected String lastBuildDate = null;
    protected String link = null;
    protected String managingEditor = null;
    protected String pubDate = null;
    protected String rating = null;
    protected TextInput textInput = null;
    protected String title = null;
    protected double version = 0.91;
    protected String webMaster = null;

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDocs() {
        return this.docs;
    }

    public void setDocs(String docs) {
        this.docs = docs;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLastBuildDate() {
        return this.lastBuildDate;
    }

    public void setLastBuildDate(String lastBuildDate) {
        this.lastBuildDate = lastBuildDate;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getManagingEditor() {
        return this.managingEditor;
    }

    public void setManagingEditor(String managingEditor) {
        this.managingEditor = managingEditor;
    }

    public String getPubDate() {
        return this.pubDate;
    }

    public void setPubDate(String pubDate) {
        this.pubDate = pubDate;
    }

    public String getRating() {
        return this.rating;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    public TextInput getTextInput() {
        return this.textInput;
    }

    public void setTextInput(TextInput textInput) {
        this.textInput = textInput;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public double getVersion() {
        return this.version;
    }

    public void setVersion(double version) {
        this.version = version;
    }

    public String getWebMaster() {
        return this.webMaster;
    }

    public void setWebMaster(String webMaster) {
        this.webMaster = webMaster;
    }

    public void addItem(Item item) {
        ArrayList arrayList = this.items;
        synchronized (arrayList) {
            this.items.add(item);
        }
    }

    public void addSkipDay(String skipDay) {
        ArrayList arrayList = this.skipDays;
        synchronized (arrayList) {
            this.skipDays.add(skipDay);
        }
    }

    public void addSkipHour(String skipHour) {
        ArrayList arrayList = this.skipHours;
        synchronized (arrayList) {
            this.skipHours.add(skipHour);
        }
    }

    public Item[] findItems() {
        ArrayList arrayList = this.items;
        synchronized (arrayList) {
            Item[] items = new Item[this.items.size()];
            Item[] itemArray = this.items.toArray(items);
            return itemArray;
        }
    }

    public Item[] getItems() {
        return this.findItems();
    }

    public String[] findSkipDays() {
        ArrayList arrayList = this.skipDays;
        synchronized (arrayList) {
            String[] skipDays = new String[this.skipDays.size()];
            String[] stringArray = this.skipDays.toArray(skipDays);
            return stringArray;
        }
    }

    public String[] getSkipHours() {
        return this.findSkipHours();
    }

    public String[] findSkipHours() {
        ArrayList arrayList = this.skipHours;
        synchronized (arrayList) {
            String[] skipHours = new String[this.skipHours.size()];
            String[] stringArray = this.skipHours.toArray(skipHours);
            return stringArray;
        }
    }

    public String[] getSkipDays() {
        return this.findSkipDays();
    }

    public void removeItem(Item item) {
        ArrayList arrayList = this.items;
        synchronized (arrayList) {
            ((AbstractCollection)this.items).remove(item);
        }
    }

    public void removeSkipDay(String skipDay) {
        ArrayList arrayList = this.skipDays;
        synchronized (arrayList) {
            ((AbstractCollection)this.skipDays).remove(skipDay);
        }
    }

    public void removeSkipHour(String skipHour) {
        ArrayList arrayList = this.skipHours;
        synchronized (arrayList) {
            ((AbstractCollection)this.skipHours).remove(skipHour);
        }
    }

    public void render(OutputStream stream) {
        try {
            this.render(stream, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void render(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        PrintWriter pw = null;
        pw = encoding == null ? new PrintWriter(stream) : new PrintWriter(new OutputStreamWriter(stream, encoding));
        this.render(pw, encoding);
        pw.flush();
    }

    public void render(Writer writer) {
        this.render(writer, null);
    }

    public void render(Writer writer, String encoding) {
        PrintWriter pw = new PrintWriter(writer);
        this.render(pw, encoding);
        pw.flush();
    }

    public void render(PrintWriter writer) {
        this.render(writer, null);
    }

    public void render(PrintWriter writer, String encoding) {
        String[] skipHours;
        String[] skipDays;
        writer.print("<?xml version=\"1.0\"");
        if (encoding != null) {
            writer.print(" encoding=\"");
            writer.print(encoding);
            writer.print("\"");
        }
        writer.println("?>");
        writer.println();
        writer.println("<!DOCTYPE rss PUBLIC");
        writer.println("  \"-//Netscape Communications//DTD RSS 0.91//EN\"");
        writer.println("  \"http://my.netscape.com/publish/formats/rss-0.91.dtd\">");
        writer.println();
        writer.println("<rss version=\"0.91\">");
        writer.println();
        writer.println("  <channel>");
        writer.println();
        writer.print("    <title>");
        writer.print(this.title);
        writer.println("</title>");
        writer.print("    <description>");
        writer.print(this.description);
        writer.println("</description>");
        writer.print("    <link>");
        writer.print(this.link);
        writer.println("</link>");
        writer.print("    <language>");
        writer.print(this.language);
        writer.println("</language>");
        if (this.rating != null) {
            writer.print("    <rating>");
            writer.print(this.rating);
            writer.println("</rating>");
        }
        if (this.copyright != null) {
            writer.print("    <copyright>");
            writer.print(this.copyright);
            writer.print("</copyright>");
        }
        if (this.pubDate != null) {
            writer.print("    <pubDate>");
            writer.print(this.pubDate);
            writer.println("</pubDate>");
        }
        if (this.lastBuildDate != null) {
            writer.print("    <lastBuildDate>");
            writer.print(this.lastBuildDate);
            writer.println("</lastBuildDate>");
        }
        if (this.docs != null) {
            writer.print("    <docs>");
            writer.print(this.docs);
            writer.println("</docs>");
        }
        if (this.managingEditor != null) {
            writer.print("    <managingEditor>");
            writer.print(this.managingEditor);
            writer.println("</managingEditor>");
        }
        if (this.webMaster != null) {
            writer.print("    <webMaster>");
            writer.print(this.webMaster);
            writer.println("</webMaster>");
        }
        writer.println();
        if (this.image != null) {
            this.image.render(writer);
            writer.println();
        }
        if (this.textInput != null) {
            this.textInput.render(writer);
            writer.println();
        }
        if ((skipDays = this.findSkipDays()).length > 0) {
            writer.println("    <skipDays>");
            int i = 0;
            while (i < skipDays.length) {
                writer.print("      <skipDay>");
                writer.print(skipDays[i]);
                writer.println("</skipDay>");
                ++i;
            }
            writer.println("    </skipDays>");
        }
        if ((skipHours = this.findSkipHours()).length > 0) {
            writer.println("    <skipHours>");
            int i = 0;
            while (i < skipHours.length) {
                writer.print("      <skipHour>");
                writer.print(skipHours[i]);
                writer.println("</skipHour>");
                ++i;
            }
            writer.println("    </skipHours>");
            writer.println();
        }
        Item[] items = this.findItems();
        int i = 0;
        while (i < items.length) {
            items[i].render(writer);
            writer.println();
            ++i;
        }
        writer.println("  </channel>");
        writer.println();
        writer.println("</rss>");
    }
}

