/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtils;

public class BeanUtils {
    private static int debug = 0;

    public static int getDebug() {
        return debug;
    }

    public static void setDebug(int newDebug) {
        debug = newDebug;
    }

    public static Object cloneBean(Object bean) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz = bean.getClass();
        Object newBean = clazz.newInstance();
        PropertyUtils.copyProperties(newBean, bean);
        return newBean;
    }

    public static Map describe(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            return new HashMap();
        }
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(bean);
        HashMap<String, String> description = new HashMap<String, String>(descriptors.length);
        int i = 0;
        while (i < descriptors.length) {
            String name = descriptors[i].getName();
            if (descriptors[i].getReadMethod() != null) {
                description.put(name, BeanUtils.getProperty(bean, name));
            }
            ++i;
        }
        return description;
    }

    public static String[] getArrayProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getProperty(bean, name);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            ArrayList<String> values = new ArrayList<String>();
            Iterator items = ((Collection)value).iterator();
            while (items.hasNext()) {
                Object item = items.next();
                if (item == null) {
                    values.add(null);
                    continue;
                }
                values.add(item.toString());
            }
            return values.toArray(new String[values.size()]);
        }
        if (value.getClass().isArray()) {
            ArrayList<String> values = new ArrayList<String>();
            try {
                int n = Array.getLength(value);
                int i = 0;
                while (i < n) {
                    values.add(Array.get(value, i).toString());
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            return values.toArray(new String[values.size()]);
        }
        String[] results = new String[]{value.toString()};
        return results;
    }

    public static String getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getIndexedProperty(bean, name);
        return ConvertUtils.convert(value);
    }

    public static String getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getIndexedProperty(bean, name, index);
        return ConvertUtils.convert(value);
    }

    public static String getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getMappedProperty(bean, name);
        return ConvertUtils.convert(value);
    }

    public static String getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getMappedProperty(bean, name, key);
        return ConvertUtils.convert(value);
    }

    public static String getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getNestedProperty(bean, name);
        return ConvertUtils.convert(value);
    }

    public static String getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return BeanUtils.getNestedProperty(bean, name);
    }

    public static String getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getSimpleProperty(bean, name);
        return ConvertUtils.convert(value);
    }

    public static void populate(Object bean, Map properties) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        Iterator names = properties.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            if (name == null) continue;
            Object value = properties.get(name);
            PropertyDescriptor descriptor = null;
            try {
                descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
            }
            catch (Throwable t) {
                descriptor = null;
            }
            if (descriptor == null) continue;
            Method setter = null;
            if (descriptor instanceof IndexedPropertyDescriptor) {
                setter = ((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod();
            } else if (descriptor instanceof MappedPropertyDescriptor) {
                setter = ((MappedPropertyDescriptor)descriptor).getMappedWriteMethod();
            }
            if (setter == null) {
                setter = descriptor.getWriteMethod();
            }
            if (setter == null) continue;
            Class<?>[] parameterTypes = setter.getParameterTypes();
            Class<?> parameterType = parameterTypes[0];
            if (parameterTypes.length > 1) {
                parameterType = parameterTypes[1];
            }
            Object[] parameters = new Object[1];
            if (parameterTypes[0].isArray()) {
                if (value instanceof String) {
                    String[] values = new String[]{(String)value};
                    parameters[0] = ConvertUtils.convert(values, parameterType);
                } else {
                    parameters[0] = value instanceof String[] ? ConvertUtils.convert((String[])value, parameterType) : value;
                }
            } else {
                parameters[0] = value instanceof String ? ConvertUtils.convert((String)value, parameterType) : (value instanceof String[] ? ConvertUtils.convert(((String[])value)[0], parameterType) : value);
            }
            try {
                PropertyUtils.setProperty(bean, name, parameters[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
    }
}

