package com.businesslogic.ireport.ui;

import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "AboutForm"
 * non viene creato nel metodo main().
 */
public class AboutForm extends Form
{
	public AboutForm()
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		

		edit1.setText(
			"iReport Version 0.0.6\r\n\r\n"
			+"(c) 2002 by Giulio Toffoli\r\n"
			+"gt@businesslogic.it\r\n"
			+"http://ireport.sourceforge.net\r\n\r\n"
			+"License GPL\r\n\r\n"
			+"Special thanks to Teodor Danciu for creating the Jasper Report writer,\r\n"
			+"to Jackie Manning for creating the Jasper Designer,\r\n"
			+"to Mihai Gheorghiu for testing and debugging work and\r\n"
			+"all persons that supports this software."
			);
		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
	}

	/**
	 * AboutForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void edit1_click(Object source, Event e)
	{
		this.dispose();
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	PictureBox pictureBox1 = new PictureBox();
	Label edit1 = new Label();

	private void initForm()
	{
		// NOTA: questo form contiene informazioni relative alle risorse in
		// un file esterno. Non modificare il parametro di tipo String delle
		// chiamate alla funzione resources.getObject(). Ad esempio, non
		// modificare"foo1_location" nella seguente riga di codice,
		// nemmeno se il nome dell'oggetto Foo viene modificato: 
		//	 foo1.setLocation((Point)resources.getObject("foo1_location"));

		IResourceManager resources = new ResourceManager(this, "AboutForm");
		this.setText("About iReport");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_TOOLWINDOW);
		this.setClientSize(new Point(260, 296));
		this.setStartPosition(FormStartPosition.CENTER_SCREEN);

		pictureBox1.setLocation(new Point(4, 4));
		pictureBox1.setSize(new Point(252, 100));
		pictureBox1.setTabIndex(0);
		pictureBox1.setTabStop(false);
		pictureBox1.setText("pictureBox1");
		pictureBox1.setImage((Bitmap)resources.getObject("pictureBox1_image"));

		edit1.setLocation(new Point(4, 100));
		edit1.setSize(new Point(252, 192));
		edit1.setTabIndex(1);
		edit1.setTabStop(false);
		edit1.setText("");
		edit1.setTextAlign(HorizontalAlignment.CENTER);
		edit1.addOnClick(new EventHandler(this.edit1_click));

		this.setNewControls(new Control[] {
							edit1, 
							pictureBox1});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new AboutForm());
	}
}
