/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.base;

import dori.jasper.engine.JRFont;
import dori.jasper.engine.JRReportFont;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class JRBaseFont
implements JRFont,
Serializable {
    private static final long serialVersionUID = 402L;
    private static final String DEFAULT_FONT_NAME = "sansserif";
    private static final String DEFAULT_PDF_FONT_NAME = "Helvetica";
    private static final String DEFAULT_PDF_ENCODING = "Cp1252";
    protected JRReportFont reportFont = null;
    protected String fontName = null;
    protected Boolean isBold = null;
    protected Boolean isItalic = null;
    protected Boolean isUnderline = null;
    protected Boolean isStrikeThrough = null;
    protected Integer size = null;
    protected String pdfFontName = null;
    protected String pdfEncoding = null;
    protected Boolean isPdfEmbedded = null;
    protected Map attributes = null;

    protected JRBaseFont() {
    }

    protected JRBaseFont(JRFont font, Map baseObjectsMap) {
        baseObjectsMap.put(font, this);
        this.reportFont = font.getReportFont();
        this.fontName = font.getFontName();
        this.isBold = new Boolean(font.isBold());
        this.isItalic = new Boolean(font.isItalic());
        this.isUnderline = new Boolean(font.isUnderline());
        this.isStrikeThrough = new Boolean(font.isStrikeThrough());
        this.size = new Integer(font.getSize());
        this.pdfFontName = font.getPdfFontName();
        this.pdfEncoding = font.getPdfEncoding();
        this.isPdfEmbedded = new Boolean(font.isPdfEmbedded());
    }

    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    public String getFontName() {
        String ret = null;
        ret = this.fontName != null ? this.fontName : (this.reportFont != null ? this.reportFont.getFontName() : DEFAULT_FONT_NAME);
        return ret;
    }

    public boolean isBold() {
        boolean ret = false;
        ret = this.isBold != null ? this.isBold : (this.reportFont != null ? this.reportFont.isBold() : false);
        return ret;
    }

    public boolean isItalic() {
        boolean ret = false;
        ret = this.isItalic != null ? this.isItalic : (this.reportFont != null ? this.reportFont.isItalic() : false);
        return ret;
    }

    public boolean isUnderline() {
        boolean ret = false;
        ret = this.isUnderline != null ? this.isUnderline : (this.reportFont != null ? this.reportFont.isUnderline() : false);
        return ret;
    }

    public boolean isStrikeThrough() {
        boolean ret = false;
        ret = this.isStrikeThrough != null ? this.isStrikeThrough : (this.reportFont != null ? this.reportFont.isStrikeThrough() : false);
        return ret;
    }

    public int getSize() {
        int ret = 0;
        ret = this.size != null ? this.size : (this.reportFont != null ? this.reportFont.getSize() : 10);
        return ret;
    }

    public String getPdfFontName() {
        String ret = null;
        ret = this.pdfFontName != null ? this.pdfFontName : (this.reportFont != null ? this.reportFont.getPdfFontName() : DEFAULT_PDF_FONT_NAME);
        return ret;
    }

    public String getPdfEncoding() {
        String ret = null;
        ret = this.pdfEncoding != null ? this.pdfEncoding : (this.reportFont != null ? this.reportFont.getPdfEncoding() : DEFAULT_PDF_ENCODING);
        return ret;
    }

    public boolean isPdfEmbedded() {
        boolean ret = false;
        ret = this.isPdfEmbedded != null ? this.isPdfEmbedded : (this.reportFont != null ? this.reportFont.isPdfEmbedded() : false);
        return ret;
    }

    public Map getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
            if (this.isBold()) {
                this.attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (this.isItalic()) {
                this.attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if (this.isUnderline()) {
                this.attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (this.isStrikeThrough()) {
                this.attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            this.attributes.put(TextAttribute.SIZE, new Float(this.getSize()));
            this.attributes.put(TextAttribute.FAMILY, this.getFontName());
        }
        return this.attributes;
    }
}

