/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.base;

import dori.jasper.engine.JRBand;
import dori.jasper.engine.JRField;
import dori.jasper.engine.JRGroup;
import dori.jasper.engine.JRParameter;
import dori.jasper.engine.JRQuery;
import dori.jasper.engine.JRReport;
import dori.jasper.engine.JRReportFont;
import dori.jasper.engine.JRVariable;
import dori.jasper.engine.base.JRBaseObjectFactory;
import java.io.Serializable;
import java.util.HashMap;

public class JRBaseReport
implements JRReport,
Serializable {
    private static final long serialVersionUID = 402L;
    protected String name = null;
    protected int columnCount = 1;
    protected byte printOrder = 1;
    protected int pageWidth = 595;
    protected int pageHeight = 842;
    protected byte orientation = 1;
    protected byte whenNoDataType = 1;
    protected int columnWidth = 555;
    protected int columnSpacing = 0;
    protected int leftMargin = 20;
    protected int rightMargin = 20;
    protected int topMargin = 30;
    protected int bottomMargin = 30;
    protected boolean isTitleNewPage = false;
    protected boolean isSummaryNewPage = false;
    protected String scriptletClass = null;
    protected JRReportFont defaultFont = null;
    protected JRReportFont[] fonts = null;
    protected JRParameter[] parameters = null;
    protected JRQuery query = null;
    protected JRField[] fields = null;
    protected JRVariable[] variables = null;
    protected JRGroup[] groups = null;
    protected JRBand title = null;
    protected JRBand pageHeader = null;
    protected JRBand columnHeader = null;
    protected JRBand detail = null;
    protected JRBand columnFooter = null;
    protected JRBand pageFooter = null;
    protected JRBand summary = null;

    public JRBaseReport() {
    }

    public JRBaseReport(JRReport report) {
        JRGroup[] jrGroups;
        JRVariable[] jrVariables;
        JRParameter[] jrParameters;
        this.name = report.getName();
        this.columnCount = report.getColumnCount();
        this.printOrder = report.getPrintOrder();
        this.pageWidth = report.getPageWidth();
        this.pageHeight = report.getPageHeight();
        this.orientation = report.getOrientation();
        this.whenNoDataType = report.getWhenNoDataType();
        this.columnWidth = report.getColumnWidth();
        this.columnSpacing = report.getColumnSpacing();
        this.leftMargin = report.getLeftMargin();
        this.rightMargin = report.getRightMargin();
        this.topMargin = report.getTopMargin();
        this.bottomMargin = report.getBottomMargin();
        this.isTitleNewPage = report.isTitleNewPage();
        this.isSummaryNewPage = report.isSummaryNewPage();
        this.scriptletClass = report.getScriptletClass();
        HashMap baseObjectsMap = new HashMap();
        this.defaultFont = JRBaseObjectFactory.getReportFont(report.getDefaultFont(), baseObjectsMap);
        JRReportFont[] jrFonts = report.getFonts();
        if (jrFonts != null && jrFonts.length > 0) {
            this.fonts = new JRReportFont[jrFonts.length];
            int i = 0;
            while (i < this.fonts.length) {
                this.fonts[i] = JRBaseObjectFactory.getReportFont(jrFonts[i], baseObjectsMap);
                ++i;
            }
        }
        if ((jrParameters = report.getParameters()) != null && jrParameters.length > 0) {
            this.parameters = new JRParameter[jrParameters.length];
            int i = 0;
            while (i < this.parameters.length) {
                this.parameters[i] = JRBaseObjectFactory.getParameter(jrParameters[i], baseObjectsMap);
                ++i;
            }
        }
        this.query = JRBaseObjectFactory.getQuery(report.getQuery(), baseObjectsMap);
        JRField[] jrFields = report.getFields();
        if (jrFields != null && jrFields.length > 0) {
            this.fields = new JRField[jrFields.length];
            int i = 0;
            while (i < this.fields.length) {
                this.fields[i] = JRBaseObjectFactory.getField(jrFields[i], baseObjectsMap);
                ++i;
            }
        }
        if ((jrVariables = report.getVariables()) != null && jrVariables.length > 0) {
            this.variables = new JRVariable[jrVariables.length];
            int i = 0;
            while (i < this.variables.length) {
                this.variables[i] = JRBaseObjectFactory.getVariable(jrVariables[i], baseObjectsMap);
                ++i;
            }
        }
        if ((jrGroups = report.getGroups()) != null && jrGroups.length > 0) {
            this.groups = new JRGroup[jrGroups.length];
            int i = 0;
            while (i < this.groups.length) {
                this.groups[i] = JRBaseObjectFactory.getGroup(jrGroups[i], baseObjectsMap);
                ++i;
            }
        }
        this.title = JRBaseObjectFactory.getBand(report.getTitle(), baseObjectsMap);
        this.pageHeader = JRBaseObjectFactory.getBand(report.getPageHeader(), baseObjectsMap);
        this.columnHeader = JRBaseObjectFactory.getBand(report.getColumnHeader(), baseObjectsMap);
        this.detail = JRBaseObjectFactory.getBand(report.getDetail(), baseObjectsMap);
        this.columnFooter = JRBaseObjectFactory.getBand(report.getColumnFooter(), baseObjectsMap);
        this.pageFooter = JRBaseObjectFactory.getBand(report.getPageFooter(), baseObjectsMap);
        this.summary = JRBaseObjectFactory.getBand(report.getSummary(), baseObjectsMap);
    }

    public String getName() {
        return this.name;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public byte getPrintOrder() {
        return this.printOrder;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public byte getOrientation() {
        return this.orientation;
    }

    public byte getWhenNoDataType() {
        return this.whenNoDataType;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public int getColumnSpacing() {
        return this.columnSpacing;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public boolean isTitleNewPage() {
        return this.isTitleNewPage;
    }

    public boolean isSummaryNewPage() {
        return this.isSummaryNewPage;
    }

    public String getScriptletClass() {
        return this.scriptletClass;
    }

    public JRReportFont getDefaultFont() {
        return this.defaultFont;
    }

    public JRReportFont[] getFonts() {
        return this.fonts;
    }

    public JRParameter[] getParameters() {
        return this.parameters;
    }

    public JRQuery getQuery() {
        return this.query;
    }

    public JRField[] getFields() {
        return this.fields;
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    public JRGroup[] getGroups() {
        return this.groups;
    }

    public JRBand getTitle() {
        return this.title;
    }

    public JRBand getPageHeader() {
        return this.pageHeader;
    }

    public JRBand getColumnHeader() {
        return this.columnHeader;
    }

    public JRBand getDetail() {
        return this.detail;
    }

    public JRBand getColumnFooter() {
        return this.columnFooter;
    }

    public JRBand getPageFooter() {
        return this.pageFooter;
    }

    public JRBand getSummary() {
        return this.summary;
    }
}

