/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.print;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.export.JRGraphics2DExporter;
import dori.jasper.engine.export.JRGraphics2DExporterParameter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class JRPrinterAWT
implements Printable {
    private JasperPrint jasperPrint = null;
    private PageFormat pageFormat = null;
    private int pageOffset = 0;

    protected JRPrinterAWT(JasperPrint jrPrint) {
        this.jasperPrint = jrPrint;
    }

    public static boolean printPages(JasperPrint jrPrint, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        JRPrinterAWT printer = new JRPrinterAWT(jrPrint);
        return printer.printPages(firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public static Image printPageToImage(JasperPrint jrPrint, int pageIndex, float zoom) throws JRException {
        JRPrinterAWT printer = new JRPrinterAWT(jrPrint);
        return printer.printPageToImage(pageIndex, zoom);
    }

    private boolean printPages(int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        boolean isOK = true;
        if (firstPageIndex < 0 || firstPageIndex > lastPageIndex || lastPageIndex > this.jasperPrint.getPages().size()) {
            throw new JRException("Invalid page index range : " + firstPageIndex + " - " + lastPageIndex + " of " + this.jasperPrint.getPages().size());
        }
        this.pageOffset = firstPageIndex;
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        switch (this.jasperPrint.getOrientation()) {
            case 2: {
                pageFormat.setOrientation(0);
                paper.setSize(this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                paper.setImageableArea(0.0, 0.0, this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                break;
            }
            default: {
                pageFormat.setOrientation(1);
                paper.setSize(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
                paper.setImageableArea(0.0, 0.0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
            }
        }
        pageFormat.setPaper(paper);
        Book book = new Book();
        book.append(this, pageFormat, lastPageIndex - firstPageIndex + 1);
        printJob.setPageable(book);
        try {
            if (withPrintDialog) {
                if (printJob.printDialog()) {
                    printJob.print();
                } else {
                    isOK = false;
                }
            } else {
                printJob.print();
            }
        }
        catch (Exception ex) {
            throw new JRException("Error printing report.", ex);
        }
        return isOK;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if ((pageIndex += this.pageOffset) < 0 || pageIndex >= this.jasperPrint.getPages().size()) {
            return 1;
        }
        JRGraphics2DExporter exporter = new JRGraphics2DExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
        exporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, (Graphics2D)graphics);
        exporter.setParameter(JRGraphics2DExporterParameter.PAGE_INDEX, new Integer(pageIndex));
        try {
            exporter.exportReport();
        }
        catch (JRException e) {
            e.printStackTrace();
            throw new PrinterException(e.getMessage());
        }
        return 0;
    }

    private Image printPageToImage(int pageIndex, float zoom) throws JRException {
        BufferedImage pageImage = new BufferedImage((int)((float)this.jasperPrint.getPageWidth() * zoom) + 1, (int)((float)this.jasperPrint.getPageHeight() * zoom) + 1, 1);
        JRGraphics2DExporter exporter = new JRGraphics2DExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
        exporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, (Graphics2D)((Image)pageImage).getGraphics());
        exporter.setParameter(JRExporterParameter.PAGE_INDEX, new Integer(pageIndex));
        exporter.setParameter(JRGraphics2DExporterParameter.ZOOM_RATIO, new Float(zoom));
        exporter.exportReport();
        return pageImage;
    }

    static {
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = gEnv.getAvailableFontFamilyNames();
    }
}

