/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.xml;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JRGroup;
import dori.jasper.engine.JRVariable;
import dori.jasper.engine.design.JRDesignElement;
import dori.jasper.engine.design.JRDesignImage;
import dori.jasper.engine.design.JRDesignTextField;
import dori.jasper.engine.design.JRDesignVariable;
import dori.jasper.engine.design.JasperDesign;
import dori.jasper.engine.xml.JRXmlDigester;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JRXmlLoader
implements ErrorHandler {
    private JasperDesign jasperDesign = null;
    private Collection groupReprintedElements = new ArrayList();
    private Collection groupEvaluatedImages = new ArrayList();
    private Collection groupEvaluatedTextFields = new ArrayList();
    private List errors = new ArrayList();
    private int printWhenExpressionsCount = 0;
    private int anchorNameExpressionsCount = 0;
    private int hyperlinkReferenceExpressionsCount = 0;
    private int hyperlinkAnchorExpressionsCount = 0;
    private int hyperlinkPageExpressionsCount = 0;
    private int imagesCount = 0;
    private int textFieldsCount = 0;
    private int subreportsCount = 0;
    private int subreportParametersCount = 0;

    protected JRXmlLoader() {
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }

    public Collection getGroupReprintedElements() {
        return this.groupReprintedElements;
    }

    public Collection getGroupEvaluatedImages() {
        return this.groupEvaluatedImages;
    }

    public Collection getGroupEvaluatedTextFields() {
        return this.groupEvaluatedTextFields;
    }

    public int getPrintWhenExpressionsCount() {
        return this.printWhenExpressionsCount;
    }

    public void setPrintWhenExpressionsCount(int count) {
        this.printWhenExpressionsCount = count;
    }

    public int getAnchorNameExpressionsCount() {
        return this.anchorNameExpressionsCount;
    }

    public void setAnchorNameExpressionsCount(int count) {
        this.anchorNameExpressionsCount = count;
    }

    public int getHyperlinkReferenceExpressionsCount() {
        return this.hyperlinkReferenceExpressionsCount;
    }

    public void setHyperlinkReferenceExpressionsCount(int count) {
        this.hyperlinkReferenceExpressionsCount = count;
    }

    public int getHyperlinkAnchorExpressionsCount() {
        return this.hyperlinkAnchorExpressionsCount;
    }

    public void setHyperlinkAnchorExpressionsCount(int count) {
        this.hyperlinkAnchorExpressionsCount = count;
    }

    public int getHyperlinkPageExpressionsCount() {
        return this.hyperlinkPageExpressionsCount;
    }

    public void setHyperlinkPageExpressionsCount(int count) {
        this.hyperlinkPageExpressionsCount = count;
    }

    public int getImagesCount() {
        return this.imagesCount;
    }

    public void setImagesCount(int count) {
        this.imagesCount = count;
    }

    public int getTextFieldsCount() {
        return this.textFieldsCount;
    }

    public void setTextFieldsCount(int count) {
        this.textFieldsCount = count;
    }

    public int getSubreportsCount() {
        return this.subreportsCount;
    }

    public void setSubreportsCount(int count) {
        this.subreportsCount = count;
    }

    public int getSubreportParametersCount() {
        return this.subreportParametersCount;
    }

    public void setSubreportParametersCount(int count) {
        this.subreportParametersCount = count;
    }

    public static JasperDesign load(String sourceFileName) throws JRException {
        JasperDesign jasperDesign = null;
        JRXmlLoader xmlLoader = new JRXmlLoader();
        jasperDesign = xmlLoader.loadXML(new File(sourceFileName));
        return jasperDesign;
    }

    public static JasperDesign load(File file) throws JRException {
        JasperDesign jasperDesign = null;
        JRXmlLoader xmlLoader = new JRXmlLoader();
        jasperDesign = xmlLoader.loadXML(file);
        return jasperDesign;
    }

    public static JasperDesign load(InputStream is) throws JRException {
        JasperDesign jasperDesign = null;
        JRXmlLoader xmlLoader = new JRXmlLoader();
        jasperDesign = xmlLoader.loadXML(is);
        return jasperDesign;
    }

    private JasperDesign loadXML(File file) throws JRException {
        try {
            JRXmlDigester digester = this.prepareDigester();
            digester.parse(file);
        }
        catch (SAXException e) {
            throw new JRException(e);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        if (this.errors.size() > 0) {
            Exception e = (Exception)this.errors.get(0);
            if (e instanceof JRException) {
                throw (JRException)e;
            }
            throw new JRException(e);
        }
        this.assignGroupsToVariables();
        this.assignGroupsToElements();
        this.assignGroupsToImages();
        this.assignGroupsToTextFields();
        return this.jasperDesign;
    }

    private JasperDesign loadXML(InputStream is) throws JRException {
        try {
            JRXmlDigester digester = this.prepareDigester();
            digester.parse(is);
        }
        catch (SAXException e) {
            throw new JRException(e);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        if (this.errors.size() > 0) {
            Exception e = (Exception)this.errors.get(0);
            if (e instanceof JRException) {
                throw (JRException)e;
            }
            throw new JRException(e);
        }
        this.assignGroupsToVariables();
        this.assignGroupsToElements();
        this.assignGroupsToImages();
        this.assignGroupsToTextFields();
        return this.jasperDesign;
    }

    private JRXmlDigester prepareDigester() throws SAXException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        String validation = System.getProperty("jasper.reports.compile.xml.validation");
        if (validation == null || validation.length() == 0) {
            validation = "true";
        }
        xmlReader.setFeature("http://xml.org/sax/features/validation", Boolean.valueOf(validation));
        JRXmlDigester digester = new JRXmlDigester(xmlReader);
        digester.push(this);
        digester.setErrorHandler(this);
        digester.setValidating(true);
        digester.addFactoryCreate("jasperReport", "dori.jasper.engine.xml.JasperDesignFactory");
        digester.addSetNext("jasperReport", "setJasperDesign", "dori.jasper.engine.design.JasperDesign");
        digester.addFactoryCreate("jasperReport/reportFont", "dori.jasper.engine.xml.JRReportFontFactory");
        digester.addSetNext("jasperReport/reportFont", "addFont", "dori.jasper.engine.JRReportFont");
        digester.addFactoryCreate("jasperReport/parameter", "dori.jasper.engine.xml.JRParameterFactory");
        digester.addSetNext("jasperReport/parameter", "addParameter", "dori.jasper.engine.JRParameter");
        digester.addCallMethod("jasperReport/parameter/parameterDescription", "setDescription", 0);
        digester.addFactoryCreate("jasperReport/parameter/defaultValueExpression", "dori.jasper.engine.xml.JRDefaultValueExpressionFactory");
        digester.addSetNext("jasperReport/parameter/defaultValueExpression", "setDefaultValueExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("jasperReport/parameter/defaultValueExpression", "setText", 0);
        digester.addFactoryCreate("jasperReport/queryString", "dori.jasper.engine.xml.JRQueryFactory");
        digester.addSetNext("jasperReport/queryString", "setQuery", "dori.jasper.engine.JRQuery");
        digester.addCallMethod("jasperReport/queryString", "setText", 0);
        digester.addFactoryCreate("jasperReport/field", "dori.jasper.engine.xml.JRFieldFactory");
        digester.addSetNext("jasperReport/field", "addField", "dori.jasper.engine.JRField");
        digester.addCallMethod("jasperReport/field/fieldDescription", "setDescription", 0);
        digester.addFactoryCreate("jasperReport/variable", "dori.jasper.engine.xml.JRVariableFactory");
        digester.addSetNext("jasperReport/variable", "addVariable", "dori.jasper.engine.design.JRDesignVariable");
        digester.addFactoryCreate("jasperReport/variable/variableExpression", "dori.jasper.engine.xml.JRVariableExpressionFactory");
        digester.addSetNext("jasperReport/variable/variableExpression", "setExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("jasperReport/variable/variableExpression", "setText", 0);
        digester.addFactoryCreate("jasperReport/variable/initialValueExpression", "dori.jasper.engine.xml.JRInitialValueExpressionFactory");
        digester.addSetNext("jasperReport/variable/initialValueExpression", "setInitialValueExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("jasperReport/variable/initialValueExpression", "setText", 0);
        digester.addFactoryCreate("jasperReport/group", "dori.jasper.engine.xml.JRGroupFactory");
        digester.addSetNext("jasperReport/group", "addGroup", "dori.jasper.engine.design.JRDesignGroup");
        digester.addFactoryCreate("jasperReport/group/groupExpression", "dori.jasper.engine.xml.JRGroupExpressionFactory");
        digester.addSetNext("jasperReport/group/groupExpression", "setExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("jasperReport/group/groupExpression", "setText", 0);
        digester.addFactoryCreate("jasperReport/title/band", "dori.jasper.engine.xml.JRBandFactory");
        digester.addSetNext("jasperReport/title/band", "setTitle", "dori.jasper.engine.JRBand");
        digester.addFactoryCreate("jasperReport/pageHeader/band", "dori.jasper.engine.xml.JRBandFactory");
        digester.addSetNext("jasperReport/pageHeader/band", "setPageHeader", "dori.jasper.engine.JRBand");
        digester.addFactoryCreate("jasperReport/columnHeader/band", "dori.jasper.engine.xml.JRBandFactory");
        digester.addSetNext("jasperReport/columnHeader/band", "setColumnHeader", "dori.jasper.engine.JRBand");
        digester.addFactoryCreate("jasperReport/group/groupHeader/band", "dori.jasper.engine.xml.JRBandFactory");
        digester.addSetNext("jasperReport/group/groupHeader/band", "setGroupHeader", "dori.jasper.engine.JRBand");
        digester.addFactoryCreate("jasperReport/detail/band", "dori.jasper.engine.xml.JRBandFactory");
        digester.addSetNext("jasperReport/detail/band", "setDetail", "dori.jasper.engine.JRBand");
        digester.addFactoryCreate("jasperReport/group/groupFooter/band", "dori.jasper.engine.xml.JRBandFactory");
        digester.addSetNext("jasperReport/group/groupFooter/band", "setGroupFooter", "dori.jasper.engine.JRBand");
        digester.addFactoryCreate("jasperReport/columnFooter/band", "dori.jasper.engine.xml.JRBandFactory");
        digester.addSetNext("jasperReport/columnFooter/band", "setColumnFooter", "dori.jasper.engine.JRBand");
        digester.addFactoryCreate("jasperReport/pageFooter/band", "dori.jasper.engine.xml.JRBandFactory");
        digester.addSetNext("jasperReport/pageFooter/band", "setPageFooter", "dori.jasper.engine.JRBand");
        digester.addFactoryCreate("jasperReport/summary/band", "dori.jasper.engine.xml.JRBandFactory");
        digester.addSetNext("jasperReport/summary/band", "setSummary", "dori.jasper.engine.JRBand");
        digester.addFactoryCreate("*/band/printWhenExpression", "dori.jasper.engine.xml.JRPrintWhenExpressionFactory");
        digester.addSetNext("*/band/printWhenExpression", "setPrintWhenExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("*/band/printWhenExpression", "setText", 0);
        digester.addFactoryCreate("*/line", "dori.jasper.engine.xml.JRLineFactory");
        digester.addSetNext("*/line", "addElement", "dori.jasper.engine.design.JRDesignElement");
        digester.addFactoryCreate("*/reportElement", "dori.jasper.engine.xml.JRElementFactory");
        digester.addFactoryCreate("*/reportElement/printWhenExpression", "dori.jasper.engine.xml.JRPrintWhenExpressionFactory");
        digester.addSetNext("*/reportElement/printWhenExpression", "setPrintWhenExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("*/reportElement/printWhenExpression", "setText", 0);
        digester.addFactoryCreate("*/graphicElement", "dori.jasper.engine.xml.JRGraphicElementFactory");
        digester.addFactoryCreate("*/rectangle", "dori.jasper.engine.xml.JRRectangleFactory");
        digester.addSetNext("*/rectangle", "addElement", "dori.jasper.engine.design.JRDesignElement");
        digester.addFactoryCreate("*/image", "dori.jasper.engine.xml.JRImageFactory");
        digester.addSetNext("*/image", "addElement", "dori.jasper.engine.design.JRDesignElement");
        digester.addFactoryCreate("*/image/imageExpression", "dori.jasper.engine.xml.JRImageExpressionFactory");
        digester.addSetNext("*/image/imageExpression", "setExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("*/image/imageExpression", "setText", 0);
        digester.addFactoryCreate("*/staticText", "dori.jasper.engine.xml.JRStaticTextFactory");
        digester.addSetNext("*/staticText", "addElement", "dori.jasper.engine.design.JRDesignElement");
        digester.addCallMethod("*/staticText/text", "setText", 0);
        digester.addFactoryCreate("*/textElement", "dori.jasper.engine.xml.JRTextElementFactory");
        digester.addFactoryCreate("*/textElement/font", "dori.jasper.engine.xml.JRFontFactory");
        digester.addSetNext("*/textElement/font", "setFont", "dori.jasper.engine.JRFont");
        digester.addFactoryCreate("*/textField", "dori.jasper.engine.xml.JRTextFieldFactory");
        digester.addSetNext("*/textField", "addElement", "dori.jasper.engine.design.JRDesignElement");
        digester.addFactoryCreate("*/textField/textFieldExpression", "dori.jasper.engine.xml.JRTextFieldExpressionFactory");
        digester.addSetNext("*/textField/textFieldExpression", "setExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("*/textField/textFieldExpression", "setText", 0);
        digester.addFactoryCreate("*/anchorNameExpression", "dori.jasper.engine.xml.JRAnchorNameExpressionFactory");
        digester.addSetNext("*/anchorNameExpression", "setAnchorNameExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("*/anchorNameExpression", "setText", 0);
        digester.addFactoryCreate("*/hyperlinkReferenceExpression", "dori.jasper.engine.xml.JRHyperlinkReferenceExpressionFactory");
        digester.addSetNext("*/hyperlinkReferenceExpression", "setHyperlinkReferenceExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("*/hyperlinkReferenceExpression", "setText", 0);
        digester.addFactoryCreate("*/hyperlinkAnchorExpression", "dori.jasper.engine.xml.JRHyperlinkAnchorExpressionFactory");
        digester.addSetNext("*/hyperlinkAnchorExpression", "setHyperlinkAnchorExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("*/hyperlinkAnchorExpression", "setText", 0);
        digester.addFactoryCreate("*/hyperlinkPageExpression", "dori.jasper.engine.xml.JRHyperlinkPageExpressionFactory");
        digester.addSetNext("*/hyperlinkPageExpression", "setHyperlinkPageExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("*/hyperlinkPageExpression", "setText", 0);
        digester.addFactoryCreate("*/subreport", "dori.jasper.engine.xml.JRSubreportFactory");
        digester.addSetNext("*/subreport", "addElement", "dori.jasper.engine.design.JRDesignElement");
        digester.addFactoryCreate("*/subreport/subreportParameter", "dori.jasper.engine.xml.JRSubreportParameterFactory");
        digester.addSetNext("*/subreport/subreportParameter", "addParameter", "dori.jasper.engine.JRSubreportParameter");
        digester.addFactoryCreate("*/subreport/parametersMapExpression", "dori.jasper.engine.xml.JRParametersMapExpressionFactory");
        digester.addSetNext("*/subreport/parametersMapExpression", "setParametersMapExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("*/subreport/parametersMapExpression", "setText", 0);
        digester.addFactoryCreate("*/subreport/subreportParameter/subreportParameterExpression", "dori.jasper.engine.xml.JRSubreportParameterExpressionFactory");
        digester.addSetNext("*/subreport/subreportParameter/subreportParameterExpression", "setExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("*/subreport/subreportParameter/subreportParameterExpression", "setText", 0);
        digester.addFactoryCreate("*/subreport/connectionExpression", "dori.jasper.engine.xml.JRConnectionExpressionFactory");
        digester.addSetNext("*/subreport/connectionExpression", "setConnectionExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("*/subreport/connectionExpression", "setText", 0);
        digester.addFactoryCreate("*/subreport/dataSourceExpression", "dori.jasper.engine.xml.JRDataSourceExpressionFactory");
        digester.addSetNext("*/subreport/dataSourceExpression", "setDataSourceExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("*/subreport/dataSourceExpression", "setText", 0);
        digester.addFactoryCreate("*/subreport/subreportExpression", "dori.jasper.engine.xml.JRSubreportExpressionFactory");
        digester.addSetNext("*/subreport/subreportExpression", "setExpression", "dori.jasper.engine.JRExpression");
        digester.addCallMethod("*/subreport/subreportExpression", "setText", 0);
        digester.addFactoryCreate("*/elementGroup", "dori.jasper.engine.xml.JRElementGroupFactory");
        digester.addSetNext("*/elementGroup", "addElementGroup", "dori.jasper.engine.design.JRDesignElementGroup");
        return digester;
    }

    private void assignGroupsToVariables() throws JRException {
        JRVariable[] variables = this.jasperDesign.getVariables();
        if (variables != null && variables.length > 0) {
            Map groupsMap = this.jasperDesign.getGroupsMap();
            JRDesignVariable variable = null;
            String groupName = null;
            JRGroup group = null;
            int i = 0;
            while (i < variables.length) {
                variable = (JRDesignVariable)variables[i];
                if (variable.getResetType() == 4) {
                    groupName = null;
                    group = variable.getResetGroup();
                    if (group != null) {
                        groupName = group.getName();
                        group = (JRGroup)groupsMap.get(groupName);
                    }
                    if (group == null) {
                        throw new JRException("Unknown reset group '" + groupName + "' for variable : " + variable.getName());
                    }
                    variable.setResetGroup(group);
                }
                ++i;
            }
        }
    }

    private void assignGroupsToElements() throws JRException {
        Map groupsMap = this.jasperDesign.getGroupsMap();
        JRDesignElement element = null;
        String groupName = null;
        JRGroup group = null;
        Iterator it = this.groupReprintedElements.iterator();
        while (it.hasNext()) {
            element = (JRDesignElement)it.next();
            groupName = null;
            group = element.getPrintWhenGroupChanges();
            if (group != null) {
                groupName = group.getName();
                group = (JRGroup)groupsMap.get(group.getName());
            }
            if (group == null) {
                throw new JRException("Unknown reprint group '" + groupName + "' for element.");
            }
            element.setPrintWhenGroupChanges(group);
        }
    }

    private void assignGroupsToImages() throws JRException {
        Map groupsMap = this.jasperDesign.getGroupsMap();
        JRDesignImage image = null;
        String groupName = null;
        JRGroup group = null;
        Iterator it = this.groupEvaluatedImages.iterator();
        while (it.hasNext()) {
            image = (JRDesignImage)it.next();
            groupName = null;
            group = image.getEvaluationGroup();
            if (group != null) {
                groupName = group.getName();
                group = (JRGroup)groupsMap.get(group.getName());
            }
            if (group == null) {
                throw new JRException("Unknown evaluation group '" + groupName + "' for image.");
            }
            image.setEvaluationGroup(group);
        }
    }

    private void assignGroupsToTextFields() throws JRException {
        Map groupsMap = this.jasperDesign.getGroupsMap();
        JRDesignTextField textField = null;
        String groupName = null;
        JRGroup group = null;
        Iterator it = this.groupEvaluatedTextFields.iterator();
        while (it.hasNext()) {
            textField = (JRDesignTextField)it.next();
            groupName = null;
            group = textField.getEvaluationGroup();
            if (group != null) {
                groupName = group.getName();
                group = (JRGroup)groupsMap.get(group.getName());
            }
            if (group == null) {
                throw new JRException("Unknown evaluation group '" + groupName + "' for text field.");
            }
            textField.setEvaluationGroup(group);
        }
    }

    public void addError(Exception e) {
        this.errors.add(e);
    }

    public void error(SAXParseException e) {
        this.errors.add(e);
    }

    public void fatalError(SAXParseException e) {
        this.errors.add(e);
    }

    public void warning(SAXParseException e) {
        this.errors.add(e);
    }
}

