import dori.jasper.engine.*;
import dori.jasper.view.*;
import java.util.*;
import java.sql.*;
import java.io.*;


/**
//C:\Documenti\progetti\iReport\src>java -Dorg.xml.sax.driver=org.apache.xerces.pa
//rsers.SAXParser IReportCompiler -jdriverorg.gjt.mm.mysql.Driver -juserroot -jpas
//swdsa -jurljdbc:mysql://localhost/mysql -c -pdf -query"SELECT * FROM USER" C:\Do
//cumenti\progetti\iReport\tmpuser.xml
 */
public class IReportCompiler
{

	public static void main(String[] args)
	{
		String fileName = null;
		boolean compile = false;
		boolean pdf     = false;
		boolean html    = false;
		boolean csv    = false;
		boolean xls    = false;

		String query     = "";
		String jdbDriver = "";
		String jdbcUser  ="";
		String jdbcPassword ="";
		String jdbcUrl   ="";
		String output    ="";
		
		System.setErr(System.out);
		try {
			
		long start = System.currentTimeMillis();
		if(args.length == 0)
		{
			usage();
			System.exit(1);
		}
	
		for (int i=0; i<args.length; ++i)
		{
			//System.out.println(args[i]);
			if (args[i].equals("-c"))  compile = true;
			else if (args[i].equals("-pdf"))
			{
				pdf = true;
			}
			else if (args[i].equals("-html"))
			{
				html = true;
			}
			else if (args[i].equals("-xls"))
			{
				xls = true;
			}
			else if (args[i].equals("-csv"))
			{
				csv = true;
			}
			else if (args[i].startsWith("-jdriver"))
				jdbDriver = args[i].substring(8);
			else if (args[i].startsWith("-juser"))
				jdbcUser = args[i].substring(6);
			else if (args[i].startsWith("-jpasswd"))
				jdbcPassword = args[i].substring(8);
			else if (args[i].startsWith("-jurl"))
				jdbcUrl = args[i].substring(5);
			else if (args[i].equals("-outdir"))
			{
				if (i+1 < args.length) i++;
				output = args[i];
				if (output.charAt(0) == '\"')
				 	output = output.substring(1);
				if (output.charAt(output.length()-1) == '\"')
					output = output.substring(output.length()-1);
				if (output.charAt(output.length()-1) == '\\')
					output = output.substring(output.length()-1);
				
			}
			else if (args[i].equals("-query"))
			{
				if (i+1 < args.length) i++;
				query = args[i].replace('\"',' ');
			}
			else
			{
				fileName = args[i];
				
				if (i+1 != args.length)
				{
					System.out.println("No more params expected after file name ("+fileName+")");
					usage();
					System.exit(1);
				}
			}
		}
		
		if (fileName == null)
		{
			usage();
			System.exit(1);
		}

		System.out.println("File:  "+fileName);
		if (compile);
		{
			
			String srcFileName = new String(fileName);
			fileName = fileName.substring(0,fileName.length()-3)+"jasper";
			if (output.length() >0)
			{
				 fileName = output + fileName.substring(  fileName.lastIndexOf('\\'));  
			}
			System.out.println("Compiling to file... " + fileName);
			System.out.flush();
			JasperCompileManager.compileReportToFile(srcFileName, fileName);
			
			System.out.println("Compilation running time : " + (System.currentTimeMillis() - start));
			System.out.flush();
		}

		dori.jasper.engine.JasperPrint print=null;
		dori.jasper.engine.JRExporter exporter=null;
		 
		String srcFileName = new String(fileName);
		
		if (pdf || csv || html || xls)
		{
			if (jdbDriver.length()>0)
			{
				System.out.println("Opening connection....");
				System.out.flush();
				Class.forName( jdbDriver );
				Connection conn = DriverManager.getConnection(jdbcUrl,
				jdbcUser,
				jdbcPassword); 
				if (query.length()>0)
				{	
					System.out.println("Executing  query " + query);
					System.out.flush();
					Statement stmt = conn.createStatement();
					ResultSet rs = stmt.executeQuery(query);
					
					print = dori.jasper.engine.JasperFillManager.fillReport(srcFileName, null, new JRResultSetDataSource(rs));	
				}
				else
				{
					print = dori.jasper.engine.JasperFillManager.fillReport(srcFileName,null, conn);
				}
			} else {
				print = dori.jasper.engine.JasperFillManager.fillReport(srcFileName, null,new JREmptyDataSource());			
			}	
			if (print != null) 
			{
				System.out.println("Print generated succesfully.");
				System.out.flush();
			}
			else
			{
				System.out.println("Unknow Error occurred generating print.");
				System.out.flush();
			}
			
			if (pdf)
			{
				exporter = new  dori.jasper.engine.export.JRPdfExporter();
				fileName = fileName.substring(0,fileName.length()-6)+"pdf";
				System.out.println("Exporting pdf to file... "+fileName);
			}
			else if (csv) 
			{
				exporter = new  dori.jasper.engine.export.JRCsvExporter();
				fileName = fileName.substring(0,fileName.length()-6)+"csv";
				System.out.println("Exporting CSV to file... "+fileName);
			}
			else if (html) 
			{
				exporter = new  dori.jasper.engine.export.JRHtmlExporter();
				fileName = fileName.substring(0,fileName.length()-6)+"html";
				System.out.println("Exporting HTML to file... "+fileName);
			}
			else if (xls) 
			{
				exporter = new  dori.jasper.engine.export.JRXlsExporter();
				fileName = fileName.substring(0,fileName.length()-6)+"xls";
				System.out.println("Exporting xls to file... "+fileName);
			}

			
			System.out.flush();	
			exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME,fileName);
			exporter.setParameter(JRExporterParameter.JASPER_PRINT,print);
			
			exporter.exportReport();
			
			System.out.println("Running time : " + (System.currentTimeMillis() - start));
			System.out.flush();
			System.exit(0);
		}
						
		}
		catch (JRException e)
		{
			java.io.StringWriter s = new java.io.StringWriter();
			e.printStackTrace(new java.io.PrintWriter(s));
			System.out.println(s);
			System.out.flush();
			System.exit(1);
		}
		catch (Exception e)
		{
			java.io.StringWriter s = new java.io.StringWriter();
			e.printStackTrace(new java.io.PrintWriter(s));
			System.out.println(s);
			System.out.flush();
			System.exit(1);
		}
		
	}


	/**
	 *
	 */
	private static void usage()
	{
		System.out.println( "IReportCompiler usage:" );
		System.out.println( "\tjava IReportCompiler [options] file\n" );
		System.out.println( "\t -c\tcompile file" );
		System.out.println( "\t -pdf\tcreate pdf file" );
		System.out.println( "\t -xls\tcreate xls file" );
		System.out.println( "\t -html\tcreate html file" );
		System.out.println( "\t -csv\tcreate csv file" );
		System.out.println( "\t -jdriver<jdbcdriver>\tuse this JDBC driver" );
		System.out.println( "\t -juser<jdbc user>\tdatabase user" );
		System.out.println( "\t -jpasswd<jdbc pass>\tdatabase password" );
		System.out.println( "\t -jurl<jdbc url>\tJDBC url" );
		System.out.println( "\t -query\"<query>\"\tQuery to execute" );
		System.out.println( "\t -outdir\"<dir>\"\tOutput directory" );
	}


}


