/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport;

import java.util.*;

public class ConnectionEntry
{
	public String driverClass="";
	public String url="";
	public String username="";
	public String password="";
	public String database="";
	public String name="";
	public boolean savepwd=false;
	
	public ConnectionEntry()
	{
		
	}
	
	public void saveIntoProperties(Properties p, int entry)
	{
		p.put("CON"+entry+"_NAME",name);
		p.put("CON"+entry+"_DRIVER",driverClass);
		p.put("CON"+entry+"_URL",url);
		p.put("CON"+entry+"_USERNAME",username);
		p.put("CON"+entry+"_PASSWORD",password);
		p.put("CON"+entry+"_DATABASE",database);
		p.put("CON"+entry+"_SAVE",""+savepwd);
	}
	
	public void loadFromProperties(Properties p, int entry)
	{
		name = (String)p.get("CON"+entry+"_NAME");
		driverClass = (String)p.get("CON"+entry+"_DRIVER");
		url = (String)p.get("CON"+entry+"_URL");
		username = (String)p.get("CON"+entry+"_USERNAME");
		password = (String)p.get("CON"+entry+"_PASSWORD");
		database = (String)p.get("CON"+entry+"_DATABASE");
		savepwd = p.get("CON"+entry+"_SAVE").equals("true");
	}

	public String toString()
	{
		return name;
	}
}
