/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;

import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "PasswordForm"
 * non viene creato nel metodo main().
 */
public class PasswordForm extends Form
{
	String password = "";
	public PasswordForm()
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		

		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
	}
	
	public void setUsername(String un)
	{
		this.edit1.setText(un);
	}

	public String getPassword()
	{
		return password;
	}
	/**
	 * PasswordForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void button1_click(Object source, Event e)
	{
		password = editPassword.getText();
		this.setDialogResult(DialogResult.OK);
		this.dispose();
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	Edit editPassword = new Edit();
	Label label1 = new Label();
	GroupBox groupBox1 = new GroupBox();
	Button button1 = new Button();
	Edit edit1 = new Edit();
	Label label2 = new Label();
	Button button2 = new Button();

	private void initForm()
	{
		this.setText("Login...");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_TOOLWINDOW);
		this.setClientSize(new Point(217, 115));

		editPassword.setLocation(new Point(88, 40));
		editPassword.setSize(new Point(112, 20));
		editPassword.setTabIndex(2);
		editPassword.setText("");
		editPassword.setPasswordChar('*');

		label1.setLocation(new Point(24, 44));
		label1.setSize(new Point(64, 16));
		label1.setTabIndex(3);
		label1.setTabStop(false);
		label1.setText("Password");

		groupBox1.setLocation(new Point(4, 72));
		groupBox1.setSize(new Point(208, 4));
		groupBox1.setTabIndex(4);
		groupBox1.setTabStop(false);
		groupBox1.setText("");

		button1.setLocation(new Point(60, 84));
		button1.setSize(new Point(72, 24));
		button1.setTabIndex(6);
		button1.setText("OK");
		button1.addOnClick(new EventHandler(this.button1_click));

		edit1.setBackColor(Color.INACTIVEBORDER);
		edit1.setLocation(new Point(88, 16));
		edit1.setSize(new Point(112, 20));
		edit1.setTabIndex(0);
		edit1.setTabStop(false);
		edit1.setText("");
		edit1.setReadOnly(true);

		label2.setLocation(new Point(24, 20));
		label2.setSize(new Point(60, 16));
		label2.setTabIndex(1);
		label2.setTabStop(false);
		label2.setText("Username");

		button2.setLocation(new Point(136, 84));
		button2.setSize(new Point(72, 24));
		button2.setTabIndex(5);
		button2.setText("Cancel");
		button2.setDialogResult(DialogResult.CANCEL);

		this.setNewControls(new Control[] {
							button2, 
							label2, 
							edit1, 
							button1, 
							groupBox1, 
							label1, 
							editPassword});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new PasswordForm());
	}
}
